/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.image4j.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends DataInputStream {
    public LittleEndianInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public short readShortLE() throws IOException {
        int n2 = this.read();
        int n3 = this.read();
        if (n2 < 0 || n3 < 0) {
            throw new EOFException();
        }
        short s2 = (short)((n3 << 8) + (n2 << 0));
        return s2;
    }

    public int readIntLE() throws IOException {
        int n2 = this.read();
        int n3 = this.read();
        int n4 = this.read();
        int n5 = this.read();
        if (n2 < -1 || n3 < -1 || n4 < -1 || n5 < -1) {
            throw new EOFException();
        }
        int n6 = (n5 << 24) + (n4 << 16) + (n3 << 8) + (n2 << 0);
        return n6;
    }

    public float readFloatLE() throws IOException {
        int n2 = this.readIntLE();
        float f2 = Float.intBitsToFloat(n2);
        return f2;
    }

    public long readLongLE() throws IOException {
        int n2 = this.readIntLE();
        int n3 = this.readIntLE();
        long l2 = ((long)n2 << 32) + ((long)n3 & 0xFFFFFFFFL);
        return l2;
    }

    public double readDoubleLE() throws IOException {
        long l2 = this.readLongLE();
        double d2 = Double.longBitsToDouble(l2);
        return d2;
    }

    public long readUnsignedInt() throws IOException {
        long l2 = this.readUnsignedByte();
        long l3 = this.readUnsignedByte();
        long l4 = this.readUnsignedByte();
        long l5 = this.readUnsignedByte();
        long l6 = l2 << 24 | l3 << 16 | l4 << 8 | l5;
        return l6;
    }

    public long readUnsignedIntLE() throws IOException {
        long l2 = this.readUnsignedByte();
        long l3 = this.readUnsignedByte();
        long l4 = this.readUnsignedByte();
        long l5 = this.readUnsignedByte();
        long l6 = l5 << 24 | l4 << 16 | l3 << 8 | l2;
        return l6;
    }
}

