/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.image4j.codec.ico;

import com.fr.stable.image4j.codec.bmp.BMPEncoder;
import com.fr.stable.image4j.codec.bmp.InfoHeader;
import com.fr.stable.image4j.codec.ico.IconEntry;
import com.fr.stable.image4j.io.LittleEndianOutputStream;
import com.fr.stable.image4j.util.ConvertUtil;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class ICOEncoder {
    private ICOEncoder() {
    }

    public static void write(BufferedImage bufferedImage, File file) throws IOException {
        ICOEncoder.write(bufferedImage, -1, file);
    }

    public static void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        ICOEncoder.write(bufferedImage, -1, outputStream);
    }

    public static void write(List list, OutputStream outputStream) throws IOException {
        ICOEncoder.write(list, null, null, outputStream);
    }

    public static void write(List list, File file) throws IOException {
        ICOEncoder.write(list, null, file);
    }

    public static void write(List list, int[] nArray, File file) throws IOException {
        ICOEncoder.write(list, nArray, (OutputStream)new FileOutputStream(file));
    }

    public static void write(List list, int[] nArray, boolean[] blArray, File file) throws IOException {
        ICOEncoder.write(list, nArray, blArray, new FileOutputStream(file));
    }

    public static void write(BufferedImage bufferedImage, int n2, File file) throws IOException {
        ICOEncoder.write(bufferedImage, n2, (OutputStream)new FileOutputStream(file));
    }

    public static void write(BufferedImage bufferedImage, int n2, OutputStream outputStream) throws IOException {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>(1);
        arrayList.add(bufferedImage);
        ICOEncoder.write(arrayList, new int[]{n2}, new boolean[]{false}, outputStream);
    }

    public static void write(List list, int[] nArray, OutputStream outputStream) throws IOException {
        ICOEncoder.write(list, nArray, null, outputStream);
    }

    public static void write(List list, int[] nArray, boolean[] blArray, OutputStream outputStream) throws IOException {
        Object object;
        Object object2;
        BufferedImage bufferedImage;
        int n2;
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(outputStream);
        int n3 = list.size();
        ICOEncoder.writeFileHeader(n3, 1, littleEndianOutputStream);
        int n4 = 6 + n3 * 16;
        ArrayList<Object> arrayList = new ArrayList<Object>(n3);
        ArrayList<BufferedImage> arrayList2 = new ArrayList<BufferedImage>(n3);
        ArrayList<byte[]> arrayList3 = null;
        if (blArray != null) {
            arrayList3 = new ArrayList<byte[]>(n3);
        }
        ImageWriter imageWriter = null;
        for (n2 = 0; n2 < n3; ++n2) {
            bufferedImage = (BufferedImage)list.get(n2);
            int n5 = nArray == null ? -1 : nArray[n2];
            object2 = n5 == -1 ? bufferedImage : ICOEncoder.convert(bufferedImage, n5);
            arrayList2.add((BufferedImage)object2);
            object = BMPEncoder.createInfoHeader((BufferedImage)object2);
            IconEntry iconEntry = ICOEncoder.createIconEntry((InfoHeader)object);
            if (blArray != null) {
                if (blArray[n2]) {
                    if (imageWriter == null) {
                        imageWriter = ICOEncoder.getPNGImageWriter();
                    }
                    byte[] byArray = ICOEncoder.encodePNG(imageWriter, (BufferedImage)object2);
                    arrayList3.add(byArray);
                    iconEntry.iSizeInBytes = byArray.length;
                } else {
                    arrayList3.add(null);
                }
            }
            ((InfoHeader)object).iHeight *= 2;
            iconEntry.iFileOffset = n4;
            n4 += iconEntry.iSizeInBytes;
            iconEntry.write(littleEndianOutputStream);
            arrayList.add(object);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            bufferedImage = (BufferedImage)list.get(n2);
            BufferedImage bufferedImage2 = (BufferedImage)arrayList2.get(n2);
            if (blArray == null || !blArray[n2]) {
                object2 = (InfoHeader)arrayList.get(n2);
                ((InfoHeader)object2).write(littleEndianOutputStream);
                if (((InfoHeader)object2).sBitCount <= 8) {
                    object = (IndexColorModel)bufferedImage2.getColorModel();
                    BMPEncoder.writeColorMap((IndexColorModel)object, littleEndianOutputStream);
                }
                ICOEncoder.writeXorBitmap(bufferedImage2, (InfoHeader)object2, littleEndianOutputStream);
                ICOEncoder.writeAndBitmap(bufferedImage, littleEndianOutputStream);
                continue;
            }
            object2 = (byte[])arrayList3.get(n2);
            littleEndianOutputStream.write((byte[])object2);
        }
    }

    public static void writeFileHeader(int n2, int n3, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        littleEndianOutputStream.writeShortLE((short)0);
        littleEndianOutputStream.writeShortLE((short)n3);
        littleEndianOutputStream.writeShortLE((short)n2);
    }

    public static IconEntry createIconEntry(InfoHeader infoHeader) {
        int n2;
        IconEntry iconEntry = new IconEntry();
        iconEntry.bWidth = infoHeader.iWidth == 256 ? 0 : infoHeader.iWidth;
        iconEntry.bHeight = infoHeader.iHeight == 256 ? 0 : infoHeader.iHeight;
        iconEntry.bColorCount = infoHeader.iNumColors >= 256 ? 0 : infoHeader.iNumColors;
        iconEntry.bReserved = 0;
        iconEntry.sPlanes = 1;
        iconEntry.sBitCount = infoHeader.sBitCount;
        int n3 = BMPEncoder.getColorMapSize(infoHeader.sBitCount);
        int n4 = BMPEncoder.getBitmapSize(infoHeader.iWidth, infoHeader.iHeight, infoHeader.sBitCount);
        int n5 = BMPEncoder.getBitmapSize(infoHeader.iWidth, infoHeader.iHeight, 1);
        iconEntry.iSizeInBytes = n2 = infoHeader.iSize + n3 + n4 + n5;
        iconEntry.iFileOffset = 0;
        return iconEntry;
    }

    public static void writeAndBitmap(BufferedImage bufferedImage, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        WritableRaster writableRaster = bufferedImage.getAlphaRaster();
        if (bufferedImage.getColorModel() instanceof IndexColorModel && bufferedImage.getColorModel().hasAlpha()) {
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            int n4 = BMPEncoder.getBytesPerLine1(n2);
            byte[] byArray = new byte[n4];
            IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
            WritableRaster writableRaster2 = bufferedImage.getRaster();
            for (int i2 = n3 - 1; i2 >= 0; --i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n5 = i3 / 8;
                    int n6 = i3 % 8;
                    int n7 = writableRaster2.getSample(i3, i2, 0);
                    int n8 = indexColorModel.getAlpha(n7);
                    int n9 = ~n8 & 1;
                    byArray[n5] = ICOEncoder.setBit(byArray[n5], n6, n9);
                }
                littleEndianOutputStream.write(byArray);
            }
        } else if (writableRaster == null) {
            int n10;
            int n11 = bufferedImage.getHeight();
            int n12 = bufferedImage.getWidth();
            int n13 = BMPEncoder.getBytesPerLine1(n12);
            byte[] byArray = new byte[n13];
            for (n10 = 0; n10 < n13; ++n10) {
                byArray[n10] = 0;
            }
            for (n10 = n11 - 1; n10 >= 0; --n10) {
                littleEndianOutputStream.write(byArray);
            }
        } else {
            int n14 = bufferedImage.getWidth();
            int n15 = bufferedImage.getHeight();
            int n16 = BMPEncoder.getBytesPerLine1(n14);
            byte[] byArray = new byte[n16];
            for (int i4 = n15 - 1; i4 >= 0; --i4) {
                for (int i5 = 0; i5 < n14; ++i5) {
                    int n17 = i5 / 8;
                    int n18 = i5 % 8;
                    int n19 = writableRaster.getSample(i5, i4, 0);
                    int n20 = ~n19 & 1;
                    byArray[n17] = ICOEncoder.setBit(byArray[n17], n18, n20);
                }
                littleEndianOutputStream.write(byArray);
            }
        }
    }

    private static byte setBit(byte by, int n2, int n3) {
        int n4 = 1 << 7 - n2;
        by = (byte)(by & ~n4);
        by = (byte)(by | n3 << 7 - n2);
        return by;
    }

    private static void writeXorBitmap(BufferedImage bufferedImage, InfoHeader infoHeader, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        WritableRaster writableRaster = bufferedImage.getRaster();
        switch (infoHeader.sBitCount) {
            case 1: {
                BMPEncoder.write1(writableRaster, littleEndianOutputStream);
                break;
            }
            case 4: {
                BMPEncoder.write4(writableRaster, littleEndianOutputStream);
                break;
            }
            case 8: {
                BMPEncoder.write8(writableRaster, littleEndianOutputStream);
                break;
            }
            case 24: {
                BMPEncoder.write24(writableRaster, littleEndianOutputStream);
                break;
            }
            case 32: {
                WritableRaster writableRaster2 = bufferedImage.getAlphaRaster();
                BMPEncoder.write32(writableRaster, writableRaster2, littleEndianOutputStream);
            }
        }
    }

    public static BufferedImage convert(BufferedImage bufferedImage, int n2) {
        BufferedImage bufferedImage2 = null;
        switch (n2) {
            case 1: {
                bufferedImage2 = ConvertUtil.convert1(bufferedImage);
                break;
            }
            case 4: {
                bufferedImage2 = ConvertUtil.convert4(bufferedImage);
                break;
            }
            case 8: {
                bufferedImage2 = ConvertUtil.convert8(bufferedImage);
                break;
            }
            case 24: {
                int n3 = bufferedImage.getColorModel().getPixelSize();
                if (n3 == 24 || n3 == 32) {
                    bufferedImage2 = bufferedImage;
                    break;
                }
                bufferedImage2 = ConvertUtil.convert24(bufferedImage);
                break;
            }
            case 32: {
                int n4 = bufferedImage.getColorModel().getPixelSize();
                bufferedImage2 = n4 == 24 || n4 == 32 ? bufferedImage : ConvertUtil.convert32(bufferedImage);
            }
        }
        return bufferedImage2;
    }

    private static ImageWriter getPNGImageWriter() {
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("png");
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        return imageWriter;
    }

    private static byte[] encodePNG(ImageWriter imageWriter, BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(bufferedImage);
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }
}

