/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.CodeUtils;
import com.fr.stable.Consts;
import com.fr.stable.FCloneable;
import com.fr.stable.FormulaProvider;
import com.fr.stable.Mapper;
import com.fr.stable.OperationUtils;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.CalculatorProviderContext;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freehep.graphicsio.swf.SWFGraphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StableUtils {
    public static final String CORE_CONTEXT = "com.fr.base.FRCoreContext";
    private static ClassLoader coreLoader;
    private static int keyLength;
    private static int[] charPosition;
    private static final char[] digits;
    private static final int majorJavaVersion;

    private StableUtils() {
    }

    public static boolean checkDesingerActive(String string) {
        return string != null && string.length() == keyLength && string.charAt(charPosition[0]) == 'A' && string.charAt(charPosition[1]) == 'F';
    }

    public static String[] pathSplit(String string) {
        return string.split("[/\\\\]");
    }

    public static String join(Collection collection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            stringBuffer.append(e2);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String join(Object[] objectArray, String string) {
        return StableUtils.join(Arrays.asList(objectArray), string);
    }

    public static String join(Object[] objectArray) {
        return StableUtils.join(objectArray, "");
    }

    public static String doubleToString(double d2) {
        return StableUtils.convertNumberStringToString(new Double(d2));
    }

    public static String convertNumberStringToString(Number number) {
        return StableUtils.convertNumberStringToString(number, false);
    }

    public static String checkInfinity(Object object) {
        if (OperationUtils.POSITIVE_INFINITY.equals(object)) {
            return "\u221e";
        }
        if (OperationUtils.NEGATIVE_INFINITY.equals(object)) {
            return "-\u221e";
        }
        return "";
    }

    public static String convertNumberStringToString(Number number, boolean bl) {
        String string = StableUtils.checkInfinity(number);
        if (StringUtils.isNotEmpty(string)) {
            return string;
        }
        String string2 = number.toString();
        int n2 = string2.indexOf(46);
        if (n2 < 0) {
            return string2;
        }
        int n3 = string2.indexOf(69);
        string2 = StableUtils.stringAfterCheckE(string2, n2, n3);
        n2 = string2.indexOf(46);
        if (bl || n2 == -1 || number instanceof BigDecimal) {
            if (string2.endsWith(".0")) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            return string2;
        }
        String string3 = string2.substring(n2 + 1);
        int n4 = string3.indexOf("9999");
        if (n4 >= 0) {
            long l2;
            double d2 = Double.parseDouble(string2);
            if (n4 == 0) {
                return Long.toString(Math.round(d2));
            }
            if (Math.abs(d2) > 9.223372036854776E18) {
                String string4 = Double.toString(d2);
                int n5 = string4.indexOf(".");
                if (n5 > 0 && string4.length() - n5 - 1 > n4) {
                    string4 = string4.substring(0, n5 + n4 + 1);
                }
                if (string4.endsWith(".0")) {
                    return string4.substring(0, string4.length() - 2);
                }
                return string4;
            }
            String string5 = d2 < 0.0 ? "-" : "";
            long l3 = (long)Math.pow(10.0, n4 - 1);
            long l4 = l3 * 10L;
            if (l3 == Long.MAX_VALUE || l4 == Long.MAX_VALUE) {
                return string2;
            }
            d2 = Math.abs(d2);
            long l5 = Math.round(d2 * (double)l4);
            String string6 = string5 + Long.toString(l5 / l4);
            long l6 = l2 = l4 == 0L ? 0L : l5 % l4;
            if (l2 < 0L) {
                return string2;
            }
            if (l2 == 0L) {
                StringBuffer stringBuffer = new StringBuffer("");
                for (int i2 = n4; i2 > 0; --i2) {
                    stringBuffer.insert(0, "0");
                }
                return string6 + "." + stringBuffer;
            }
            StringBuffer stringBuffer = new StringBuffer(Long.toString(l2));
            while (l2 < l3) {
                l2 *= 10L;
                stringBuffer.insert(0, "0");
            }
            return string6 + "." + stringBuffer;
        }
        n4 = string3.indexOf("0000");
        if (n4 >= 0 && n3 == -1) {
            string2 = string2.substring(0, n2 + Math.max(n4, 1) + 1);
        }
        if (string2.endsWith(".0")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    private static String stringAfterCheckE(String string, int n2, int n3) {
        if (StableUtils.needConvert(n2, n3, string)) {
            int n4;
            String string2 = string.substring(0, n3);
            StringBuffer stringBuffer = new StringBuffer(string2.substring(n2 + 1));
            stringBuffer.insert(0, string2.substring(0, n2));
            String string3 = string.substring(n3 + 1);
            if (string3.startsWith("+")) {
                string3 = string3.substring(1);
            }
            if ((n4 = Integer.parseInt(string3)) <= 0) {
                while (stringBuffer.charAt(stringBuffer.length() - 1) == '0') {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
                for (int i2 = 0; i2 < -n4; ++i2) {
                    stringBuffer.insert(n2 - 1, "0");
                }
                stringBuffer.insert(n2, ".");
            } else if (stringBuffer.length() - n2 > n4) {
                stringBuffer.insert(n4 + n2, '.');
            } else {
                while (stringBuffer.length() - n2 < n4) {
                    stringBuffer.append('0');
                }
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private static boolean needConvert(int n2, int n3, String string) {
        return n2 == 1 && n3 > 0 || n2 == 2 && n3 > 0 && (string.startsWith("-") || string.startsWith("+"));
    }

    public static Number string2Number(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("+")) {
            string = string.substring(1, string.length());
        }
        if (StableUtils.isStartWithZeroAndCannotbeDecimal(string)) {
            return null;
        }
        if (string.matches("[\\-]?\\d+")) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return new BigInteger(string);
            }
        }
        if (string.matches("[\\-]?\\d+([\\.]\\d+)?([Ee][\\-\\+]?\\d+)?")) {
            try {
                Double d2 = Double.valueOf(string);
                if (d2.toString().equals(string)) {
                    return d2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new BigDecimal(string);
        }
        return null;
    }

    private static boolean isStartWithZeroAndCannotbeDecimal(String string) {
        return string.startsWith("0") && string.length() > 1 && !string.startsWith("0E") && !string.startsWith("0.") || string.startsWith("-0") && string.length() > 2 && !string.startsWith("-0E") && !string.startsWith("-0.");
    }

    public static String replaceAllString(String string, String[] stringArray, String[] stringArray2) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string = StableUtils.replaceAllString(string, stringArray[i2], stringArray2[i2]);
        }
        return string;
    }

    public static String replaceAllString(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\\Q" + string2 + "\\E", StableUtils.filterString(string3));
    }

    private static String filterString(String string) {
        if (string.indexOf(36) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '$') {
                stringBuffer.append("\\$");
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String javaColorToCSSColor(Color color) {
        if (color == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("rgb(");
        stringBuffer.append(color.getRed());
        stringBuffer.append(',');
        stringBuffer.append(color.getGreen());
        stringBuffer.append(',');
        stringBuffer.append(color.getBlue());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String javaColor2JSColorWithAlpha(Color color) {
        if (color == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("rgba(");
        stringBuffer.append(color.getRed());
        stringBuffer.append(',');
        stringBuffer.append(color.getGreen());
        stringBuffer.append(',');
        stringBuffer.append(color.getBlue());
        stringBuffer.append(',');
        stringBuffer.append((double)color.getAlpha() / 255.0);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String javaColor2String(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((double)color.getRed() / 255.0);
        stringBuffer.append(",");
        stringBuffer.append((double)color.getGreen() / 255.0);
        stringBuffer.append(",");
        stringBuffer.append((double)color.getBlue() / 255.0);
        stringBuffer.append(",");
        stringBuffer.append((double)color.getAlpha() / 255.0);
        stringBuffer.append(",");
        return stringBuffer.toString();
    }

    public static int changeImageLayout4Draw(Image image, int n2, int n3, int n4) {
        if (image != null && n2 == 1 && (image.getWidth(null) > n3 || image.getHeight(null) > n4)) {
            n2 = 0;
        }
        return n2;
    }

    public static String readSpecailString(String string) throws Exception {
        if (string == null) {
            return "";
        }
        Pattern pattern = Pattern.compile("\\\\");
        Matcher matcher = pattern.matcher(string);
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find(n2)) {
            n2 = matcher.start();
            stringBuffer.append(string.substring(n3, n2));
            n3 = matcher.end();
            String string2 = string.substring(n3);
            if (string2.length() == 0) {
                throw new Exception("\\ can't be parsed.");
            }
            char c2 = string2.charAt(0);
            switch (c2) {
                case 'n': {
                    stringBuffer.append('\n');
                    ++n3;
                    break;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    ++n3;
                    break;
                }
                case 't': {
                    stringBuffer.append('\t');
                    ++n3;
                    break;
                }
                case 'b': {
                    stringBuffer.append('\b');
                    ++n3;
                    break;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    ++n3;
                    break;
                }
                case '\"': {
                    stringBuffer.append('\"');
                    ++n3;
                    break;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    ++n3;
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    ++n3;
                    break;
                }
                case 'u': {
                    String string3 = string.substring(n3);
                    if (string3.length() < 4) {
                        throw new Exception("\\u" + string3 + " can't be parsed.");
                    }
                    stringBuffer.append(StableUtils.parseHex(string3.substring(0, 4)));
                    n3 += 5;
                    break;
                }
                default: {
                    int n4 = 0;
                    if (string2.matches("[0-3][0-7][0-7].*")) {
                        n4 = 3;
                    } else if (string2.matches("[0-7][0-7].*")) {
                        n4 = 2;
                    } else if (string2.matches("[0-7].*")) {
                        n4 = 1;
                    }
                    if (n4 > 0) {
                        stringBuffer.append(StableUtils.parseOctal(string.substring(n3, n3 + n4)));
                        n3 += n4;
                        break;
                    }
                    throw new Exception("\\" + string2 + " can't be parsed.");
                }
            }
            n2 = n3;
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    private static char parseHex(String string) {
        return (char)Integer.decode("0x" + string).intValue();
    }

    private static char parseOctal(String string) {
        return (char)Integer.decode('0' + string).intValue();
    }

    public static String writeSpecialString(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        block10: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block10;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block10;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block10;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block10;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block10;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Method getDeclaredMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            clazz = clazz.getSuperclass();
            if (clazz != null) {
                return StableUtils.getDeclaredMethod(clazz, string, classArray);
            }
            return null;
        }
    }

    public static String pathJoin(String[] stringArray) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 = stringArray == null ? 0 : stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (string == null) {
                string = "";
            }
            if (i2 > 0 && (string.startsWith("/") || string.startsWith("\\"))) {
                string = string.substring(1);
            }
            stringBuffer.append(string);
            if (i2 + 1 >= n2 || string.endsWith("/") || string.endsWith("\\")) continue;
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    public static String[] splitString(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        return string.split("\\Q" + string2 + "\\E");
    }

    public static String[] splitString(String string, char c2) {
        return StableUtils.splitString(string, "" + c2);
    }

    public static int convertABCToInt(String string) {
        int n2 = 0;
        Character c2 = new Character('A');
        string = string.toUpperCase();
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = Character.getNumericValue(string.charAt(i2)) - Character.getNumericValue(c2.charValue()) + 26 * n2 + 1;
            if (n2 <= (0x7FFFFFFE - Character.getNumericValue(string.charAt(i2)) + Character.getNumericValue(c2.charValue())) / 26) continue;
            return 0;
        }
        return n2;
    }

    public static String convertIntToABC(int n2) {
        int n3 = n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (n3 == 0) {
            return "";
        }
        while (n3 != 0) {
            int n4 = n3 % 26;
            if (n4 == 0) {
                n4 = 26;
            }
            stringBuffer.insert(0, digits[n4 - 1]);
            n3 = (n3 - n4) / 26;
        }
        return stringBuffer.toString();
    }

    public static String replaceScript4Xss(String string) {
        if (StringUtils.isEmpty(string)) {
            return "";
        }
        Pattern pattern = Pattern.compile("<[^>]+>", 2);
        Matcher matcher = pattern.matcher(string);
        string = matcher.replaceAll("");
        pattern = Pattern.compile("<[/s]*?script[^>]*?>[/s/S]*?<[/s]*?//[/s]*?script[/s]*?>", 2);
        matcher = pattern.matcher(string);
        string = matcher.replaceAll("");
        return string;
    }

    public static String getInstallHome() {
        String string = System.getProperty("user.dir");
        if (string == null) {
            return ".";
        }
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].indexOf(".exe") == -1) continue;
                return file.getParent();
            }
        }
        return ".";
    }

    public static <T> T getInstance(Class<? extends T> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            return (T)method.invoke(clazz, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean deleteFile(File file) {
        if (file == null || !file.exists()) {
            return true;
        }
        boolean bl = true;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (StableUtils.deleteFile(fileArray[i2]) || !bl) continue;
                bl = false;
            }
        }
        bl = file.delete() && bl;
        return bl;
    }

    public static boolean mkdirs(File file) {
        return file.exists() || file.mkdirs();
    }

    public static boolean makesureFileExist(File file) throws IOException {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        StableUtils.mkdirs(file.getParentFile());
        file.createNewFile();
        return true;
    }

    public static List map(List list, Mapper mapper) {
        int n2 = list.size();
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = mapper.map(i2, list.get(i2), list);
        }
        return Arrays.asList(objectArray);
    }

    public static boolean maybeFormula(String string) {
        return !StringUtils.isBlank(string) && string.startsWith("=");
    }

    public static int getMajorJavaVersion() {
        return majorJavaVersion;
    }

    public static boolean isNotSupportARGB(Graphics graphics) {
        return graphics instanceof SWFGraphics2D;
    }

    public static Object invokeMethod(ClassLoader classLoader, String string, String string2, Class[] classArray, Object[] objectArray) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return null;
        }
        try {
            Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            Method method = clazz.getMethod(string2, classArray);
            method.setAccessible(true);
            return method.invoke(clazz, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object invokeMethod(String string, String string2, Class[] classArray, Object[] objectArray) {
        return StableUtils.invokeMethod(null, string, string2, classArray, objectArray);
    }

    public static Object invokeMethod(ClassLoader classLoader, String string, String string2) {
        return StableUtils.invokeMethod(classLoader, string, string2, new Class[0], new Object[0]);
    }

    public static Object invokeMethod(String string, String string2) {
        return StableUtils.invokeMethod(string, string2, new Class[0], new Object[0]);
    }

    public static byte[] getBytes() {
        return (byte[])StableUtils.invokeMethod(coreLoader, CORE_CONTEXT, "getBytes");
    }

    public static void resetBytes() {
        StableUtils.invokeMethod(coreLoader, CORE_CONTEXT, "resetBytes");
    }

    public static void retryLicLock() {
        StableUtils.invokeMethod(coreLoader, CORE_CONTEXT, "retryLicLock");
    }

    public static void decode(byte[] byArray, OutputStream outputStream) {
        StableUtils.invokeMethod(coreLoader, CORE_CONTEXT, "decode", new Class[]{byte[].class, OutputStream.class}, new Object[]{byArray, outputStream});
    }

    public static String getFileTypeFromBytes(byte[] byArray) {
        String string = new String(byArray);
        if (string.startsWith("GIF")) {
            return ".gif";
        }
        if (string.startsWith("PNG", 1)) {
            return ".png";
        }
        if (string.indexOf("PDF") >= 0) {
            return ".pdf";
        }
        if (string.startsWith("Rar")) {
            return ".rar";
        }
        if (string.startsWith("PK")) {
            return ".zip";
        }
        if (string.indexOf("Exif") >= 0 || string.indexOf("JFIF") >= 0) {
            return ".jpg";
        }
        if (string.startsWith("BM")) {
            return ".bmp";
        }
        return ".txt";
    }

    public static String inputStream2String(InputStream inputStream, String string) throws IOException {
        String string2;
        if (inputStream == null) {
            return "";
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String getSoftLockContent() {
        return StableUtils.getSoftLockContent("");
    }

    public static String getLicContent() {
        byte[] byArray = StableUtils.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StableUtils.decode(byArray, byteArrayOutputStream);
        try {
            return CodeUtils.passwordEncode(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String getSoftLockContent(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(Consts.getEnvHome() + File.separator + "System");
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuffer.append(string2);
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!StringUtils.contains(stringBuffer.toString(), string)) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void dealFormulaValue(Object object, CalculatorProvider calculatorProvider) {
        Object object2 = null;
        if (object instanceof FormulaProvider) {
            FormulaProvider formulaProvider = (FormulaProvider)object;
            String string = formulaProvider.getContent();
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            if (StringUtils.isEmpty(string) || StringUtils.isBlank(string)) {
                return;
            }
            if (calculatorProvider == null) {
                calculatorProvider = CalculatorProviderContext.getCalculatorProvider();
            }
            try {
                object2 = calculatorProvider.evalValue(string);
            }
            catch (UtilEvalError utilEvalError) {
                String string2 = "Formula Error";
                object2 = string;
            }
            formulaProvider.setResult(object2);
        }
    }

    public static Object cloneObject(Object object) throws CloneNotSupportedException {
        if (object instanceof FCloneable) {
            return ((FCloneable)object).clone();
        }
        if (object instanceof Cloneable) {
            Method method = StableUtils.getDeclaredMethod(object.getClass(), "clone", new Class[0]);
            method.setAccessible(true);
            try {
                return method.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    public static HashSet<String> cloneHashSet(HashSet<String> hashSet) {
        if (hashSet == null) {
            return null;
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string : hashSet) {
            hashSet2.add(string);
        }
        return hashSet2;
    }

    public static HashMap<String, Object> cloneHashMap(HashMap<String, Object> hashMap) {
        if (hashMap == null) {
            return null;
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            hashMap2.put(entry.getKey(), entry.getValue());
        }
        return hashMap2;
    }

    public static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static boolean isNull(Object object) {
        return object == null || object == Primitive.NULL || object instanceof FormulaProvider && StableUtils.isNull(((FormulaProvider)object).getResult());
    }

    public static void setPrivateFieldValue(Object object, String string, Object object2) throws Exception {
        Class<?> clazz = object.getClass();
        while (!clazz.equals(Object.class)) {
            try {
                Field field = clazz.getDeclaredField(string);
                field.setAccessible(true);
                field.set(object, object2);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!(clazz = clazz.getSuperclass()).equals(Object.class)) continue;
                throw noSuchFieldException;
            }
        }
    }

    public static Object getPrivateFieldValue(Object object, String string) throws Exception {
        Class<?> clazz = object.getClass();
        Object object2 = null;
        while (!clazz.equals(Object.class)) {
            try {
                Field field = clazz.getDeclaredField(string);
                field.setAccessible(true);
                object2 = field.get(object);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!(clazz = clazz.getSuperclass()).equals(Object.class)) continue;
                throw noSuchFieldException;
            }
        }
        return object2;
    }

    public static boolean canBeFormula(Object object) {
        return object != null && object.toString().trim().startsWith("=");
    }

    public static Locale createLocale(String string) {
        Locale locale = null;
        if (StringUtils.isNotBlank(string)) {
            String[] stringArray = string.split("_");
            locale = stringArray.length > 1 ? new Locale(stringArray[0], stringArray[1]) : new Locale(stringArray[0], "");
        }
        return locale;
    }

    static {
        keyLength = 26;
        charPosition = new int[]{5, 15};
        URL uRL = StableUtils.class.getResource("StableUtils.class");
        coreLoader = uRL.toString().startsWith("jar:file") ? StableUtils.class.getClassLoader() : StableUtils.class.getClassLoader();
        digits = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        majorJavaVersion = Integer.parseInt(System.getProperty("java.version").split("\\.")[1]);
    }
}

