/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Ascii85OutputStream
extends FilterOutputStream {
    private int line_break = 72;
    private int count = 0;
    private byte[] indata = new byte[4];
    private byte[] outdata = new byte[5];
    private int maxline = 72;
    private boolean flushed = false;
    private char terminator = (char)126;

    public Ascii85OutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void setTerminator(char c2) {
        if (c2 < 'v' || c2 > '~' || c2 == 'z') {
            throw new IllegalArgumentException("Terminator must be 118-126 excluding z");
        }
        this.terminator = c2;
    }

    public char getTerminator() {
        return this.terminator;
    }

    public void setLineLength(int n2) {
        if (this.line_break > n2) {
            this.line_break = n2;
        }
        this.maxline = n2;
    }

    public int getLineLength() {
        return this.maxline;
    }

    private final void Ascii85Tuple() {
        long l2 = (long)((this.indata[0] << 8 | this.indata[1] & 0xFF) << 16 | (this.indata[2] & 0xFF) << 8 | this.indata[3] & 0xFF) & 0xFFFFFFFFL;
        if (l2 == 0L) {
            this.outdata[0] = 122;
            this.outdata[1] = 0;
            return;
        }
        long l3 = l2 / 52200625L;
        this.outdata[0] = (byte)(l3 + 33L);
        l2 -= l3 * 52200625L;
        l3 = l2 / 614125L;
        this.outdata[1] = (byte)(l3 + 33L);
        l2 -= l3 * 614125L;
        l3 = l2 / 7225L;
        this.outdata[2] = (byte)(l3 + 33L);
        l2 -= l3 * 7225L;
        l3 = l2 / 85L;
        this.outdata[3] = (byte)(l3 + 33L);
        this.outdata[4] = (byte)(l2 % 85L + 33L);
    }

    public final void write(int n2) throws IOException {
        this.flushed = false;
        this.indata[this.count++] = (byte)n2;
        if (this.count < 4) {
            return;
        }
        this.Ascii85Tuple();
        for (int i2 = 0; i2 < 5 && this.outdata[i2] != 0; ++i2) {
            this.out.write(this.outdata[i2]);
            if (--this.line_break != 0) continue;
            this.out.write(10);
            this.line_break = this.maxline;
        }
        this.count = 0;
    }

    public final void write(byte[] byArray, int n2, int n3) throws IOException {
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.count < 3) {
                this.indata[this.count++] = byArray[n2 + i2];
                continue;
            }
            this.write(byArray[n2 + i2]);
        }
    }

    public final void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        if (this.count > 0) {
            int n2;
            for (n2 = this.count; n2 < 4; ++n2) {
                this.indata[n2] = 0;
            }
            this.Ascii85Tuple();
            if (this.outdata[0] == 122) {
                for (n2 = 0; n2 < 5; ++n2) {
                    this.outdata[n2] = 33;
                }
            }
            for (n2 = 0; n2 < this.count + 1; ++n2) {
                this.out.write(this.outdata[n2]);
                if (--this.line_break != 0) continue;
                this.out.write(10);
                this.line_break = this.maxline;
            }
        }
        if (--this.line_break == 0) {
            this.out.write(10);
        }
        this.out.write(this.terminator);
        this.out.write(10);
        this.count = 0;
        this.line_break = this.maxline;
        this.flushed = true;
        super.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.outdata = null;
            this.indata = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.flush();
        }
        finally {
            super.finalize();
        }
    }
}

