/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.web;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.FRLogger;
import com.fr.general.VT4FR;
import com.fr.privilege.Authentication;
import com.fr.privilege.authentication.AuthenticationFactory;
import com.fr.schedule.tables.ScheduleTables;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.schedule.web.ScheduleAouSAPSynTaskAction;
import com.fr.schedule.web.ScheduleAouTaskAction;
import com.fr.schedule.web.ScheduleDelSAPSynTaskAction;
import com.fr.schedule.web.ScheduleDelTaskAction;
import com.fr.schedule.web.ScheduleExecuteClassAction;
import com.fr.schedule.web.ScheduleGetAllSAPTranTasksAction;
import com.fr.schedule.web.ScheduleGetAllTasksAction;
import com.fr.schedule.web.ScheduleGetAllTransfersAction;
import com.fr.schedule.web.ScheduleGetTaskAction;
import com.fr.schedule.web.ScheduleMonitorQueryAction;
import com.fr.schedule.web.ScheduleSAPSynStateAction;
import com.fr.schedule.web.ScheduleSetFileNameAction;
import com.fr.schedule.web.ScheduleShowPageAction;
import com.fr.schedule.web.ScheduleStateJobAction;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.impl.StdSchedulerFactory;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.core.WebActionsDispatcher;
import com.fr.web.core.db.PlatformDB;
import com.fr.web.core.reserve.NoSessionIDService;
import com.fr.web.platform.tables.QuartzTables;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ScheduleService
extends NoSessionIDService {
    private FRLogger log = FRLogger.getLogger();
    private ActionNoSessionCMD[] actions = new ActionNoSessionCMD[]{new ScheduleGetTaskAction(), new ScheduleGetAllTasksAction(), new ScheduleGetAllSAPTranTasksAction(), new ScheduleAouTaskAction(), new ScheduleAouSAPSynTaskAction(), new ScheduleDelTaskAction(), new ScheduleDelSAPSynTaskAction(), new ScheduleSetFileNameAction(), new ScheduleStateJobAction(), new ScheduleSAPSynStateAction(), new ScheduleShowPageAction(), new ScheduleMonitorQueryAction(), new ScheduleGetAllTransfersAction(), new ScheduleExecuteClassAction()};

    public ScheduleService() {
        this.initScheduleServer();
    }

    public String actionOP() {
        return "fr_schedule";
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        Authentication authentication = AuthenticationFactory.exAuth4CommonAccess(httpServletRequest);
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!(authentication != null && authentication.isRoot() || ModuleControl.getInstance().hasScheduleModulePrivilege(l2))) {
            throw new NoPrivilegeException();
        }
        WebActionsDispatcher.dealForActionNoSessionIDCMD(httpServletRequest, httpServletResponse, this.actions);
    }

    private void initScheduleServer() {
        if (!VT4FR.SCHEDULE.support()) {
            return;
        }
        if (ScheduleContext.getScheduler() != null) {
            return;
        }
        JDBCDatabaseConnection jDBCDatabaseConnection = PlatformDB.getDB();
        Connection connection = null;
        try {
            connection = jDBCDatabaseConnection.createConnection();
        }
        catch (Exception exception) {
            this.log.log(Level.WARNING, exception.getMessage(), exception);
        }
        Dialect dialect = DialectFactory.generateDialect(connection);
        ScheduleService.createScheduleTables(connection);
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            ScheduleLogUtils.error(sQLException);
        }
        try {
            StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory(this.initProperties(jDBCDatabaseConnection, dialect));
            ScheduleContext.setScheduler(stdSchedulerFactory.getScheduler());
            ScheduleContext.getScheduler().start();
            this.log.info("Scheduler has been started...");
        }
        catch (SchedulerException schedulerException) {
            ScheduleLogUtils.error(schedulerException);
        }
    }

    public static void createScheduleTables(Connection connection) {
        QuartzTables quartzTables = new QuartzTables();
        ScheduleTables scheduleTables = new ScheduleTables();
        quartzTables.generatorModuleTables(connection);
        scheduleTables.generatorModuleTables(connection);
    }

    private Properties initProperties(JDBCDatabaseConnection jDBCDatabaseConnection, Dialect dialect) {
        Properties properties = new Properties();
        properties.put("com.fr.third.org.quartz.jobStore.class", "com.fr.third.org.quartz.impl.jdbcjobstore.JobStoreTX");
        properties.put("com.fr.third.org.quartz.jobStore.dataSource", "myDS");
        properties.put("com.fr.third.org.quartz.dataSource.myDS.maxConnections", "5");
        properties.put("com.fr.third.org.quartz.jobStore.isClustered", new Boolean(false));
        properties.put("com.fr.third.org.quartz.jobStore.tablePrefix", "QRTZ_");
        properties.put("com.fr.third.org.quartz.jobStore.useProperties", new Boolean(false));
        properties.put("com.fr.third.org.quartz.threadPool.class", "com.fr.third.org.quartz.simpl.SimpleThreadPool");
        properties.put("com.fr.third.org.quartz.threadPool.threadCount", "10");
        properties.put("com.fr.third.org.quartz.dataSource.myDS.URL", jDBCDatabaseConnection.getURL());
        properties.put("com.fr.third.org.quartz.dataSource.myDS.driver", jDBCDatabaseConnection.getDriver());
        properties.put("com.fr.third.org.quartz.dataSource.myDS.user", jDBCDatabaseConnection.getUser());
        properties.put("com.fr.third.org.quartz.dataSource.myDS.password", jDBCDatabaseConnection.getPassword());
        properties.put("com.fr.third.org.quartz.jobStore.driverDelegateClass", dialect.quartzDelegateClass());
        return properties;
    }

    public static synchronized void releaseSchedule() throws Exception {
        if (ScheduleContext.getScheduler() != null) {
            ScheduleContext.getScheduler().shutdown();
            ScheduleContext.setScheduler(null);
            System.out.println("FineReport Scheduler has been shutdown successfully!");
        }
    }
}

