/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.base.ConfigManager;
import com.fr.base.EmailManager;
import com.fr.base.TemplateUtils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.report.cell.CellElementValueConverter;
import com.fr.report.core.SimpleColumnRowNameSpace;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.report.ResultReport;
import com.fr.schedule.output.AbstractOutputFileAction;
import com.fr.schedule.output.EmailException;
import com.fr.schedule.output.OutputFileAction;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.script.Calculator;
import com.fr.stable.CodeUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.StringUtils;
import com.fr.stable.script.ColumnRowRange;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import javax.mail.MessagingException;

public class EmailNotification
extends AbstractOutputFileAction {
    public static final String XML_TAG = "EmailNotification";
    public static final String TABLE_NAME = "fr_schedule_email";
    private Map parameterMap = null;
    private ResultWorkBook book;
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(EmailNotification.class, new Table("fr_schedule_email"), new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", 4, new ColumnSize(20), false, true), new CommonFieldColumnMapper("toAddress", 12, "toAddress", new ColumnSize(255), true), new CommonFieldColumnMapper("ccAddress", 12, "ccAddress", new ColumnSize(255), true), new CommonFieldColumnMapper("bccAddress", 12, "bccAddress", new ColumnSize(255), true), new CommonFieldColumnMapper("subject", 12, "subject", new ColumnSize(255), true), new CommonFieldColumnMapper("bodyContent", 12, "bodyContent", new ColumnSize(255), true), new CommonFieldColumnMapper("canPreviewAttach", 16, "canPreviewAttach", new ColumnSize(20), true)});
    private static final long serialVersionUID = 1L;
    private long id = -1L;
    private String toAddress = null;
    private String ccAddress = null;
    private String bccAddress = null;
    private String subject;
    private String bodyContent;
    private Boolean canPreviewAttach;
    private File previewFile = null;
    private static FRLogger log = FRLogger.getLogger();

    public EmailNotification() {
    }

    public EmailNotification(String string, String string2, String string3, String string4, String string5, Boolean bl) {
        this.toAddress = string;
        this.ccAddress = string2;
        this.bccAddress = string3;
        this.subject = string4;
        this.bodyContent = string5;
        this.canPreviewAttach = bl;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.getId());
        jSONObject.put("toAddress", this.getToAddress());
        jSONObject.put("ccAddress", this.getCcAddress());
        jSONObject.put("bccAddress", this.getBccAddress());
        jSONObject.put("subject", this.getSubject());
        jSONObject.put("bodyContent", this.getBodyContent());
        jSONObject.put("canPreviewAttach", this.getCanPreviewAttach());
        return jSONObject;
    }

    public OutputFileAction analyzeJSON(JSONObject jSONObject) {
        try {
            EmailNotification emailNotification = null;
            emailNotification = jSONObject.has("id") ? (EmailNotification)ScheduleContext.createDAOSession().load(EmailNotification.class, jSONObject.getLong("id")) : new EmailNotification();
            String string = jSONObject.getString("toAddress");
            String string2 = jSONObject.getString("ccAddress");
            String string3 = jSONObject.getString("bccAddress");
            String string4 = jSONObject.getString("subject");
            String string5 = jSONObject.getString("bodyContent");
            Boolean bl = jSONObject.getBoolean("canPreviewAttach");
            try {
                string4 = CodeUtils.cjkDecode(string4);
                string5 = CodeUtils.cjkDecode(string5);
            }
            catch (Exception exception) {
                string4 = jSONObject.getString("subject");
                string5 = jSONObject.getString("bodyContent");
            }
            emailNotification.setToAddress(string);
            emailNotification.setCcAddress(string2);
            emailNotification.setBccAddress(string3);
            emailNotification.setSubject(string4);
            emailNotification.setBodyContent(string5);
            emailNotification.setCanPreviewAttach(bl);
            return emailNotification;
        }
        catch (JSONException jSONException) {
            ScheduleLogUtils.error(jSONException);
            return null;
        }
    }

    public File[] getFilesToDealWith(File[] fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.getPdfFromOutputFile(fileArray) != null) {
            arrayList.add(this.getPdfFromOutputFile(fileArray));
        }
        if (this.getWordFromOutputFile(fileArray) != null) {
            arrayList.add(this.getWordFromOutputFile(fileArray));
        }
        if (this.getExcelFromOutputFile(fileArray) != null) {
            arrayList.add(this.getExcelFromOutputFile(fileArray));
        }
        if (this.getCanPreviewAttach().booleanValue()) {
            ArrayList<File> arrayList2 = new ArrayList<File>();
            if (this.getPngFromOutputFile(fileArray) != null) {
                arrayList2.add(this.getPngFromOutputFile(fileArray));
            }
            if (!arrayList2.isEmpty()) {
                this.setPreviewFile(arrayList2.toArray(new File[arrayList2.size()])[0]);
            }
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public void doFileAction(File[] fileArray) throws Exception {
        try {
            this.doFileAction(fileArray, this.getToAddress());
        }
        catch (EmailException emailException) {
            ScheduleLogUtils.error(emailException);
            throw emailException;
        }
    }

    public void doFileAction(File[] fileArray, String string) throws Exception {
        if (StringUtils.isNotBlank(string)) {
            try {
                EmailManager emailManager = EmailNotification.getEmailManager();
                if (emailManager == null) {
                    throw new EmailException("Email Manager is not Configed!");
                }
                emailManager.send(string, this.getCcAddress(), this.getBccAddress(), null, this.dealWithMailParameter(this.getSubject()), this.dealWithMailParameter(this.getBodyContent()), fileArray, this.getPreviewFile());
            }
            catch (MessagingException messagingException) {
                throw new EmailException(messagingException);
            }
        }
    }

    private String dealWithMailParameter(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = TemplateUtils.ParameterPattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            matcher.appendReplacement(stringBuffer, this.analysisSingleParameter(string2));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String analysisSingleParameter(String string) throws Exception {
        ResultReport resultReport;
        Iterator iterator;
        String string2 = TemplateUtils.render(string, this.parameterMap, Calculator.createCalculator());
        if (StringUtils.isNotEmpty(string2)) {
            return string2;
        }
        ColumnRow columnRow = ColumnRow.valueOf(string.substring(2, string.length() - 1));
        if (columnRow.getColumn() >= 0 && columnRow.getRow() >= 0 && this.book != null && (iterator = (resultReport = this.book.getResultReport(0)).iteratorOfElementCase()).hasNext()) {
            ElementCase elementCase = (ElementCase)iterator.next();
            try {
                Object object = SimpleColumnRowNameSpace.resolveColumnRowRange(ColumnRowRange.columnRow2Range(columnRow), elementCase);
                return String.valueOf(CellElementValueConverter.cellElement2CellValue(object));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return "";
            }
        }
        return string;
    }

    public static EmailManager getEmailManager() {
        EmailManager emailManager = ConfigManager.getInstance().getEmailManager();
        if (emailManager == null) {
            emailManager = new EmailManager();
            ConfigManager.getInstance().setEmailManager(emailManager);
        }
        return emailManager;
    }

    public void setId(long l2) {
        this.id = l2;
    }

    public long getId() {
        return this.id;
    }

    public void setToAddress(String string) {
        this.toAddress = string;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public void setCcAddress(String string) {
        this.ccAddress = string;
    }

    public String getCcAddress() {
        return this.ccAddress;
    }

    public void setBccAddress(String string) {
        this.bccAddress = string;
    }

    public String getBccAddress() {
        return this.bccAddress;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setBodyContent(String string) {
        this.bodyContent = string;
    }

    public String getBodyContent() {
        if (this.bodyContent == null) {
            return "";
        }
        return this.bodyContent;
    }

    public void setCanPreviewAttach(Boolean bl) {
        this.canPreviewAttach = bl;
    }

    public Boolean getCanPreviewAttach() {
        return this.canPreviewAttach;
    }

    public void setPreviewFile(File file) {
        this.previewFile = file;
    }

    public File getPreviewFile() {
        return this.previewFile;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttrAsString("toAddress", null);
            if (string != null) {
                this.setToAddress(string);
            }
            if ((string = xMLableReader.getAttrAsString("ccAddress", null)) != null) {
                this.setCcAddress(string);
            }
            if ((string = xMLableReader.getAttrAsString("bccAddress", null)) != null) {
                this.setBccAddress(string);
            }
            if ((string = xMLableReader.getAttrAsString("subject", null)) != null) {
                this.setSubject(string);
            }
            if ((string = xMLableReader.getAttrAsString("bodyContent", null)) != null) {
                this.setBodyContent(string);
            }
            if ((string = xMLableReader.getAttrAsString("canPreviewAttach", null)) != null) {
                this.setCanPreviewAttach(Boolean.valueOf(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("toAddress", this.toAddress).attr("ccAddress", this.ccAddress).attr("bccAddress", this.bccAddress).attr("subject", this.subject).attr("bodyContent", this.bodyContent).attr("canPreviewAttach", this.canPreviewAttach).end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof EmailNotification)) {
            return false;
        }
        EmailNotification emailNotification = (EmailNotification)object;
        return ComparatorUtils.equals(emailNotification.getBccAddress(), this.getBccAddress()) && ComparatorUtils.equals(emailNotification.getCcAddress(), this.getCcAddress()) && ComparatorUtils.equals(emailNotification.getToAddress(), this.getToAddress());
    }

    public Object clone() throws CloneNotSupportedException {
        EmailNotification emailNotification = (EmailNotification)super.clone();
        return emailNotification;
    }

    public String getJsonTag() {
        return "emailNotification";
    }

    public void setParameters(Map map) {
        this.parameterMap = map;
    }

    public boolean isEmailNotification() {
        return true;
    }

    public ResultWorkBook getBook() {
        return this.book;
    }

    public void setBook(ResultWorkBook resultWorkBook) {
        this.book = resultWorkBook;
    }
}

