/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.write;

import com.fr.base.FRContext;
import com.fr.data.TableDataSource;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.report.core.namespace.SimpleCellValueNameSpace;
import com.fr.report.report.Report;
import com.fr.report.write.MismatchException;
import com.fr.report.write.Submiter;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.Map;

public abstract class AbstractSubmiter
implements Submiter {
    private String condition;

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        this.condition = string;
    }

    public void execute(Report report, TableDataSource tableDataSource, Map map) throws Exception {
        if (!StringUtils.isBlank(this.condition)) {
            Calculator calculator = Calculator.createCalculator();
            calculator.pushNameSpace(SimpleCellValueNameSpace.getInstance());
            calculator.setAttribute(Report.class, report);
            calculator.setAttribute(TableDataSource.class, tableDataSource);
            Object object = calculator.evalValue(this.condition);
            if (!ComparatorUtils.equals(Boolean.TRUE, object)) {
                FRContext.getLogger().info("The condition " + this.condition + " is non-compliance");
                throw new MismatchException();
            }
        }
    }

    public Object __mod_column_row(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        return mOD_COLUMN_ROW;
    }

    public boolean isBuiltin() {
        return false;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "Condition".equals(xMLableReader.getTagName())) {
            this.setCondition(xMLableReader.getElementValue());
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.condition)) {
            xMLPrintWriter.startTAG("Condition").textNode(this.condition).end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

