/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.button;

import com.fr.base.DynamicNumberList;
import com.fr.form.ui.PaddingMargin;
import com.fr.form.ui.Widget;
import com.fr.general.Background;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.web.Repository;
import com.fr.web.BaseHTMLWriterUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class Composite
extends Widget {
    public static final String EVENT_AFTERINIT = "afterinit";
    public static final String EVENT_AFTERLOAD = "afterload";

    public abstract CompositeLayout getCompositeWidget(Repository var1);

    public String[] supportedEvents() {
        return new String[]{EVENT_AFTERINIT, EVENT_AFTERLOAD};
    }

    public String getXType() {
        return "composite";
    }

    public boolean isEditor() {
        return false;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator);
        CompositeLayout compositeLayout = this.getCompositeWidget(repository);
        jSONObject.put("innerWidget", compositeLayout.createJSONConfig(repository, calculator));
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Composite)) {
            return false;
        }
        return super.equals(object);
    }

    protected class CompositeLayout
    extends Widget {
        protected List widgetList = new ArrayList();
        protected PaddingMargin margin;
        protected Background background;
        protected int vgap;
        protected int hgap;
        private int DEFAULT_WIDTH = 80;
        private DynamicNumberList widgetsWidthList_DEC;

        public CompositeLayout(int n2, int n3) {
            this.hgap = n2;
            this.vgap = n3;
            this.widgetsWidthList_DEC = new DynamicNumberList(this.DEFAULT_WIDTH);
        }

        public void addWidthWidget(Widget widget, int n2) {
            this.widgetList.add(widget);
            this.widgetsWidthList_DEC.set(this.widgetList.size() - 1, n2);
        }

        public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
            JSONObject jSONObject = super.createJSONConfig(repository, calculator);
            if (PaddingMargin.need(this.margin)) {
                this.margin.createJSONConfig(jSONObject);
            }
            if (this.background != null) {
                jSONObject.put("widgetBackground", BaseHTMLWriterUtils.jsonBackground(this.background, repository));
            }
            jSONObject.put("vgap", this.vgap);
            jSONObject.put("hgap", this.hgap);
            jSONObject.put("items", this.createJSONItems(repository, calculator));
            jSONObject.put("alignment", "left");
            return jSONObject;
        }

        protected JSONArray createJSONItems(Repository repository, Calculator calculator) throws JSONException {
            JSONArray jSONArray = new JSONArray();
            int n2 = this.widgetList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Widget widget = (Widget)this.widgetList.get(i2);
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("width", this.widgetsWidthList_DEC.get(i2));
                jSONObject.put("el", widget.createJSONConfig(repository, calculator));
                jSONArray.put(jSONObject);
            }
            return jSONArray;
        }

        public String getXType() {
            return "horizontal";
        }

        public boolean isEditor() {
            return false;
        }

        public String[] supportedEvents() {
            return new String[0];
        }
    }
}

