/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.poly;

import com.fr.data.TableDataSource;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.main.FineBook;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.privilege.finegrain.WorkSheetPrivilegeControl;
import com.fr.report.block.Block;
import com.fr.report.core.ReportHF;
import com.fr.report.report.Report;
import com.fr.report.stable.ReportAttrSet;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.SynchronizedStyleList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractPolyReport
implements Report {
    private ReportAttrSet reportAttrSet = new ReportAttrSet();
    private FineBook book;
    private List blockList = new ArrayList(1);
    private WorkSheetPrivilegeControl workSheetPrivilegeControl;

    public boolean isElementCaseReport() {
        return false;
    }

    public TableDataSource getTableDataSource() {
        return this.book;
    }

    public void addBlock(Block block) {
        this.blockList.add(block);
    }

    public int getBlockCount() {
        return this.blockList.size();
    }

    public Block getBlock(int n2) {
        if (n2 < 0 || n2 > this.blockList.size() - 1) {
            return null;
        }
        return (Block)this.blockList.get(n2);
    }

    public Block getBlockByName(String string) {
        int n2 = this.getBlockCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Block block = this.getBlock(i2);
            if (!ComparatorUtils.equals(block.getBlockName(), string)) continue;
            return block;
        }
        return null;
    }

    public void removeBlock(Block block) {
        this.blockList.remove(block);
    }

    public Iterator iteratorOfElementCase() {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        int n2 = this.getBlockCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Block block = this.getBlock(i2);
            if (!block.isCells()) continue;
            arrayList.add(block);
        }
        return arrayList.iterator();
    }

    public FineBook getBook() {
        return this.book;
    }

    protected void setBook(FineBook fineBook) {
        this.book = fineBook;
    }

    public ReportSettingsProvider getReportSettings() {
        return this.reportAttrSet.getReportSettings();
    }

    public void setReportSettings(ReportSettingsProvider reportSettingsProvider) {
        this.reportAttrSet.setReportSettings(reportSettingsProvider);
    }

    public ReportHFProvider getHeader(int n2) {
        return this.reportAttrSet.getHeader(n2);
    }

    public void setHeader(int n2, ReportHF reportHF) {
        this.reportAttrSet.setHeader(n2, reportHF);
    }

    public ReportHFProvider getFooter(int n2) {
        return this.reportAttrSet.getFooter(n2);
    }

    public void setFooter(int n2, ReportHF reportHF) {
        this.reportAttrSet.setFooter(n2, reportHF);
    }

    public WorkSheetPrivilegeControl getWorkSheetPrivilegeControl() {
        if (this.workSheetPrivilegeControl == null) {
            this.workSheetPrivilegeControl = new WorkSheetPrivilegeControl();
        }
        return this.workSheetPrivilegeControl;
    }

    public void setWorkSheetPrivilegeControl(WorkSheetPrivilegeControl workSheetPrivilegeControl) {
        this.workSheetPrivilegeControl = workSheetPrivilegeControl;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.blockList.clear();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Version")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    xMLableReader.getXMLVersion().setVersion(Double.parseDouble(string2));
                }
            } else if ("StyleList".equals(string)) {
                SynchronizedStyleList.getSynchronizedStyleList().deXmlizeStyleList(xMLableReader);
            } else if ("Block".equals(string)) {
                Block block = (Block)GeneralXMLTools.readXMLable(xMLableReader);
                this.addBlock(block);
            } else if ("ReportAttrSet".equals(string)) {
                if (this.reportAttrSet == null) {
                    this.reportAttrSet = new ReportAttrSet();
                }
                xMLableReader.readXMLObject(this.reportAttrSet);
            } else if ("PrivilegeControl".equals(string)) {
                WorkSheetPrivilegeControl workSheetPrivilegeControl = new WorkSheetPrivilegeControl();
                xMLableReader.readXMLObject(workSheetPrivilegeControl);
                this.setWorkSheetPrivilegeControl(workSheetPrivilegeControl);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        this.writeXML(xMLPrintWriter, OBlockWriter.SC);
    }

    protected void writeXML(XMLPrintWriter xMLPrintWriter, BlockWriter blockWriter) {
        if (this.reportAttrSet != null) {
            this.reportAttrSet.writeXML(xMLPrintWriter);
        }
        int n2 = this.getBlockCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Block block = this.getBlock(i2);
            blockWriter.writerBlock(xMLPrintWriter, block);
        }
        WorkSheetPrivilegeControl workSheetPrivilegeControl = this.getWorkSheetPrivilegeControl();
        if (workSheetPrivilegeControl != null) {
            workSheetPrivilegeControl.writeXML(xMLPrintWriter);
        }
    }

    public void copyReportAttr(AbstractPolyReport abstractPolyReport) {
        if (abstractPolyReport == null) {
            return;
        }
        abstractPolyReport.reportAttrSet = this.reportAttrSet;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractPolyReport abstractPolyReport = (AbstractPolyReport)super.clone();
        abstractPolyReport.blockList = new ArrayList();
        int n2 = this.getBlockCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Block block = this.getBlock(i2);
            abstractPolyReport.addBlock((Block)block.clone());
        }
        if (this.reportAttrSet != null) {
            abstractPolyReport.reportAttrSet = (ReportAttrSet)this.reportAttrSet.clone();
        }
        abstractPolyReport.setWorkSheetPrivilegeControl((WorkSheetPrivilegeControl)this.getWorkSheetPrivilegeControl().clone());
        return abstractPolyReport;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractPolyReport && ComparatorUtils.equals(this.reportAttrSet, ((AbstractPolyReport)object).reportAttrSet) && ComparatorUtils.equals(this.blockList, ((AbstractPolyReport)object).blockList);
    }

    private static class OBlockWriter
    implements BlockWriter {
        private static OBlockWriter SC = new OBlockWriter();

        private OBlockWriter() {
        }

        public void writerBlock(XMLPrintWriter xMLPrintWriter, Block block) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, block, "Block");
        }
    }

    protected static interface BlockWriter {
        public void writerBlock(XMLPrintWriter var1, Block var2);
    }
}

