/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.module;

import com.fr.base.FRContext;
import com.fr.file.ClusterConfigManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.VT4FR;
import com.fr.stable.StableUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class CheckMultiLicThread
extends Thread {
    public static final int LIC_CHECK_PORT = 51377;
    private static ServerSocket server;

    public void run() {
        this.checkMultiLic();
    }

    private void checkMultiLic() {
        if (ClusterConfigManager.getInstance().isUseCluster() || server != null) {
            return;
        }
        try {
            this.multiLicAsServer();
        }
        catch (Exception exception) {
            try {
                this.multiLicAsClient();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private void multiLicAsServer() throws Exception {
        server = new ServerSocket(51377);
        Socket socket = server.accept();
        InputStream inputStream = socket.getInputStream();
        byte[] byArray = new byte[32768];
        inputStream.read(byArray);
        String string = new String(byArray, "UTF-8").trim();
        if (ComparatorUtils.equals(string, StableUtils.getLicContent())) {
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write("failure".getBytes());
            outputStream.close();
        }
        inputStream.close();
    }

    private void multiLicAsClient() throws Exception {
        try {
            Socket socket = new Socket("127.0.0.1", 51377);
            server = new ServerSocket();
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(StableUtils.getLicContent().getBytes("UTF-8"));
            InputStream inputStream = socket.getInputStream();
            byte[] byArray = new byte[10];
            inputStream.read(byArray);
            String string = new String(byArray, "UTF-8").trim();
            if (ComparatorUtils.equals(string, "failure")) {
                VT4FR.resetFunctions();
                FRContext.getLogger().error("lic-same-content");
            }
            inputStream.close();
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

