/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter.barcode.pdf417;

import com.fr.report.cell.painter.barcode.Module;
import com.fr.report.cell.painter.barcode.output.AbstractOutput;
import com.fr.report.cell.painter.barcode.pdf417.PDF417Data;

public class PDF417Module
extends Module {
    private static final int DATACOLS = 12;
    private final String data;
    private int[] out;
    private int outlen;
    private int outrows;
    private int col = 0;
    private int xp;
    private int yp;
    private int startX;
    private int wsize = 0;
    private int barWidth;

    public PDF417Module(String string) {
        super(new int[0]);
        this.data = string;
    }

    int getBarcodeWidth() {
        return this.wsize - this.startX;
    }

    int getBarcodeHeight() {
        return this.yp;
    }

    protected double draw(AbstractOutput abstractOutput, double d2, double d3) {
        this.xp = (int)d2;
        this.startX = (int)d2;
        this.yp = (int)d3;
        this.barWidth = (int)abstractOutput.getBarWidth();
        this.createCodewords(this.data.toCharArray(), this.data.length());
        this.createBits(this.out, this.outlen, this.outrows);
        this.encode(this.out, this.outrows, abstractOutput);
        return this.getBarcodeWidth();
    }

    private void generateEC(int[] nArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 27;
        int n7 = 917;
        nArray[n2] = 0;
        nArray[n2 + 1] = 0;
        if (n3 != 2) {
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n8 = (n5 + nArray[i2]) % 929;
            if (n8 != 0) {
                n8 = 929 - n8;
            }
            n5 = (n4 + n7 * n8) % 929;
            n4 = (0 + n6 * n8) % 929;
        }
        if (n4 != 0) {
            n4 = 929 - n4;
        }
        if (n5 != 0) {
            n5 = 929 - n5;
        }
        nArray[n2] = n5;
        nArray[n2 + 1] = n4;
    }

    private void outbit(int n2, AbstractOutput abstractOutput) {
        abstractOutput.drawBar(this.xp, this.yp, 1, 1, n2 == 1);
        this.xp += this.barWidth;
        if (this.col++ == this.wsize - 1) {
            this.col = 0;
            ++this.yp;
            this.xp = this.startX;
        }
    }

    private void createCodewords(char[] cArray, int n2) {
        int n3 = 2;
        this.outlen = 2 + n2 / 6 * 5 + n2 % 6 + n3;
        this.outrows = this.outlen / 12;
        if (this.outlen % 12 != 0) {
            ++this.outrows;
        }
        if (this.outrows < 3) {
            this.outrows = 3;
        }
        if (this.outrows > 90) {
            return;
        }
        this.outlen = this.outrows * 12;
        if (this.outlen > 928) {
            return;
        }
        this.out = new int[this.outlen];
        this.out[0] = 2 + n2 / 6 * 5 + n2 % 6;
        this.out[1] = n2 % 6 != 0 ? 901 : 924;
        int n4 = 0;
        int n5 = 2;
        while (n4 + 5 < n2) {
            int n6;
            long l2 = 0L;
            for (n6 = 0; n6 < 6; ++n6) {
                l2 <<= 8;
                l2 += (long)cArray[n4++];
            }
            for (n6 = 0; n6 < 5; ++n6) {
                this.out[n5 + 4 - n6] = new Long(l2 % 900L).intValue();
                l2 /= 900L;
            }
            n5 += 5;
        }
        while (n4 < n2) {
            this.out[n5++] = cArray[n4++];
        }
        while (n5 < this.outlen - n3) {
            this.out[n5++] = 900;
        }
        this.generateEC(this.out, n5, n3);
    }

    private void createBits(int[] nArray, int n2, int n3) {
        if (n3 < 3 || n3 > 90 || n2 != 12 * n3) {
            return;
        }
        int n4 = n3 * 16;
        int[] nArray2 = new int[n4];
        int n5 = 0;
        int n6 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n7 = 11;
            int n8 = i2 % 3;
            int n9 = i2 / 3;
            int n10 = n3 / 3;
            int n11 = 0 + n3 % 3;
            nArray2[n5++] = 130472;
            switch (n8) {
                case 0: {
                    nArray2[n5++] = PDF417Data.PDF417_BITS[n8][30 * n9 + n10];
                    break;
                }
                case 1: {
                    nArray2[n5++] = PDF417Data.PDF417_BITS[n8][30 * n9 + n11];
                    break;
                }
                case 2: {
                    nArray2[n5++] = PDF417Data.PDF417_BITS[n8][30 * n9 + n7];
                }
            }
            for (int i3 = 0; i3 < 12; ++i3) {
                nArray2[n5++] = PDF417Data.PDF417_BITS[n8][nArray[n6++]];
            }
            switch (n8) {
                case 0: {
                    nArray2[n5++] = PDF417Data.PDF417_BITS[n8][30 * n9 + n7];
                    break;
                }
                case 1: {
                    nArray2[n5++] = PDF417Data.PDF417_BITS[n8][30 * n9 + n10];
                    break;
                }
                case 2: {
                    nArray2[n5++] = PDF417Data.PDF417_BITS[n8][30 * n9 + n11];
                }
            }
            nArray2[n5++] = 130324;
        }
        this.out = nArray2;
        this.outlen = n4;
    }

    private void encode(int[] nArray, int n2, AbstractOutput abstractOutput) {
        int n3;
        int n4;
        int n5 = 7;
        int n6 = 2;
        this.wsize = (272 + this.barWidth + 4) * n6;
        for (n4 = 0; n4 < 2 * n6; ++n4) {
            for (n3 = 0; n3 < 277 * n6; ++n3) {
                this.outbit(0, abstractOutput);
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                int n7;
                for (n7 = 0; n7 < 2 * n6; ++n7) {
                    this.outbit(0, abstractOutput);
                }
                for (n7 = 0; n7 < 16; ++n7) {
                    int n8 = nArray[16 * n4 + n7];
                    for (int i2 = 16; i2 >= 0; --i2) {
                        for (int i3 = 0; i3 < n6; ++i3) {
                            if ((n8 & 1 << i2) != 0) {
                                this.outbit(1, abstractOutput);
                                continue;
                            }
                            this.outbit(0, abstractOutput);
                        }
                    }
                }
                for (n7 = 0; n7 < n6; ++n7) {
                    this.outbit(1, abstractOutput);
                }
                for (n7 = 0; n7 < 2 * n6; ++n7) {
                    this.outbit(0, abstractOutput);
                }
            }
        }
        for (n4 = 0; n4 < 2 * n6; ++n4) {
            for (n3 = 0; n3 < 277 * n6; ++n3) {
                this.outbit(0, abstractOutput);
            }
        }
    }
}

