/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.core.group;

import com.fr.base.FRContext;
import com.fr.cache.list.IntList;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.report.cell.cellattr.core.group.Group;
import com.fr.report.cell.cellattr.core.group.RecordGrouper;
import com.fr.script.Calculator;
import java.util.Iterator;

public class MonoGrouper
extends RecordGrouper {
    public Group[] group(DataModel dataModel, int n2, int[] nArray, Calculator calculator) {
        if (n2 == -1) {
            return super.group(dataModel, n2, nArray, calculator);
        }
        if (nArray == null) {
            try {
                nArray = IntList.range(dataModel.getRowCount());
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
        }
        Group[] groupArray = new Group[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            try {
                groupArray[i2] = new Group(dataModel.getValueAt(n3, n2), new int[]{n3});
                continue;
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
        }
        return groupArray;
    }

    public Iterator groupIterator(DataModel dataModel, int n2, int[] nArray, Calculator calculator) {
        return new MonoIterator(dataModel, n2, nArray);
    }

    private static class MonoIterator
    implements Iterator {
        private DataModel rs;
        private int columnIndex;
        private int[] rows;
        private int nextArrayIndex = -1;
        private int nextTableDataIndex = -1;
        private Group nextGroup;

        MonoIterator(DataModel dataModel, int n2, int[] nArray) {
            this.rs = dataModel;
            this.columnIndex = n2;
            this.rows = nArray;
            this.findNext();
        }

        private void findNext() {
            if (this.rows == null) {
                ++this.nextTableDataIndex;
            } else {
                ++this.nextArrayIndex;
                this.nextTableDataIndex = this.nextArrayIndex >= this.rows.length ? -1 : this.rows[this.nextArrayIndex];
            }
            try {
                this.nextGroup = this.nextTableDataIndex < 0 || !this.rs.hasRow(this.nextTableDataIndex) ? null : (this.columnIndex == -1 ? new Group(new Integer(this.nextTableDataIndex + 1), new int[]{this.nextTableDataIndex}) : new Group(this.rs.getValueAt(this.nextTableDataIndex, this.columnIndex), new int[]{this.nextTableDataIndex}));
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().error(tableDataException.getMessage(), tableDataException);
                this.nextGroup = null;
            }
        }

        public boolean hasNext() {
            return this.nextGroup != null;
        }

        public Object next() {
            Group group = this.nextGroup;
            this.findNext();
            return group;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

