/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.core;

import com.fr.base.AbstractPainter;
import com.fr.base.DynamicNumberList;
import com.fr.base.DynamicPixList;
import com.fr.base.DynamicUnitList;
import com.fr.base.FRContext;
import com.fr.base.GraphHelper;
import com.fr.base.Style;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.general.Background;
import com.fr.main.workbook.PageRWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.core.PaintUtils;
import com.fr.report.report.ECReport;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class ResultSubReport
extends AbstractPainter {
    public static final String XML_TAG = "ResultSubReport";
    private ResultWorkBook packee;

    public ResultSubReport() {
        this(new PageRWorkBook());
    }

    public ResultSubReport(ResultWorkBook resultWorkBook) {
        this.packee = resultWorkBook;
    }

    public void paint(Graphics graphics, int n2, int n3, int n4, Style style) {
        Rectangle rectangle;
        Cloneable cloneable;
        CellElement cellElement;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ECReport eCReport = null;
        if (this.packee.getReportCount() > 0) {
            eCReport = (ECReport)this.packee.getReport(0);
        }
        if (eCReport == null) {
            return;
        }
        DynamicUnitList dynamicUnitList = ReportHelper.getColumnWidthList(eCReport);
        DynamicUnitList dynamicUnitList2 = ReportHelper.getRowHeightList(eCReport);
        ArrayList<CellElement> arrayList = new ArrayList<CellElement>();
        ArrayList<Rectangle> arrayList2 = new ArrayList<Rectangle>();
        Iterator iterator = eCReport.cellIterator();
        while (iterator.hasNext()) {
            cellElement = (CellElement)iterator.next();
            cloneable = new Rectangle(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
            rectangle = new Rectangle(dynamicUnitList.getRangeValue(0, ((Rectangle)cloneable).x).toPixI(n4), dynamicUnitList2.getRangeValue(0, ((Rectangle)cloneable).y).toPixI(n4), dynamicUnitList.getRangeValue(((Rectangle)cloneable).x, ((Rectangle)cloneable).x + ((Rectangle)cloneable).width).toPixI(n4), dynamicUnitList2.getRangeValue(((Rectangle)cloneable).y, ((Rectangle)cloneable).y + ((Rectangle)cloneable).height).toPixI(n4));
            arrayList.add(cellElement);
            arrayList2.add(rectangle);
            graphics2D.translate(rectangle.x, rectangle.y);
            Object object = cellElement.getValue();
            CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
            if (object instanceof String && cellGUIAttr != null && cellGUIAttr.isShowAsHTML()) {
                object = PaintUtils.createHTMLContentBufferedImage((String)object, rectangle, 0, 0);
            }
            if (!(object instanceof String) && !(object instanceof Integer)) {
                object = Utils.resolveOtherValue(object, cellElement.getCellGUIAttr() != null ? cellElement.getCellGUIAttr().isShowAsImage() : false);
            }
            this.paintBackground(graphics2D, cellElement.getStyle(), rectangle.width, rectangle.height);
            Style.paintContent(graphics2D, object, cellElement.getStyle(), rectangle.width, rectangle.height, n4);
            graphics2D.translate(-rectangle.x, -rectangle.y);
        }
        if (arrayList.size() > 0) {
            cloneable = (CellElement)arrayList.get(0);
            int n5 = GraphHelper.getLineStyleSize(cloneable.getStyle().getBorderLeft());
            graphics2D.translate(n5 / 2, 0);
        }
        int n6 = arrayList.size();
        for (int i2 = 0; i2 < n6; ++i2) {
            cellElement = (CellElement)arrayList.get(i2);
            rectangle = (Rectangle)arrayList2.get(i2);
            graphics2D.translate(rectangle.x, rectangle.y);
            Style.paintBorder(graphics2D, cellElement.getStyle(), rectangle.width, rectangle.height);
            graphics2D.translate(-rectangle.x, -rectangle.y);
        }
    }

    private DynamicNumberList getColumnWidthDynamicNumberList(ECReport eCReport, int n2) {
        DynamicPixList dynamicPixList = ReportHelper.getColumnWidthList(eCReport).toDynamicPixList();
        int n3 = dynamicPixList.getElementSize();
        DynamicNumberList dynamicNumberList = new DynamicNumberList(0, n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            dynamicNumberList.set(i2, dynamicPixList.get(i2, n2));
        }
        return dynamicNumberList;
    }

    public DynamicNumberList getRowHeightDynamicPixList(ECReport eCReport, int n2) {
        DynamicPixList dynamicPixList = ReportHelper.getRowHeightList(eCReport).toDynamicPixList();
        int n3 = dynamicPixList.getElementSize();
        DynamicNumberList dynamicNumberList = new DynamicNumberList(0, n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            dynamicNumberList.set(i2, dynamicPixList.get(i2, n2));
        }
        return dynamicNumberList;
    }

    private void paintBackground(Graphics2D graphics2D, Style style, double d2, double d3) {
        if (style == null) {
            return;
        }
        Background background = style.getBackground();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        if (background != null) {
            ((Rectangle2D)double_).setRect(0.0, 0.0, d2, d3);
            background.paint(graphics2D, double_);
        } else {
            background = ColorBackground.getInstance(Color.white);
            ((Rectangle2D)double_).setRect(0.0, 0.0, d2, d3);
            background.paint(graphics2D, double_);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        String string2;
        if (xMLableReader.isChildNode() && (string2 = xMLableReader.getTagName()).equals("packee") && (string = xMLableReader.getAttrAsString("class", null)) != null) {
            try {
                ResultWorkBook resultWorkBook = null;
                Object obj = Class.forName(string).newInstance();
                if (obj instanceof ResultWorkBook) {
                    this.packee = resultWorkBook = (ResultWorkBook)obj;
                    xMLableReader.readXMLObject(resultWorkBook);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().error("Failed to read resultSubReport" + exception.getMessage());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("packee").attr("class", this.packee.getClass().getName());
        this.packee.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        ResultSubReport resultSubReport = (ResultSubReport)super.clone();
        resultSubReport.packee = (ResultWorkBook)this.packee.clone();
        return resultSubReport;
    }
}

