/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.file.XMLFileManager;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.report.fun.ActorProvider;
import com.fr.stable.Actor;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.List;

public class ExtraReportClassManager
extends XMLFileManager {
    private static final String XML_TAG = "ExtraReportClassManager";
    private static ExtraReportClassManager reportClassManager;
    private List<Actor> actors = new ArrayList<Actor>();

    public static synchronized ExtraReportClassManager getInstance() {
        if (reportClassManager == null) {
            reportClassManager = new ExtraReportClassManager();
            reportClassManager.readXMLFile();
        }
        return reportClassManager;
    }

    private static synchronized void envChanged() {
        reportClassManager = null;
    }

    public String fileName() {
        return "report.xml";
    }

    public void setActorProvider(String string) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = Class.forName(string);
                ActorProvider actorProvider = (ActorProvider)clazz.newInstance();
                for (Actor actor : actorProvider.createActor()) {
                    this.actors.add(actor);
                }
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
            }
        }
    }

    public Actor[] getActors() {
        return this.actors.toArray(new Actor[this.actors.size()]);
    }

    private void addActor(String string) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = Class.forName(string);
                this.actors.add((Actor)clazz.newInstance());
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
            }
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            if (xMLableReader.getTagName().equals("ActorProvider")) {
                this.setActorProvider(xMLableReader.getAttrAsString("class", ""));
            } else if (xMLableReader.getTagName().equals("WebActor")) {
                this.addActor(xMLableReader.getAttrAsString("class", ""));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                ExtraReportClassManager.envChanged();
            }
        });
    }
}

