/*
 * Decompiled with CFR 0.152.
 */
package com.fr.record;

import com.fr.base.FRContext;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.AddColumn;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.AbstractModuleTables;
import com.fr.data.core.db.tableObject.AbstractTableObject;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.core.db.tableObject.TableObject;
import com.fr.general.FRLogger;
import com.fr.record.DBRecordManager;
import com.fr.stable.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class RecordTables
extends AbstractModuleTables {
    private List indexList = new ArrayList();

    protected void initTableObjectList() {
        this.tableObjectList.add(new FR_EXECUTERECORD());
        this.tableObjectList.add(new FR_EXPORTRECORD());
        this.tableObjectList.add(new FR_PRINTRECORD());
        this.tableObjectList.add(new FR_ERRORRECORD());
        this.tableObjectList.add(new FR_SCHEDULERECORD());
        this.addNewColumnToTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewColumnToTable() {
        Connection connection = null;
        try {
            connection = DBRecordManager.getDB().createConnection();
            connection.setAutoCommit(false);
            Dialect dialect = DialectFactory.generateDialect(connection);
            int n2 = this.tableObjectList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Table table = ((TableObject)this.tableObjectList.get(i2)).getTable();
                if (table == null || this.findColumnInTable("sql", connection, table)) continue;
                Column column = new Column("sql", 12, new ColumnSize(2047));
                this.addColumnsToTable(column, connection, table, dialect);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    protected void initIndexList() {
        this.indexList.add(this.createNTRecordIndexSQL("fr_exerecord"));
        this.indexList.add(this.createNTRecordIndexSQL("fr_exprecord"));
        this.indexList.add(this.createNTRecordIndexSQL("fr_ptrecord"));
        this.indexList.add(this.createErrIndexSQL());
        this.indexList.add(this.createScheduleIndexSQL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumnsToTable(Column column, Connection connection, Table table, Dialect dialect) {
        Statement statement = null;
        try {
            AddColumn addColumn = new AddColumn(table, column, dialect);
            statement = addColumn.createPreparedStatement(connection);
            statement.execute();
            connection.commit();
        }
        catch (Exception exception) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private boolean findColumnInTable(String string, Connection connection, Table table) {
        PreparedStatement preparedStatement;
        Select select = new Select(table, DialectFactory.generateDialect(connection));
        try {
            preparedStatement = select.createPreparedStatement(connection);
        }
        catch (SQLException sQLException) {
            return false;
        }
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            for (int i2 = 1; i2 <= n2; ++i2) {
                if (!string.equalsIgnoreCase(resultSetMetaData.getColumnName(i2))) continue;
                return true;
            }
        }
        catch (SQLException sQLException) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return false;
        }
        return false;
    }

    public void generateIndexs(Connection connection) {
        this.initIndexList();
        PreparedStatement preparedStatement = null;
        int n2 = this.indexList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                String string = (String)this.indexList.get(i2);
                if (StringUtils.isBlank(string)) continue;
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.execute();
                connection.commit();
                FRLogger.getLogger().info("Index has been created successfully!");
                preparedStatement.close();
                continue;
            }
            catch (Throwable throwable) {
                if (throwable.getMessage().indexOf("already exists") != -1) continue;
                FRLogger.getLogger().error(throwable.getMessage(), throwable);
                try {
                    preparedStatement.close();
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    private String createNTRecordIndexSQL(String string) {
        StringBuffer stringBuffer = new StringBuffer("create index ");
        stringBuffer.append(string).append("_index on ");
        stringBuffer.append(string).append("(");
        stringBuffer.append("logtime").append(" asc, ");
        stringBuffer.append("type").append(" asc)");
        return stringBuffer.toString();
    }

    private String createErrIndexSQL() {
        StringBuffer stringBuffer = new StringBuffer("create index ");
        stringBuffer.append("fr_errrecord").append("_index on ");
        stringBuffer.append("fr_errrecord").append("(");
        stringBuffer.append("logtime").append(" asc, ");
        stringBuffer.append("type").append(" asc)");
        return stringBuffer.toString();
    }

    private String createScheduleIndexSQL() {
        StringBuffer stringBuffer = new StringBuffer("create index ");
        stringBuffer.append("fr_schedulerecord").append("_index on ");
        stringBuffer.append("fr_schedulerecord").append("(");
        stringBuffer.append("logtime").append(" asc, ");
        stringBuffer.append("type").append(" asc)");
        return stringBuffer.toString();
    }

    private class FR_SCHEDULERECORD
    extends AbstractTableObject {
        private FR_SCHEDULERECORD() {
        }

        public Table getTable() {
            return new Table("fr_schedulerecord");
        }

        public void initColumns() {
            this.addColumn("id", 4, new ColumnSize(20), false, true, true);
            this.addColumn("tname", 12, new ColumnSize(255));
            this.addColumn("sinfo", 12, new ColumnSize(2047));
            this.addColumn("type", -6, new ColumnSize(4));
            this.addColumn("msg", 12, new ColumnSize(1023));
            this.addColumn("trace", -1, new ColumnSize());
            this.addColumn("logtime", 93, new ColumnSize());
            this.addColumn("detailmsg", 12, new ColumnSize(1023));
        }
    }

    private class FR_ERRORRECORD
    extends AbstractTableObject {
        private FR_ERRORRECORD() {
        }

        public Table getTable() {
            return new Table("fr_errrecord");
        }

        public void initColumns() {
            this.addColumn("id", 4, new ColumnSize(20), false, true, true);
            this.addColumn("tname", 12, new ColumnSize(255));
            this.addColumn("sinfo", 12, new ColumnSize(2047));
            this.addColumn("type", -6, new ColumnSize(4));
            this.addColumn("msg", 12, new ColumnSize(1023));
            this.addColumn("trace", -1, new ColumnSize());
            this.addColumn("logtime", 93, new ColumnSize());
            this.addColumn("sql", 12, new ColumnSize(2047));
        }
    }

    private class FR_PRINTRECORD
    extends NTRECORD {
        private FR_PRINTRECORD() {
        }

        public Table getTable() {
            return new Table("fr_ptrecord");
        }
    }

    private class FR_EXPORTRECORD
    extends NTTRECORD {
        private FR_EXPORTRECORD() {
        }

        public Table getTable() {
            return new Table("fr_exprecord");
        }
    }

    private class FR_EXECUTERECORD
    extends NTTRECORD {
        private FR_EXECUTERECORD() {
        }

        public Table getTable() {
            return new Table("fr_exerecord");
        }
    }

    private abstract class NTTRECORD
    extends AbstractTableObject {
        private NTTRECORD() {
        }

        public void initColumns() {
            this.addColumn("id", 4, new ColumnSize(20), false, false, true);
            this.addColumn("tname", 12, new ColumnSize(255));
            this.addColumn("type", -6, new ColumnSize(4));
            this.addColumn("param", 12, new ColumnSize(2047));
            this.addColumn("ip", 12, new ColumnSize(255));
            this.addColumn("username", 12, new ColumnSize(255));
            this.addColumn("userrole", 12, new ColumnSize(255));
            this.addColumn("time", 4, new ColumnSize(20));
            this.addColumn("logtime", 93, new ColumnSize());
            this.addColumn("sql", 12, new ColumnSize(2047));
        }
    }

    private abstract class NTRECORD
    extends AbstractTableObject {
        private NTRECORD() {
        }

        public void initColumns() {
            this.addColumn("id", 4, new ColumnSize(20), false, false, true);
            this.addColumn("tname", 12, new ColumnSize(255));
            this.addColumn("type", -6, new ColumnSize(4));
            this.addColumn("param", 12, new ColumnSize(2047));
            this.addColumn("ip", 12, new ColumnSize(255));
            this.addColumn("username", 12, new ColumnSize(255));
            this.addColumn("userrole", 12, new ColumnSize(255));
            this.addColumn("logtime", 93, new ColumnSize());
        }
    }
}

