/*
 * Decompiled with CFR 0.152.
 */
package com.fr.record;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.DML;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Select;
import com.fr.data.dao.JdbcOperator;
import com.fr.data.dao.ResultSetExtractor;
import java.io.Serializable;
import java.sql.Connection;

public class JdbcTemplate {
    private com.fr.data.impl.Connection databaseConnection;
    private Dialect dialect = null;

    public JdbcTemplate(com.fr.data.impl.Connection connection) {
        this.databaseConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dialect getDialect(Connection connection) {
        if (this.dialect == null) {
            JdbcTemplate jdbcTemplate = this;
            synchronized (jdbcTemplate) {
                this.dialect = DialectFactory.generateDialect(connection);
            }
        }
        return this.dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String string) throws Exception {
        Connection connection = this.databaseConnection.createConnection();
        try {
            JdbcOperator.execute(connection, string);
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object query(String string, ResultSetExtractor resultSetExtractor) throws Exception {
        Connection connection = this.databaseConnection.createConnection();
        try {
            Object object = JdbcOperator.query(connection, string, resultSetExtractor);
            return object;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeQuery(Select select, ResultSetExtractor resultSetExtractor) throws Exception {
        Connection connection = this.databaseConnection.createConnection();
        try {
            Dialect dialect = this.getDialect(connection);
            Object object = JdbcOperator.executeQuery(connection, dialect, select, resultSetExtractor);
            return object;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public Serializable execute(Insert insert, boolean bl) throws Exception {
        Connection connection = this.databaseConnection.createConnection();
        try {
            Dialect dialect = this.getDialect(connection);
            boolean bl2 = connection.getAutoCommit();
            dialect.setAutoCommit(connection, false);
            Serializable serializable = JdbcOperator.execute(connection, dialect, insert, bl);
            connection.commit();
            dialect.setAutoCommit(connection, bl2);
            Serializable serializable2 = serializable;
            return serializable2;
        }
        catch (Exception exception) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw exception;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DML dML) throws Exception {
        Connection connection = this.databaseConnection.createConnection();
        try {
            Dialect dialect = this.getDialect(connection);
            JdbcOperator.execute(connection, dialect, dML);
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }
}

