/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.web.services;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.ParameterMapNameSpace;
import com.fr.data.core.db.DBConstants;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.process.dao.ProcessExecutorCache;
import com.fr.process.engine.processexecutor.ProcessDefineCache;
import com.fr.process.engine.processexecutor.ProcessExecutor;
import com.fr.process.pdl.processdefine.ProcessOB;
import com.fr.process.web.services.ProcessServiceUtils;
import com.fr.script.Calculator;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.core.db.PlatformDB;
import com.fr.web.utils.WebUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProcessTaskQueryAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "querytask";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONArray jSONArray;
        block7: {
            JSONArray jSONArray2 = (JSONArray)BaseUtils.jsonDecode(WebUtils.getHTTPRequestParameter(httpServletRequest, "conditions"));
            long l2 = Long.parseLong(WebUtils.getHTTPRequestParameter(httpServletRequest, "processid"));
            JSONArray jSONArray3 = (JSONArray)BaseUtils.jsonDecode(WebUtils.getHTTPRequestParameter(httpServletRequest, "showname"));
            long l3 = ServiceUtils.getCurrentUserID(httpServletRequest);
            Connection connection = this.getConnection();
            jSONArray = new JSONArray();
            try {
                try {
                    ResultSet resultSet = this.executeQuery(jSONArray2, l2, l3, connection);
                    while (resultSet.next()) {
                        JSONObject jSONObject = new JSONObject();
                        long l4 = resultSet.getLong("FR_SYSTEM_ID");
                        ProcessExecutor processExecutor = ProcessExecutorCache.getInstance().getProcessExecutorByID(l4);
                        jSONObject.put("FR_SYSTEM_ID", l4);
                        jSONObject.put("fr_process_id", l2);
                        for (int i2 = 0; i2 < jSONArray3.length(); ++i2) {
                            String string = resultSet.getString(jSONArray3.getString(i2));
                            jSONObject.put(jSONArray3.getString(i2), string == null ? " " : string);
                        }
                        jSONArray.put(jSONObject);
                    }
                    Object var19_16 = null;
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                    connection.rollback();
                    Object var19_17 = null;
                    DBUtils.closeConnection(connection);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Object var19_18 = null;
                DBUtils.closeConnection(connection);
                throw throwable;
            }
            DBUtils.closeConnection(connection);
        }
        ProcessServiceUtils.writeBack(httpServletResponse, jSONArray.toString());
    }

    private ResultSet executeQuery(JSONArray jSONArray, long l2, long l3, Connection connection) throws Exception {
        Dialect dialect = DialectFactory.generateDialect(connection);
        ProcessOB processOB = ProcessDefineCache.getInstance().getProcessByID(l2);
        String string = "FR_T_" + processOB.getSystem().getSystemName().toUpperCase();
        Table table = new Table(string);
        Select select = new Select(table, dialect);
        Where where = new Where();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            Object object;
            String string2 = "";
            int n2 = 0;
            int n3 = 0;
            Object object2 = null;
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            if (jSONObject.has("field")) {
                string2 = jSONObject.getString("field");
            }
            if (jSONObject.has("op")) {
                n3 = jSONObject.getInt("op");
            }
            if (jSONObject.has("type")) {
                object = jSONObject.getString("type");
                n2 = ComparatorUtils.equals(object, "number") ? 8 : (ComparatorUtils.equals(object, "date") ? 91 : DBConstants.FR_STRING);
            }
            if (jSONObject.has("value")) {
                if (n2 == DBConstants.FR_NUMBER) {
                    object2 = new Double(jSONObject.getDouble("value"));
                } else if (n2 == 91) {
                    object2 = DateUtils.string2Date(jSONObject.getString("value"), false);
                } else {
                    object2 = jSONObject.getString("value");
                    object = Calculator.createCalculator();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("currentUser", UserControl.getInstance().getUser(l3).getUsername());
                    ((Calculator)object).pushNameSpace(ParameterMapNameSpace.create(hashMap));
                    if (object2.toString().startsWith("$")) {
                        object2 = ((Calculator)object).eval(object2.toString().substring(1));
                    }
                }
            }
            where.addColumn(string2, n2, n3, object2);
        }
        select.setWhere(where);
        PreparedStatement preparedStatement = select.createPreparedStatement(connection);
        return preparedStatement.executeQuery();
    }

    private Connection getConnection() throws Exception {
        return PlatformDB.getDB().createConnection();
    }
}

