/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.web.services;

import com.fr.base.FRContext;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Delete;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.data.dao.DAOManagerFactory;
import com.fr.data.dao.DAOUtils;
import com.fr.data.dao.JdbcDaoProperties;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.impl.DBTableData;
import com.fr.file.DatasourceManager;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.dao.properties.ProcessDaoProperties;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.process.engine.processexecutor.ProcessDefineCache;
import com.fr.process.engine.processexecutor.SystemCache;
import com.fr.process.pdl.processdefine.ProcessOB;
import com.fr.process.pdl.processdefine.SystemOfProcesses;
import com.fr.process.web.services.NameLock;
import com.fr.process.web.services.ProcessServiceUtils;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.core.db.PlatformDB;
import com.fr.web.utils.WebUtils;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProcessOBSaveAction
extends ActionNoSessionCMD {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasProcessManagerModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        JSONObject jSONObject = new JSONObject(WebUtils.getHTTPRequestParameter(httpServletRequest, "process"));
        ProcessOB processOB = new ProcessOB();
        processOB.parseJSON(jSONObject);
        this.dealWithSystem(jSONObject, processOB);
        boolean bl = false;
        if (jSONObject.has("itemChanged")) {
            bl = jSONObject.getBoolean("itemChanged");
        }
        if (bl) {
            this.createTableDataForParaChange(jSONObject, processOB);
            this.createDBTableData(processOB.getSystem().getSystemName());
        }
        try {
            Object object = NameLock.generateNameLock(processOB.getName());
            synchronized (object) {
                if (processOB.getId() > 0L) {
                    ProcessOB processOB2 = ProcessDefineCache.getInstance().getProcessByID(processOB.getId());
                    processOB2.updateProperties(processOB);
                } else {
                    processOB.deployment();
                }
                ProcessServiceUtils.writeBack(httpServletResponse, processOB.getId());
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            NameLock.removeNameLock(processOB.getName());
            throw throwable;
        }
        NameLock.removeNameLock(processOB.getName());
    }

    private void dealWithSystem(JSONObject jSONObject, ProcessOB processOB) throws Exception {
        String string;
        String string2 = jSONObject.has("originalShareProcessName") ? jSONObject.getString("originalShareProcessName") : "";
        String string3 = jSONObject.has("shareProcessName") ? jSONObject.getString("shareProcessName") : "";
        String string4 = string = jSONObject.has("name") ? jSONObject.getString("name") : "";
        if (!ComparatorUtils.equals(string2, string3)) {
            processOB.resetSystem();
            String string5 = SystemCache.getSystemNameOfProcess(string);
            if (StringUtils.isNotEmpty(string5)) {
                SystemOfProcesses systemOfProcesses = SystemCache.getSystem(string5);
                systemOfProcesses.removeProcess(string);
                if (systemOfProcesses.getProcessesLength() < 1) {
                    this.deleteDBTableData(string5);
                    this.dropTable(string5);
                    SystemCache.removeSystem(string5);
                } else {
                    SystemCache.addSystemOfProcesses(systemOfProcesses);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dropTable(String string) {
        String string2 = "drop table FR_T_" + string.toUpperCase();
        Connection connection = null;
        try {
            try {
                connection = PlatformDB.getDB().createConnection();
                Statement statement = connection.createStatement();
                statement.execute(string2);
                Dialect dialect = DialectFactory.generateDialect(connection);
                Table table = new Table("FR_T_" + DAOUtils.getClassNameWithOutPath(SystemOfProcesses.class));
                Where where = new Where();
                where.addColumn("name", string);
                Delete delete = new Delete(table, where, dialect);
                delete.execute(connection);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.INFO, exception.getMessage());
                Object var10_11 = null;
                DBUtils.closeConnection(connection);
                return;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            DBUtils.closeConnection(connection);
            throw throwable;
        }
        DBUtils.closeConnection(connection);
    }

    private void createTableDataForParaChange(JSONObject jSONObject, ProcessOB processOB) throws Exception {
        Object object;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (jSONObject.has("parameters")) {
            object = jSONObject.getJSONArray("parameters");
            for (int i2 = 0; i2 < ((JSONArray)object).length(); ++i2) {
                JSONObject jSONObject2 = ((JSONArray)object).getJSONObject(i2);
                String string = jSONObject2.getString("type");
                String string2 = jSONObject2.getString("name");
                if (ComparatorUtils.equals(string, "Multi")) {
                    hashMap.put(string2, new Integer(12));
                    continue;
                }
                hashMap.put(string2, new Integer(this.checkTypeForSql(string)));
            }
        }
        object = new ProcessDaoProperties();
        ObjectTableMapper objectTableMapper = processOB.getTableMapperFromParas(hashMap);
        ((ProcessDaoProperties)object).addTableMapper(objectTableMapper);
        DAOManagerFactory.createJDBCDAOManager((JdbcDaoProperties)object).checkTables();
    }

    private void createDBTableData(String string) throws Exception {
        DBTableData dBTableData = new DBTableData();
        dBTableData.setDatabase(PlatformDB.getDB());
        dBTableData.setQuery("Select * from FR_T_" + string.toUpperCase());
        DatasourceManager datasourceManager = DatasourceManager.getInstance();
        datasourceManager.putTableData(string, dBTableData);
        FRContext.getCurrentEnv().writeResource(datasourceManager);
    }

    private void deleteDBTableData(String string) throws Exception {
        DatasourceManager datasourceManager = DatasourceManager.getInstance();
        datasourceManager.removeTableData(string);
        FRContext.getCurrentEnv().writeResource(datasourceManager);
    }

    private int checkTypeForSql(String string) {
        if ("Integer".equals(string)) {
            return 4;
        }
        if ("Double".equals(string)) {
            return 4;
        }
        if ("Date".equals(string)) {
            return 91;
        }
        if ("Boolean".equals(string)) {
            return 16;
        }
        return 12;
    }

    private Class checkTypeForEmbeddedTD(String string) {
        if ("Integer".equals(string)) {
            return Integer.class;
        }
        if ("Double".equals(string)) {
            return Rectangle2D.Double.class;
        }
        if ("Date".equals(string)) {
            return Date.class;
        }
        return String.class;
    }

    public String getCMD() {
        return "save";
    }
}

