/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.pdl.task;

import com.fr.data.dao.DAOUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.process.engine.processexecutor.ProcessExecutor;
import com.fr.process.pdl.io.ProcessIOUtils;
import com.fr.process.pdl.processdefine.CenterPoint;
import com.fr.process.pdl.task.Task;
import com.fr.process.pdl.task.Task4Database;
import com.fr.process.pdl.transition.TransitionImpl;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractTask
implements Task {
    private String name;
    private int joinMode = 0;
    private boolean executed = false;
    private Set outTransitions = new HashSet();
    private Set executedInTransitions = new HashSet();
    private Set executedOutTransitions = new HashSet();
    private Task parentTask;
    protected Task4Database datatask;
    private CenterPoint centerPoint;
    private String oldname;
    private String descript;

    public String getDescript() {
        return this.descript;
    }

    public void setDescript(String string) {
        this.descript = string;
    }

    public String getOldName() {
        return this.oldname;
    }

    public boolean equalsMainProper(Object object) {
        if (object == null || !(object instanceof AbstractTask)) {
            return false;
        }
        return ComparatorUtils.equals(this.name, ((AbstractTask)object).name);
    }

    public boolean equals(Object object) {
        if (!this.equalsMainProper(object)) {
            return false;
        }
        if (!ComparatorUtils.equals(this.outTransitions, ((AbstractTask)object).outTransitions)) {
            return false;
        }
        if (this.joinMode != ((AbstractTask)object).joinMode) {
            return false;
        }
        return ComparatorUtils.equals(this.centerPoint, ((AbstractTask)object).centerPoint);
    }

    protected void execute(ProcessExecutor processExecutor) {
        if (this.isExecuted()) {
            return;
        }
        this.setExecuted(true);
    }

    protected boolean executeIn(ProcessExecutor processExecutor, TransitionImpl transitionImpl) {
        if (this.isExecuted()) {
            return true;
        }
        processExecutor.addTask(this);
        if (transitionImpl != null && this.addExecutedInTransition(transitionImpl.getName())) {
            this.saveOrUpdate();
        }
        if (transitionImpl != null && transitionImpl.isBack()) {
            return true;
        }
        if (this.getJoinMode() == 1) {
            return true;
        }
        if (this.getJoinMode() == 0) {
            return this.getInTransitions(processExecutor).size() == this.getExecutedInTransitions().size();
        }
        return false;
    }

    protected void executeOut(ProcessExecutor processExecutor) {
        Set set = this.getOutTransitions();
        int n2 = set.size();
        int n3 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ++n3;
            TransitionImpl transitionImpl = (TransitionImpl)iterator.next();
            if (this.getExecutedOutTransitions().contains(transitionImpl.getName())) continue;
            if (this.addExecutedOutTransition(transitionImpl.getName())) {
                this.saveOrUpdate();
            }
            if (n3 == n2) {
                processExecutor.removeTask(this);
                this.remove();
            }
            processExecutor.executeTransition(transitionImpl);
        }
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public void setExecuted(boolean bl) {
        this.executed = bl;
    }

    public String getType() {
        return DAOUtils.getClassNameWithOutPath(this.getClass()).toLowerCase();
    }

    private Task4Database createTask() {
        if (this.datatask == null) {
            this.datatask = new Task4Database(this.getName(), this.isExecuted(), this.executedInTransitions, this.executedOutTransitions);
        } else {
            this.datatask.setExecuted(this.isExecuted());
            this.datatask.setExecutedInTransitions(this.executedInTransitions);
            this.datatask.setExecutedOutTransitions(this.executedOutTransitions);
        }
        return this.datatask;
    }

    public void setTask4Database(Task4Database task4Database) {
        this.datatask = task4Database;
    }

    public Task4Database getTask4Database() {
        return this.datatask;
    }

    protected long saveOrUpdate() {
        if (this.createTask().getId() < 0L) {
            return this.save();
        }
        if (this.update()) {
            return this.datatask.getId();
        }
        return -1L;
    }

    protected long save() {
        this.createTask().setId(Task4Database.getDaoAccess().save(this.datatask));
        return this.datatask.getId();
    }

    protected boolean update() {
        return Task4Database.getDaoAccess().update(this.createTask());
    }

    public String getID() {
        if (this.datatask == null || this.datatask.getId() < 0L) {
            return new StringBuffer().append(this.save()).toString();
        }
        return new StringBuffer().append(this.datatask.getId()).toString();
    }

    public void remove() {
        if (this.datatask == null) {
            return;
        }
        this.datatask.remove();
        this.datatask = null;
    }

    public boolean addExecutedInTransition(String string) {
        return this.executedInTransitions.add(string);
    }

    public boolean removeExecutedInTransition(String string) {
        return this.executedInTransitions.remove(string);
    }

    public boolean addExecutedOutTransition(String string) {
        return this.executedOutTransitions.add(string);
    }

    public boolean removeExecutedOutTransition(String string) {
        return this.executedOutTransitions.remove(string);
    }

    public boolean addOutTransition(TransitionImpl transitionImpl) {
        return this.outTransitions.add(transitionImpl);
    }

    public boolean removeOutTransition(TransitionImpl transitionImpl) {
        return this.outTransitions.remove(transitionImpl);
    }

    public Set getInTransitions(ProcessExecutor processExecutor) {
        Set set = processExecutor.getProcessDefine().getInTransitions(this);
        for (TransitionImpl transitionImpl : set) {
            if (!transitionImpl.isBack()) continue;
            set.remove(transitionImpl);
        }
        return set;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public CenterPoint getCenterPoint() {
        return this.centerPoint;
    }

    public void setCenterPoint(CenterPoint centerPoint) {
        this.centerPoint = centerPoint;
    }

    public Set getOutTransitions() {
        return this.outTransitions;
    }

    public Set getExecutedInTransitions() {
        return this.executedInTransitions;
    }

    public Set getExecutedOutTransitions() {
        return this.executedOutTransitions;
    }

    public int getJoinMode() {
        return this.joinMode;
    }

    public void setJoinMode(int n2) {
        this.joinMode = n2;
    }

    public void setParent(Task task) {
        this.parentTask = task;
    }

    public Task getParent() {
        return this.parentTask;
    }

    protected int hashCode4Properties() {
        return 0;
    }

    public boolean equals4Properties(Object object) {
        return false;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.setDescript(xMLableReader.getAttrAsString("descript", null));
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Name")) {
                this.setName(xMLableReader.getElementValue());
            } else if (string.equals("JoinMode")) {
                this.setJoinMode(new Integer(xMLableReader.getElementValue()));
            } else if (string.equals("Transitions")) {
                this.outTransitions = ProcessIOUtils.readSetTransition(xMLableReader);
            } else if (string.endsWith("CenterPoint")) {
                CenterPoint centerPoint = new CenterPoint();
                xMLableReader.readXMLObject(centerPoint);
                this.centerPoint = centerPoint;
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.attr("descript", this.getDescript());
        xMLPrintWriter.startTAG("Name").textNode(this.getName()).end();
        xMLPrintWriter.startTAG("JoinMode").textNode(new StringBuffer().append(this.getJoinMode()).toString()).end();
        if (this.centerPoint != null) {
            this.centerPoint.writeXML(xMLPrintWriter);
        }
        ProcessIOUtils.writeSetTransition(this.getOutTransitions(), xMLPrintWriter);
    }

    public void parseJSON(JSONObject jSONObject) {
        try {
            if (jSONObject.has("name")) {
                this.setName(jSONObject.getString("name"));
            }
            if (jSONObject.has("oldname") && !this.name.equals(jSONObject.getString("oldname"))) {
                this.oldname = jSONObject.getString("oldname");
            }
            if (jSONObject.has("descript")) {
                this.setDescript(jSONObject.getString("descript"));
            }
            if (jSONObject.has("joinMode")) {
                this.setJoinMode(jSONObject.getInt("joinMode"));
            }
            if (jSONObject.has("centerPoint")) {
                this.centerPoint = new CenterPoint();
                this.centerPoint.parseJSON(jSONObject.getJSONObject("centerPoint"));
            }
            if (jSONObject.has("transitions")) {
                JSONArray jSONArray = jSONObject.getJSONArray("transitions");
                int n2 = jSONArray.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    TransitionImpl transitionImpl = new TransitionImpl();
                    transitionImpl.parseJSON(jSONArray.getJSONObject(i2));
                    this.outTransitions.add(transitionImpl);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JSONObject createJSON() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("name", this.getName());
            jSONObject.put("joinMode", this.getJoinMode());
            jSONObject.put("type", this.getType());
            if (this.centerPoint != null) {
                jSONObject.put("centerPoint", this.centerPoint.createJSON());
            }
            if (StringUtils.isNotEmpty(this.descript)) {
                jSONObject.put("descript", this.descript);
            }
            if (this.outTransitions.size() > 0) {
                Iterator iterator = this.outTransitions.iterator();
                JSONArray jSONArray = new JSONArray();
                while (iterator.hasNext()) {
                    TransitionImpl transitionImpl = (TransitionImpl)iterator.next();
                    jSONArray.put(transitionImpl.createJSON());
                }
                jSONObject.put("transitions", jSONArray);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public boolean checkUser(ProcessExecutor processExecutor) {
        return true;
    }

    public abstract String getReportName() throws Exception;

    public Object clone4Exe() throws CloneNotSupportedException {
        AbstractTask abstractTask = (AbstractTask)super.clone();
        abstractTask.executedInTransitions = new HashSet();
        abstractTask.executedOutTransitions = new HashSet();
        return abstractTask;
    }
}

