/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.pdl.json;

import com.fr.data.dao.DAOUtils;
import com.fr.json.JSONObject;
import com.fr.process.pdl.task.AbstractTask;
import com.fr.process.pdl.task.EndTask;
import com.fr.process.pdl.task.FormTask;
import com.fr.process.pdl.task.StartTask;
import com.fr.process.pdl.task.SubProTask;
import com.fr.process.pdl.task.Task;
import com.fr.process.pdl.user.FormulaUsers;
import com.fr.process.pdl.user.ParameterUsers;
import com.fr.process.pdl.user.RoleUsers;
import com.fr.process.pdl.user.TaskUsers;

public class JSONUtils {
    public static Task parseTask(JSONObject jSONObject) throws Exception {
        AbstractTask abstractTask = null;
        if (jSONObject.has("type")) {
            String string = jSONObject.getString("type");
            if (string.equals(JSONUtils.getType(StartTask.class))) {
                abstractTask = new StartTask();
                abstractTask.parseJSON(jSONObject);
            } else if (string.equals(JSONUtils.getType(EndTask.class))) {
                abstractTask = new EndTask();
                abstractTask.parseJSON(jSONObject);
            } else if (string.equals(JSONUtils.getType(FormTask.class))) {
                abstractTask = new FormTask();
                abstractTask.parseJSON(jSONObject);
            } else if (string.equals(JSONUtils.getType(SubProTask.class))) {
                abstractTask = new SubProTask();
                abstractTask.parseJSON(jSONObject);
            }
        }
        return abstractTask;
    }

    public static String getType(Class clazz) {
        return DAOUtils.getClassNameWithOutPath(clazz).toLowerCase();
    }

    public static TaskUsers parseTaskUsers(JSONObject jSONObject) throws Exception {
        TaskUsers taskUsers = null;
        if (jSONObject.has("type")) {
            String string = jSONObject.getString("type");
            if (string.equals(JSONUtils.getType(RoleUsers.class))) {
                taskUsers = new RoleUsers();
                taskUsers.parseJSON(jSONObject);
            } else if (string.equals(JSONUtils.getType(ParameterUsers.class))) {
                taskUsers = new ParameterUsers();
                taskUsers.parseJSON(jSONObject);
            } else if (string.equals(JSONUtils.getType(FormulaUsers.class))) {
                taskUsers = new FormulaUsers();
                taskUsers.parseJSON(jSONObject);
            }
        }
        return taskUsers;
    }
}

