/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.pdl.io;

import com.fr.base.BaseXMLUtils;
import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.base.io.XMLReadHelper;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.process.pdl.processdefine.ProcessOB;
import com.fr.process.pdl.task.Task;
import com.fr.process.pdl.transition.ConditionTransition;
import com.fr.process.pdl.transition.TransitionImpl;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ProcessIOUtils {
    public static final String PROCESS = "process";
    public static final String TYPE = ".xml";

    public static void writeTriggerTransitions(ConditionTransition[] conditionTransitionArray, XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("TriggerTransitions");
        int n2 = conditionTransitionArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            conditionTransitionArray[i2].writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public static ConditionTransition[] readTriggerTransitions(XMLableReader xMLableReader) {
        final HashSet hashSet = new HashSet();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("TriggerTransition")) {
                    try {
                        ConditionTransition conditionTransition = (ConditionTransition)GeneralUtils.classForName(xMLableReader.getAttrAsString("class", null)).newInstance();
                        xMLableReader.readXMLObject(conditionTransition);
                        hashSet.add(conditionTransition);
                    }
                    catch (InstantiationException instantiationException) {
                        FRLogger.getLogger().error(instantiationException.getMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        FRLogger.getLogger().error(illegalAccessException.getMessage());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FRLogger.getLogger().error(classNotFoundException.getMessage());
                    }
                }
            }
        });
        return hashSet.size() < 1 ? null : hashSet.toArray(new ConditionTransition[hashSet.size()]);
    }

    public static void writeSetTransition(Set set, XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Transitions");
        for (TransitionImpl transitionImpl : set) {
            transitionImpl.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public static Set readSetTransition(XMLableReader xMLableReader) {
        final HashSet hashSet = new HashSet();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    TransitionImpl transitionImpl = new TransitionImpl();
                    transitionImpl.readXML(xMLableReader);
                    hashSet.add(transitionImpl);
                }
            }
        });
        return hashSet;
    }

    public static void writeSetParameters(Set set, XMLPrintWriter xMLPrintWriter) {
        if (set.size() < 1) {
            return;
        }
        ParameterProvider[] parameterProviderArray = set.toArray(new Parameter[set.size()]);
        StableXMLUtils.writeParameters(xMLPrintWriter, parameterProviderArray);
    }

    public static Set readSetParameters(XMLableReader xMLableReader) {
        Parameter[] parameterArray = BaseXMLUtils.readParameters(xMLableReader);
        return new HashSet<Parameter>(Arrays.asList(parameterArray));
    }

    public static void writeSetTasks(Set set, XMLPrintWriter xMLPrintWriter) {
        if (set.size() < 1) {
            return;
        }
        xMLPrintWriter.startTAG("Tasks");
        for (Task task : set) {
            task.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public static Set readSetTasks(XMLableReader xMLableReader) {
        final HashSet hashSet = new HashSet();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Task")) {
                    String string = xMLableReader.getAttrAsString("class", null);
                    try {
                        Task task = (Task)GeneralUtils.classForName(string).newInstance();
                        xMLableReader.readXMLObject(task);
                        hashSet.add(task);
                    }
                    catch (InstantiationException instantiationException) {
                        FRLogger.getLogger().error(instantiationException.getMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        FRLogger.getLogger().error(illegalAccessException.getMessage());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FRLogger.getLogger().error(classNotFoundException.getMessage());
                    }
                }
            }
        });
        return hashSet;
    }

    public static void removeProcessFile(String string) throws Exception {
        File file = new File(ProcessIOUtils.generatePath(string));
        if (file.exists()) {
            file.delete();
        }
    }

    public static ProcessOB readProcess(String string) throws Exception {
        InputStream inputStream = ProcessIOUtils.getProcessStream(string);
        if (inputStream == null) {
            return null;
        }
        XMLableReader xMLableReader = XMLReadHelper.createXMLableReader(ProcessIOUtils.getProcessStream(string), "UTF-8");
        if (xMLableReader == null) {
            return null;
        }
        String string2 = xMLableReader.getTagName();
        if (!string2.equals("ProcessOB")) {
            throw new Exception("Process XML Wrong!");
        }
        ProcessOB processOB = new ProcessOB();
        xMLableReader.readXMLObject(processOB);
        inputStream.close();
        return processOB;
    }

    public static void writeProcess(ProcessOB processOB) throws Exception {
        String string = processOB.getName();
        if (StringUtils.isEmpty(string)) {
            throw new Exception("Process Name cann't be NULL!");
        }
        OutputStream outputStream = ProcessIOUtils.getOutputStream(string);
        XMLPrintWriter xMLPrintWriter = XMLPrintWriter.create(outputStream);
        processOB.writeXML(xMLPrintWriter);
        xMLPrintWriter.flush();
        xMLPrintWriter.close();
        outputStream.flush();
        outputStream.close();
    }

    private static InputStream getProcessStream(String string) throws Exception {
        File file = new File(ProcessIOUtils.generatePath(string));
        if (!file.exists()) {
            FRLogger.getLogger().info("File named " + string + " for process doesn't exsits!");
            return null;
        }
        return new FileInputStream(file);
    }

    private static OutputStream getOutputStream(String string) throws Exception {
        File file = new File(ProcessIOUtils.generatePath(string));
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        return new FileOutputStream(file);
    }

    private static String generatePath(String string) {
        return FRContext.getCurrentEnv().getPath() + File.separator + PROCESS + File.separator + string + TYPE;
    }
}

