/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.engine.processexecutor;

import com.fr.base.FRContext;
import com.fr.general.GeneralContext;
import com.fr.process.engine.processexecutor.SystemCache;
import com.fr.process.pdl.io.ProcessIOUtils;
import com.fr.process.pdl.processdefine.ProcessOB;
import com.fr.process.pdl.processdefine.SystemOfProcesses;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;

public class ProcessDefineCache {
    private static ProcessDefineCache pdc = null;
    private static HashMap map = new HashMap();

    public static synchronized ProcessDefineCache getInstance() {
        if (map.size() == 0) {
            pdc = new ProcessDefineCache();
            try {
                pdc.initProcessCache();
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return pdc;
    }

    private void clearProcessDefineCache() throws Exception {
        pdc = null;
        map.clear();
    }

    private synchronized void initProcessCache() throws Exception {
        if (map.size() == 0) {
            List list = ProcessOB.getDaoAccess().findAll();
            for (ProcessOB processOB : list) {
                ProcessOB processOB2 = ProcessIOUtils.readProcess(processOB.getName());
                if (processOB2 == null) continue;
                processOB2.setId(processOB.getId());
                map.put(processOB2.getName(), processOB2);
            }
        }
    }

    public ProcessOB getProcess(String string) throws Exception {
        if (!map.containsKey(string)) {
            return null;
        }
        return (ProcessOB)map.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessOB getProcessByID(long l2) throws Exception {
        ProcessDefineCache processDefineCache = this;
        synchronized (processDefineCache) {
            if (l2 < 0L) {
                System.out.println("===============id<0:" + l2);
                return null;
            }
            ProcessOB[] processOBArray = this.getAllProcess();
            int n2 = processOBArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (processOBArray[i2].getId() != l2) continue;
                return processOBArray[i2];
            }
            System.out.println("===================" + processOBArray.length);
            return null;
        }
    }

    public ProcessOB[] getAllProcess() throws Exception {
        return map.size() == 0 ? new ProcessOB[]{} : map.values().toArray(new ProcessOB[map.size()]);
    }

    public void addProcessOB(ProcessOB processOB) throws Exception {
        map.put(processOB.getName(), processOB);
        ProcessIOUtils.writeProcess(processOB);
        String string = processOB.getShareProcessName();
        String string2 = "";
        SystemOfProcesses systemOfProcesses = null;
        if (StringUtils.isNotEmpty(string)) {
            string2 = SystemCache.getOrCreateSystemName(string);
            systemOfProcesses = SystemCache.getSystem(string2);
        } else {
            string2 = SystemCache.getOrCreateSystemName(processOB.getName());
            systemOfProcesses = SystemCache.getSystem(string2);
        }
        if (systemOfProcesses == null) {
            systemOfProcesses = new SystemOfProcesses(string2);
        }
        systemOfProcesses.addProcess(processOB.getName());
        if (systemOfProcesses.getId() > -1L) {
            systemOfProcesses.update();
        } else {
            systemOfProcesses.save();
        }
        SystemCache.addSystemOfProcesses(systemOfProcesses);
    }

    public void removeProcess(String string) throws Exception {
        if (this.getProcess(string) == null) {
            return;
        }
        map.remove(string);
        ProcessIOUtils.removeProcessFile(string);
    }

    static {
        try {
            ProcessDefineCache.getInstance().initProcessCache();
            GeneralContext.addEnvChangedListener(new EnvChangedListener(){

                public void envChanged() {
                    try {
                        ProcessDefineCache.getInstance().clearProcessDefineCache();
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                    }
                }
            });
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
    }
}

