/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.authentication;

import com.fr.general.ComparatorUtils;
import com.fr.privilege.Authentication;
import com.fr.privilege.Authority;

public abstract class AbstractAuthentication
implements Authentication {
    private static final long serialVersionUID = 5846413362332382520L;
    private Authority[] authorities;
    private boolean authenticated = false;
    protected boolean isRoot = false;

    public void setAuthorities(Authority[] authorityArray) {
        this.authorities = authorityArray;
    }

    public Authority[] getAuthorities() {
        if (this.authorities == null) {
            return new Authority[0];
        }
        Authority[] authorityArray = new Authority[this.authorities.length];
        System.arraycopy(this.authorities, 0, authorityArray, 0, this.authorities.length);
        return authorityArray;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean bl) {
        this.authenticated = bl;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean bl) {
        this.isRoot = bl;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractAuthentication && ComparatorUtils.equals(((AbstractAuthentication)object).authorities, this.authorities) && ComparatorUtils.equals(((AbstractAuthentication)object).getCredentials(), this.getCredentials()) && ComparatorUtils.equals(((AbstractAuthentication)object).getPrincipal(), this.getPrincipal()) && ((AbstractAuthentication)object).authenticated == this.authenticated;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append(": ");
        stringBuffer.append("Principal: ").append(this.getPrincipal()).append("; ");
        stringBuffer.append("Password: [PROTECTED]; ");
        stringBuffer.append("Authenticated: ").append(this.isAuthenticated()).append("; ");
        if (this.getAuthorities() != null) {
            stringBuffer.append("Granted Authorities: ");
            for (int i2 = 0; i2 < this.getAuthorities().length; ++i2) {
                if (i2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getAuthorities()[i2].toString());
            }
        } else {
            stringBuffer.append("Not granted any authorities");
        }
        return stringBuffer.toString();
    }
}

