/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.allocation;

import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.privilege.Authority;
import com.fr.privilege.allocation.Allocation;
import com.fr.privilege.allocation.AuthorityAllocation;
import com.fr.privilege.filter.AuthorityControlFilter;
import com.fr.privilege.filter.AuthorityRoleDAOManager;
import com.fr.stable.StringUtils;
import java.util.Arrays;

public class Allow {
    public static final String ROOT_PATH = "/root/";
    private String[] roleNames;

    public Allow() {
        this.roleNames = new String[0];
    }

    public Allow(String string) {
        this.roleNames = new String[]{string};
    }

    public Allow(String[] stringArray) {
        this.roleNames = stringArray;
    }

    public static Allocation getAllocation(String string) {
        AuthorityControlFilter authorityControlFilter = AuthorityRoleDAOManager.getAuthControlFilter(false);
        if (string == null || authorityControlFilter == null) {
            return new Allocation();
        }
        try {
            AuthorityAllocation authorityAllocation = AuthorityRoleDAOManager.getAuthorityAllocation(authorityControlFilter, string);
            if (authorityAllocation == null) {
                Allocation allocation = new Allocation();
                AuthorityRoleDAOManager.addAuthorityRole(authorityControlFilter, new Authority(string), allocation, false, false);
                return allocation;
            }
            return authorityAllocation.getAllocation();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return new Allocation();
        }
    }

    public int allowView(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        for (int i2 = 0; i2 < this.roleNames.length; ++i2) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i2]);
            int n2 = string.lastIndexOf("/");
            String string2 = n2 < 1 ? ROOT_PATH : string.substring(0, n2);
            int n3 = allocation.getViewCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!StringUtils.equalsIgnore(allocation.getView(i3).getPath(), string, "/") && this.allowFileFolderView(string2) != 1) continue;
                return 1;
            }
        }
        return 0;
    }

    public int allowFileFolderView(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        for (int i2 = 0; i2 < this.roleNames.length; ++i2) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i2]);
            int n2 = allocation.getViewCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                if (StringUtils.perfectSurround(string, "/").startsWith(allocation.getView(i3).getPath())) {
                    return 1;
                }
                if (!allocation.getView(i3).getPath().startsWith(StringUtils.perfectEnd(string, "/"))) continue;
                return 2;
            }
        }
        return 0;
    }

    public int allowWrite(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        for (int i2 = 0; i2 < this.roleNames.length; ++i2) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i2]);
            int n2 = string.lastIndexOf("/");
            String string2 = n2 < 1 ? ROOT_PATH : string.substring(0, n2);
            if (string.endsWith(".frm")) {
                return 0;
            }
            int n3 = allocation.getWriteCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!StringUtils.equalsIgnore(allocation.getWrite(i3).getPath(), string, "/") && this.allowFileFolderWrite(string2) != 1) continue;
                return 1;
            }
        }
        return 0;
    }

    public int allowFileFolderWrite(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.roleNames.length; ++i2) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i2]);
            int n3 = allocation.getWriteCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                if (StringUtils.perfectSurround(string, "/").startsWith(allocation.getWrite(i3).getPath())) {
                    return 1;
                }
                if (!allocation.getWrite(i3).getPath().startsWith(StringUtils.perfectEnd(string, "/"))) continue;
                n2 = 2;
            }
        }
        return n2;
    }

    public int allowDesign(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        for (int i2 = 0; i2 < this.roleNames.length; ++i2) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i2]);
            int n2 = string.lastIndexOf("/");
            String string2 = n2 < 1 ? ROOT_PATH : string.substring(0, n2);
            int n3 = allocation.getDesignCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!StringUtils.equalsIgnore(allocation.getDesign(i3).getPath(), string, "/") && this.allowFileFolderDesign(string2) != 1) continue;
                return 1;
            }
        }
        return 0;
    }

    public int allowFileFolderDesign(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.roleNames.length; ++i2) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i2]);
            int n3 = allocation.getDesignCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                if (StringUtils.perfectSurround(string, "/").startsWith(allocation.getDesign(i3).getPath())) {
                    return 1;
                }
                if (!allocation.getDesign(i3).getPath().startsWith(StringUtils.perfectEnd(string, "/"))) continue;
                n2 = 2;
            }
        }
        return n2;
    }

    public int allowForm(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        for (int i2 = 0; i2 < this.roleNames.length; ++i2) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i2]);
            int n2 = string.lastIndexOf("/");
            String string2 = n2 < 1 ? ROOT_PATH : string.substring(0, n2);
            int n3 = allocation.getFormCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!StringUtils.equalsIgnore(allocation.getForm(i3).getPath(), string, "/") && this.allowFileFolderForm(string2) != 1) continue;
                return 1;
            }
        }
        return 0;
    }

    public int allowFileFolderForm(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.roleNames.length; ++i2) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i2]);
            int n3 = allocation.getFormCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                if (StringUtils.perfectSurround(string, "/").startsWith(allocation.getForm(i3).getPath())) {
                    return 1;
                }
                if (!allocation.getForm(i3).getPath().startsWith(StringUtils.perfectEnd(string, "/"))) continue;
                n2 = 2;
            }
        }
        return n2;
    }

    public int allowExcelSubmit(String string) throws JSONException {
        if (Arrays.asList(this.roleNames).contains("root")) {
            return 1;
        }
        for (int i2 = 0; i2 < this.roleNames.length; ++i2) {
            Allocation allocation = Allow.getAllocation(this.roleNames[i2]);
            int n2 = string.lastIndexOf("/");
            String string2 = n2 < 1 ? ROOT_PATH : string.substring(0, n2);
            int n3 = allocation.getExcelSubmitCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!StringUtils.equalsIgnore(allocation.getExcelSubmit(i3).getPath(), string, "/") && !StringUtils.equalsIgnore(allocation.getDesign(i3).getPath(), string2, "/")) continue;
                return 1;
            }
        }
        return 0;
    }
}

