/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege;

import com.fr.data.DataUtils;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.privilege.Authentication;
import com.fr.privilege.Authority;
import com.fr.privilege.authentication.FSRoleAuthentication;
import com.fr.privilege.base.PrivilegeFilter;
import com.fr.privilege.filter.AuthorityControlFilter;
import com.fr.privilege.providers.AbstractAuthenticationProvider;
import com.fr.privilege.providers.AuthenticationProvider;
import com.fr.privilege.providers.NoAuthenticationProvider;
import com.fr.privilege.ui.EmbeddedLogin;
import com.fr.privilege.ui.LoginUI;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.FCloneable;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PrivilegeManager
extends XMLFileManager
implements Serializable,
FCloneable {
    public static final String XML_TAG = "PrivilegeManager";
    public static final String DEFAULTADMINNAME = "admin";
    public static final String DEFAULTADMINPASSWORD = "123456";
    public static final long SYSADMINID = -999L;
    private boolean hasSetFSSystemManager = false;
    private static PrivilegeManager privilegeManager = null;
    public static final String ROOT_ROLE = "root";
    private String rootManagerName = "admin";
    private String rootManagerPassword = "123456";
    private String rootManagerRealname;
    private Date rootManagerBirthday;
    private boolean rootManagerMale;
    private String rootManagerMobile;
    private String rootManagerWorkphone;
    private String rootManagerEmail;
    private AuthenticationProvider authenticationProvider = new NoAuthenticationProvider();
    private String forwardUrl = "${servletURL}?op=fr_platform";
    private PrivilegeFilter privilegeFilter = null;
    private boolean onlyBridleDesign = false;
    private LoginUI ui = new EmbeddedLogin();

    public static synchronized PrivilegeManager getInstance() {
        if (privilegeManager == null) {
            privilegeManager = new PrivilegeManager();
            privilegeManager.readXMLFile();
            if (!PrivilegeManager.isAfterPrivilege705()) {
                PrivilegeManager.compatibleOldVersion();
            }
        }
        return privilegeManager;
    }

    private static boolean isAfterPrivilege705() {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(GeneralContext.getResourceStream("privilege.xml", false), "UTF-8");
            XMLableReader xMLableReader = XMLableReader.createXMLableReader(inputStreamReader);
            return xMLableReader != null && xMLableReader.getXMLVersion().isAfterPRIVILGE_FOR7_0_5_XML_VERSION();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void compatibleOldVersion() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
                AbstractAuthenticationProvider abstractAuthenticationProvider = (AbstractAuthenticationProvider)authenticationProvider;
                try {
                    Authority[] authorityArray = abstractAuthenticationProvider.listAuthorities();
                    HashSet<String> hashSet = new HashSet<String>();
                    for (int i2 = 0; i2 < authorityArray.length; ++i2) {
                        hashSet.add(authorityArray[i2].getName());
                    }
                    PrivilegeFilter privilegeFilter = privilegeManager.getPrivilegeFilter();
                    if (privilegeFilter instanceof AuthorityControlFilter) {
                        AuthorityControlFilter authorityControlFilter = (AuthorityControlFilter)privilegeFilter;
                        authorityControlFilter.joinAuthorityAllocationWithPrivilege(hashSet);
                        privilegeManager.setPrivilegeFilter(authorityControlFilter);
                    }
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage());
                }
            }
        });
        thread.start();
    }

    private static synchronized void envChanged() {
        privilegeManager = null;
    }

    private PrivilegeManager() {
    }

    public boolean hasSetFSSystemPW() {
        return this.hasSetFSSystemManager;
    }

    public void setHasFSSystemPW(boolean bl) {
        this.hasSetFSSystemManager = bl;
    }

    public String getRootManagerName() {
        return this.rootManagerName;
    }

    public void setRootManagerName(String string) {
        this.rootManagerName = string;
    }

    public String getRootManagerPassword() {
        return this.rootManagerPassword;
    }

    public void setRootManagerPassword(String string) {
        this.rootManagerPassword = string;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider != null ? this.authenticationProvider : new NoAuthenticationProvider();
    }

    public void setAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public String getForwardUrl() {
        return this.forwardUrl;
    }

    public LoginUI getUi() {
        return this.ui;
    }

    public void setUi(LoginUI loginUI) {
        this.ui = loginUI;
    }

    public PrivilegeFilter getPrivilegeFilter() {
        return this.privilegeFilter;
    }

    public int getPrivilegeFilterType() {
        if (this.privilegeFilter == null) {
            return -1;
        }
        return this.privilegeFilter.getID();
    }

    public boolean isOnlyBridleDesign() {
        return this.onlyBridleDesign;
    }

    public void setOnlyBridleDesign(boolean bl) {
        this.onlyBridleDesign = bl;
    }

    public void setPrivilegeFilter(PrivilegeFilter privilegeFilter) {
        this.privilegeFilter = privilegeFilter;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.hasSetFSSystemManager = xMLableReader.getAttrAsBoolean("fsSystemManagerPassSet", false);
            this.rootManagerRealname = xMLableReader.getAttrAsString("realname", "");
            this.rootManagerBirthday = new Date(xMLableReader.getAttrAsLong("birthday", 0L));
            this.rootManagerMale = xMLableReader.getAttrAsBoolean("male", false);
            this.rootManagerWorkphone = xMLableReader.getAttrAsString("workphone", "");
            this.rootManagerEmail = xMLableReader.getAttrAsString("email", "");
            this.onlyBridleDesign = xMLableReader.getAttrAsBoolean("bridleDesign", false);
        } else if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("rootManagerName".equals(string)) {
                this.rootManagerName = xMLableReader.getElementValue();
            } else if ("rootManagerPassword".equals(string)) {
                this.rootManagerPassword = CodeUtils.passwordDecode(xMLableReader.getElementValue());
            } else if (string.equals("AP")) {
                this.authenticationProvider = (AuthenticationProvider)GeneralXMLTools.readXMLable(xMLableReader);
            } else if ("LoginUI".equals(string)) {
                this.ui = (LoginUI)GeneralXMLTools.readXMLable(xMLableReader);
            } else if ("PVFILTER".equals(string)) {
                this.privilegeFilter = (PrivilegeFilter)GeneralXMLTools.readXMLable(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("fsSystemManagerPassSet", this.hasSetFSSystemManager);
        if (StringUtils.isNotEmpty(this.getRootManagerRealname())) {
            xMLPrintWriter.attr("realname", this.getRootManagerRealname());
        }
        if (this.rootManagerBirthday != null) {
            xMLPrintWriter.attr("birthday", this.getRootManagerBirthday().getTime());
        }
        if (this.onlyBridleDesign) {
            xMLPrintWriter.attr("bridleDesign", this.isOnlyBridleDesign());
        }
        xMLPrintWriter.attr("male", this.isRootManagerMale());
        if (StringUtils.isNotEmpty(this.getRootManagerMobile())) {
            xMLPrintWriter.attr("mobile", this.getRootManagerMobile());
        }
        if (StringUtils.isNotEmpty(this.getRootManagerWorkphone())) {
            xMLPrintWriter.attr("workphone", this.getRootManagerWorkphone());
        }
        if (StringUtils.isNotEmpty(this.getRootManagerEmail())) {
            xMLPrintWriter.attr("email", this.getRootManagerEmail());
        }
        if (StringUtils.isNotEmpty(this.rootManagerName)) {
            xMLPrintWriter.startTAG("rootManagerName").textNode(this.rootManagerName).end();
        }
        if (StringUtils.isNotEmpty(this.rootManagerPassword)) {
            xMLPrintWriter.startTAG("rootManagerPassword").textNode(CodeUtils.passwordEncode(this.rootManagerPassword)).end();
        }
        if (this.authenticationProvider != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.authenticationProvider, "AP");
        }
        if (StringUtils.isNotBlank(this.forwardUrl)) {
            xMLPrintWriter.startTAG("ForwardUrl").textNode(this.forwardUrl).end();
        }
        if (this.ui != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.ui, "LoginUI");
        }
        if (this.getPrivilegeFilter() != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.getPrivilegeFilter(), "PVFILTER");
        }
        xMLPrintWriter.end();
    }

    public String fileName() {
        return "privilege.xml";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getRootManagerRealname() {
        return this.rootManagerRealname;
    }

    public void setRootManagerRealname(String string) {
        this.rootManagerRealname = string;
    }

    public Date getRootManagerBirthday() {
        return this.rootManagerBirthday;
    }

    public void setRootManagerBirthday(Date date) {
        this.rootManagerBirthday = date;
    }

    public boolean isRootManagerMale() {
        return this.rootManagerMale;
    }

    public void setRootManagerMale(boolean bl) {
        this.rootManagerMale = bl;
    }

    public String getRootManagerMobile() {
        return this.rootManagerMobile;
    }

    public void setRootManagerMobile(String string) {
        this.rootManagerMobile = string;
    }

    public String getRootManagerWorkphone() {
        return this.rootManagerWorkphone;
    }

    public void setRootManagerWorkphone(String string) {
        this.rootManagerWorkphone = string;
    }

    public String getRootManagerEmail() {
        return this.rootManagerEmail;
    }

    public void setRootManagerEmail(String string) {
        this.rootManagerEmail = string;
    }

    public void setUserInfo(String string, Date date, boolean bl, String string2, String string3, String string4) {
        this.setRootManagerRealname(string);
        this.setRootManagerBirthday(date);
        this.setRootManagerMale(bl);
        this.setRootManagerMobile(string2);
        this.setRootManagerWorkphone(string3);
        this.setRootManagerEmail(string4);
    }

    public static boolean checkIsRoot(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        PrivilegeManager privilegeManager = PrivilegeManager.getInstance();
        String string = DataUtils.getHTTPRequestParameter(httpServletRequest, "fr_username");
        if (StringUtils.isEmpty(string)) {
            return true;
        }
        return ComparatorUtils.equals(string, privilegeManager.getRootManagerName());
    }

    public static void logout2SessionInfo(HttpSession httpSession, HttpServletResponse httpServletResponse) {
        if (httpSession == null) {
            return;
        }
        httpSession.removeAttribute("fr_authentication_key");
        httpSession.removeAttribute("fr_username");
        httpSession.removeAttribute("fr_authority");
        httpSession.removeAttribute("fr_userposition");
        httpSession.removeAttribute("fr_isroot");
        httpSession.removeAttribute("fr_current_privilege_loader");
        Cookie cookie = new Cookie("isAutoLogin", "false");
        Cookie cookie2 = new Cookie("isDefaultUser", ComparatorUtils.equals(PrivilegeManager.getInstance().getRootManagerName(), DEFAULTADMINNAME) && ComparatorUtils.equals(PrivilegeManager.getInstance().getRootManagerPassword(), DEFAULTADMINPASSWORD) ? "true" : "false");
        httpServletResponse.addCookie(cookie2);
        httpServletResponse.addCookie(cookie);
        Cookie cookie3 = new Cookie("FRPassword", "");
        cookie3.setMaxAge(-1);
        httpServletResponse.addCookie(cookie3);
        Cookie cookie4 = new Cookie("FRUsername", "");
        cookie4.setMaxAge(-1);
        httpServletResponse.addCookie(cookie4);
    }

    public static String[] getRoleFromCalculator(Calculator calculator) {
        if (calculator == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Authentication authentication = null;
        try {
            authentication = (Authentication)calculator.eval("Current_Au");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authentication == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return PrivilegeManager.getRoleFromAuthentication(authentication);
    }

    public static String[] getRoleFromAuthentication(Authentication authentication) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PrivilegeManager privilegeManager = PrivilegeManager.getInstance();
        AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
        try {
            if (authentication instanceof FSRoleAuthentication) {
                String[] stringArray = ((FSRoleAuthentication)authentication).getUserName().split("&");
                arrayList.addAll(Arrays.asList(stringArray));
            } else if (authenticationProvider.authenticate(authentication)) {
                Authority[] authorityArray = authentication.getAuthorities();
                for (int i2 = 0; i2 < authorityArray.length; ++i2) {
                    String string = authorityArray[i2].getName();
                    if (ComparatorUtils.equals(ROOT_ROLE, string)) continue;
                    arrayList.add(string);
                }
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                PrivilegeManager.envChanged();
            }
        });
    }
}

