/*
 * Decompiled with CFR 0.152.
 */
package com.fr.page;

import com.fr.base.DynamicNumberList;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Style;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.file.ExtraClassManager;
import com.fr.general.Background;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PagePainterProvider;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportPageProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.cellattr.BrokenCellInfo;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.cellattr.CellPageAttr;
import com.fr.report.cell.cellattr.PageExportCellElement;
import com.fr.report.core.PaintUtils;
import com.fr.script.Calculator;
import com.fr.stable.core.Converter;
import com.fr.stable.fun.PrintCellValueProvider;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class PagePainter
implements Converter,
PagePainterProvider {
    protected Graphics2D g2d;
    protected int resolution;
    private ReportPageProvider reportPage;
    private boolean isPrint;
    private boolean isShowAsImageInWeb;

    public PagePainter() {
    }

    public PagePainter(ReportPageProvider reportPageProvider, Graphics2D graphics2D, int n2, boolean bl) {
        this(reportPageProvider, graphics2D, n2, bl, false);
    }

    public PagePainter(ReportPageProvider reportPageProvider, Graphics2D graphics2D, int n2, boolean bl, boolean bl2) {
        this.reportPage = reportPageProvider.deriveResolution(n2);
        this.g2d = graphics2D;
        this.resolution = n2;
        this.isPrint = bl;
        this.isShowAsImageInWeb = bl2;
    }

    public void convert() {
        this.preparePaint();
        this.paintPages();
        this.g2d.dispose();
    }

    private void paintPages() {
        ClippedPageProvider[] clippedPageProviderArray = this.reportPage.getPages();
        for (int i2 = 0; i2 < clippedPageProviderArray.length; ++i2) {
            ClippedPageProvider clippedPageProvider = clippedPageProviderArray[i2];
            clippedPageProvider.paintPage(this, this.g2d, this.resolution);
        }
    }

    protected void preparePaint() {
        ReportSettingsProvider reportSettingsProvider = this.reportPage.getReportSettings();
        int n2 = this.reportPage.getPaperWidth().toPixI(this.resolution);
        int n3 = this.reportPage.getPaperHeight().toPixI(this.resolution);
        int n4 = this.reportPage.getMarginTop().toPixI(this.resolution);
        int n5 = this.reportPage.getMarginLeft().toPixI(this.resolution);
        int n6 = this.reportPage.getMarginBottom().toPixI(this.resolution);
        int n7 = this.reportPage.getMarginRight().toPixI(this.resolution);
        if (!this.isPrint) {
            ColorBackground.getInstance(Color.white).paint(this.g2d, new Rectangle2D.Double(0.0, 0.0, n2, n3));
        }
        int n8 = n2 - n5 - n7;
        this.prepareHF(n8, reportSettingsProvider);
        this.prepareContentArea(this.g2d, new Rectangle2D.Double(n5, n4 + reportSettingsProvider.getHeaderHeight().toPixI(this.resolution), n8, n3 - n4 - n6 - (reportSettingsProvider.getHeaderHeight().toPixI(this.resolution) + reportSettingsProvider.getFooterHeight().toPixI(this.resolution))), reportSettingsProvider, this.isPrint);
    }

    protected void prepareHF(int n2, ReportSettingsProvider reportSettingsProvider) {
        ReportHFProvider reportHFProvider;
        ReportHFProvider reportHFProvider2 = this.reportPage.getHeader();
        if (reportHFProvider2 != null) {
            reportHFProvider2.paint(this.g2d, new Rectangle2D.Double(this.reportPage.getMarginLeft().toPixI(this.resolution), this.reportPage.getMarginTop().toPixI(this.resolution), n2, reportSettingsProvider.getHeaderHeight().toPixI(this.resolution)), n2, this.reportPage.getCurrentPageNumber(), this.reportPage.getTotalPages(), this.reportPage.getFirstPage(), this.isPrint, this.resolution);
        }
        if ((reportHFProvider = this.reportPage.getFooter()) != null) {
            reportHFProvider.paint(this.g2d, new Rectangle2D.Double(this.reportPage.getMarginLeft().toPixI(this.resolution), (int)(this.reportPage.getPaperHeight().toPixF(this.resolution) - this.reportPage.getMarginBottom().toPixF(this.resolution) - reportSettingsProvider.getFooterHeight().toPixF(this.resolution)), n2, reportSettingsProvider.getFooterHeight().toPixI(this.resolution)), n2, this.reportPage.getCurrentPageNumber(), this.reportPage.getTotalPages(), this.reportPage.getFirstPage(), this.isPrint, this.resolution);
        }
    }

    private void prepareContentArea(Graphics2D graphics2D, Rectangle2D rectangle2D, ReportSettingsProvider reportSettingsProvider, boolean bl) {
        this.g2d = (Graphics2D)graphics2D.create();
        this.g2d.translate(rectangle2D.getX(), rectangle2D.getY());
        Background background = reportSettingsProvider.getBackground();
        if (background != null && reportSettingsProvider.isPrintBackground()) {
            background.paint(this.g2d, new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth(), rectangle2D.getHeight()));
        }
        UNIT[] uNITArray = ReportHelper.getReportPageContentSize(this.reportPage);
        long l2 = uNITArray[0].toFU();
        long l3 = uNITArray[1].toFU();
        double d2 = l2 <= 0L ? 1.0 : FU.getInstance(l2).toPixD(this.resolution);
        double d3 = l3 <= 0L ? 1.0 : FU.getInstance(l3).toPixD(this.resolution);
        int n2 = 0;
        int n3 = 0;
        if (reportSettingsProvider.isHorizontalCenterOnPage()) {
            n2 = (int)(rectangle2D.getWidth() - d2) / 2;
        }
        if (reportSettingsProvider.isVerticalCenterOnPage()) {
            n3 = (int)(rectangle2D.getHeight() - d3) / 2;
        }
        this.g2d.translate(n2, n3);
    }

    public void prepareCell(ClippedPageProvider clippedPageProvider, DynamicNumberList dynamicNumberList, DynamicNumberList dynamicNumberList2, int n2, int n3) {
        Cloneable cloneable;
        Cloneable cloneable2;
        Cloneable cloneable3;
        Rectangle rectangle;
        ArrayList<PageExportCellElement> arrayList = new ArrayList<PageExportCellElement>();
        ArrayList<CellGUIAttr> arrayList2 = new ArrayList<CellGUIAttr>();
        ArrayList<CellElement> arrayList3 = new ArrayList<CellElement>();
        ArrayList<CellGUIAttr> arrayList4 = new ArrayList<CellGUIAttr>();
        Iterator iterator = clippedPageProvider.cellIterator();
        long l2 = 0L;
        while (iterator.hasNext()) {
            PageExportCellElement pageExportCellElement = new PageExportCellElement((CellElement)iterator.next());
            CellGUIAttr cellGUIAttr = pageExportCellElement.getCellGUIAttr();
            if (cellGUIAttr == null) {
                cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
            }
            rectangle = new Rectangle(pageExportCellElement.getColumn(), pageExportCellElement.getRow(), pageExportCellElement.getColumnSpan(), pageExportCellElement.getRowSpan());
            cloneable3 = pageExportCellElement.getCellPageAttr();
            if (cloneable3 == null) {
                cloneable3 = CellPageAttr.DEFAULT_CELLPAGEATTR;
            }
            cloneable2 = new Rectangle(dynamicNumberList.getRangeValue(0, rectangle.x), dynamicNumberList2.getRangeValue(0, rectangle.y), dynamicNumberList.getRangeValue(rectangle.x, rectangle.x + rectangle.width), dynamicNumberList2.getRangeValue(rectangle.y, rectangle.y + rectangle.height));
            ((Rectangle)cloneable2).x += n2;
            ((Rectangle)cloneable2).y += n3;
            BrokenCellInfo brokenCellInfo = pageExportCellElement.getBrokenCellInfo();
            cloneable = brokenCellInfo instanceof BrokenCellInfo && brokenCellInfo.getClipInfo() != null ? brokenCellInfo.getClipInfo() : new Rectangle(0, 0, ((Rectangle)cloneable2).width, ((Rectangle)cloneable2).height);
            if (brokenCellInfo != null && brokenCellInfo.getPaintInfo() != null) {
                Rectangle rectangle2 = brokenCellInfo.getPaintInfo();
                ((Rectangle)cloneable2).x += rectangle2.x;
                ((Rectangle)cloneable2).y += rectangle2.y;
                ((Rectangle)cloneable2).width = rectangle2.width;
                ((Rectangle)cloneable2).height = rectangle2.height;
            }
            arrayList.add(pageExportCellElement);
            arrayList2.add(cellGUIAttr);
            arrayList3.add((CellElement)cloneable2);
            arrayList4.add((CellGUIAttr)cloneable);
            if (this.isPrint && cellGUIAttr.isPrintBackground() || !this.isPrint && cellGUIAttr.isPrintBackground()) {
                Style.paintBackground(this.g2d, pageExportCellElement.getStyle(), (Rectangle)cloneable2, (Rectangle)cloneable);
            }
            this.paintCellContent(cellGUIAttr, this.isPrint, pageExportCellElement, (Rectangle)cloneable2, (Rectangle)cloneable);
        }
        int n4 = arrayList.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            cloneable2 = (CellElement)arrayList.get(i2);
            cloneable = (CellGUIAttr)arrayList2.get(i2);
            rectangle = (Rectangle)arrayList3.get(i2);
            cloneable3 = (Rectangle)arrayList4.get(i2);
            Style.paintBorder(this.g2d, cloneable2.getStyle(), rectangle, (Rectangle)cloneable3);
        }
    }

    private long autoLineHeight(CellElement cellElement, Rectangle rectangle, long l2) {
        if (this.resolution == 96) {
            int n2;
            Style style = cellElement.getStyle();
            Font font = style.getFRFont().applyResolutionNP(this.resolution);
            int n3 = cellElement.getStyle().getLineSpacing() + GraphHelper.getFontMetrics(font).getHeight();
            if (n3 * (n2 = PaintUtils.getLineTextCount(Style.valueToText(cellElement.getShowValue(), style.getFormat()), style, font, rectangle.width, cellElement.getCellGUIAttr() == null ? false : cellElement.getCellGUIAttr().isShowAsHTML())) < rectangle.height) {
                return l2;
            }
            long l3 = rectangle.height % n3;
            if (l3 != 0L) {
                rectangle.height = (int)((long)rectangle.height - l3);
                rectangle.height += n3;
                if (rectangle.y == 0) {
                    l2 = (long)n3 - l3;
                } else {
                    rectangle.y = (int)((long)rectangle.y + l2);
                }
            }
        }
        return l2;
    }

    protected void paintCellContent(CellGUIAttr cellGUIAttr, boolean bl, PageExportCellElement pageExportCellElement, Rectangle rectangle, Rectangle rectangle2) {
        if (cellGUIAttr.isPrintContent() || this.isShowAsImageInWeb) {
            Object object;
            BrokenCellInfo brokenCellInfo = pageExportCellElement.getBrokenCellInfo();
            if (brokenCellInfo == null || (object = brokenCellInfo.getOriValue()) == null) {
                object = pageExportCellElement.getValue();
            }
            while (object instanceof Formula) {
                object = ((Formula)object).getResult();
            }
            if (!cellGUIAttr.isPrintZeroValue() && object != null && object.toString().matches("[\\-]?0[\\.]?[0]*")) {
                return;
            }
            object = Utils.resolveOtherValue(object, cellGUIAttr.isShowAsImage());
            PrintCellValueProvider printCellValueProvider = ExtraClassManager.getInstance().getPrintCellValueProvider();
            if (printCellValueProvider != null) {
                object = printCellValueProvider.getCellValue(pageExportCellElement, object, Calculator.createCalculator());
            }
            if (object instanceof String && cellGUIAttr.isShowAsHTML()) {
                object = PaintUtils.createHTMLContentBufferedImage((String)object, rectangle, 0, 0);
            }
            if (rectangle.width == rectangle2.width && rectangle.height != rectangle2.height && object instanceof String) {
                object = PaintUtils.clipBlockValue(object, pageExportCellElement.getStyle(), rectangle, rectangle2, this.resolution);
                rectangle.setBounds(rectangle.x + rectangle2.x, rectangle.y + rectangle2.y, rectangle2.width, rectangle2.height);
                rectangle2.setLocation(0, 0);
            }
            Style.paintContent(this.g2d, object, this.resolution, pageExportCellElement.getStyle(), rectangle, rectangle2);
        }
    }

    public void prepareFloat(ClippedPageProvider clippedPageProvider, DynamicNumberList dynamicNumberList, DynamicNumberList dynamicNumberList2, int n2, int n3) {
        Iterator iterator = clippedPageProvider.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            Rectangle rectangle = new Rectangle(floatElement.getLeftDistance_inClippedPage().toPixI(this.resolution), floatElement.getTopDistance_inClippedPage().toPixI(this.resolution), floatElement.getWidth().toPixI(this.resolution), floatElement.getHeight().toPixI(this.resolution));
            Rectangle rectangle2 = null;
            Rectangle rectangle3 = null;
            rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            rectangle2.x += n2;
            rectangle2.y += n3;
            rectangle3 = new Rectangle(0, 0, rectangle2.width, rectangle2.height);
            if (rectangle2 == null || rectangle3 == null) continue;
            PaintUtils.paintFloatElement(this.g2d, floatElement, rectangle2, rectangle3, this.resolution);
        }
    }
}

