/*
 * Decompiled with CFR 0.152.
 */
package com.fr.js;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.general.ComparatorUtils;
import com.fr.general.DefaultValues;
import com.fr.general.FArray;
import com.fr.general.Inter;
import com.fr.js.AbstractJavaScript;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.BaseSessionFilterParameterManager;
import com.fr.stable.CodeUtils;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.Date;
import java.util.Map;

public abstract class Hyperlink
extends AbstractJavaScript {
    public static final String BLANK_FRAME = "_blank";
    private static final int MAX_PARA_LENGTH = 20;
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private String targetFrame = "_blank";
    private int width = 0;
    private int height = 0;

    public String features4NewWindow() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.width > 0) {
            stringBuffer.append(WIDTH).append('=').append(this.width).append(',');
        }
        if (this.height > 0) {
            stringBuffer.append(HEIGHT).append('=').append(this.height).append(',');
        }
        return stringBuffer.toString();
    }

    public void putExtendParameters(Repository repository, JSONObject jSONObject, boolean bl) throws JSONException {
        Map map = repository.getReportParameterMap();
        String[] stringArray = BaseSessionFilterParameterManager.getFilterParameters();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!map.containsKey(stringArray[i2])) continue;
            map.remove(stringArray[i2]);
        }
        ParameterProvider[] parameterProviderArray = this.getParameters();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                Object v2 = entry.getValue();
                if (string.length() > 20) continue;
                String string2 = "";
                for (int i3 = 0; i3 < parameterProviderArray.length; ++i3) {
                    if (!string.equalsIgnoreCase(parameterProviderArray[i3].getName())) continue;
                    string2 = parameterProviderArray[i3].getValue().toString();
                }
                if (!StringUtils.isEmpty(string2)) continue;
                jSONObject.put(bl ? CodeUtils.cjkEncode(string) : string, bl ? CodeUtils.cjkEncode(String.valueOf(v2)) : v2);
            }
        }
    }

    public String getTargetFrame() {
        return this.targetFrame;
    }

    public void setTargetFrame(String string) {
        this.targetFrame = ComparatorUtils.equals(string, Inter.getLocText("Hyperlink-Self_Window")) || ComparatorUtils.equals(string, "_self") ? "_self" : (ComparatorUtils.equals(string, Inter.getLocText("Dialog")) || ComparatorUtils.equals(string, "_dialog") ? "_dialog" : (ComparatorUtils.equals(string, Inter.getLocText("Hyperlink-New_Window")) || ComparatorUtils.equals(string, BLANK_FRAME) ? BLANK_FRAME : string));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if (ComparatorUtils.equals(xMLableReader.getTagName(), "TargetFrame")) {
                String string = null;
                string = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank(string)) {
                    this.setTargetFrame(string);
                }
            } else if (ComparatorUtils.equals(xMLableReader.getTagName(), "Features")) {
                String string = null;
                this.setWidth(xMLableReader.getAttrAsInt(WIDTH, 0));
                this.setHeight(xMLableReader.getAttrAsInt(HEIGHT, 0));
                string = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank(string)) {
                    String string2 = string;
                    String[] stringArray = string2.split(",");
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        String string3 = stringArray[i2];
                        String[] stringArray2 = string3.split("=");
                        if (stringArray2.length != 2) continue;
                        String string4 = stringArray2[0];
                        String string5 = stringArray2[1];
                        if (WIDTH.equalsIgnoreCase(string4)) {
                            this.setWidth(Utils.string2Number(string5).intValue());
                            continue;
                        }
                        if (!HEIGHT.equalsIgnoreCase(string4)) continue;
                        this.setHeight(Utils.string2Number(string5).intValue());
                    }
                }
            }
        }
    }

    protected void para2JSON(JSONObject jSONObject, boolean bl) throws Exception {
        if (this.parameters != null) {
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                Object object;
                ParameterProvider parameterProvider = this.parameters[i2];
                Object object2 = parameterProvider.getValue();
                String string = "";
                if (object2 != null) {
                    if (object2 == null) continue;
                    if (object2 instanceof Formula) {
                        object2 = ((Formula)object2).getResult();
                    }
                    if (object2 instanceof Date) {
                        object = FRContext.getDefaultValues();
                        string = ((DefaultValues)object).getDateTimeFormat().format(object2);
                    } else if (object2 instanceof Double) {
                        string = Utils.doubleToString((Double)object2);
                    } else {
                        string = object2.toString();
                        object = "%25";
                        string = string.replaceAll("%", (String)object);
                    }
                }
                object = parameterProvider.getName();
                if (bl) {
                    jSONObject.put(CodeUtils.cjkEncode(((String)object).toUpperCase()), CodeUtils.cjkEncode(string));
                    continue;
                }
                jSONObject.put(parameterProvider.getName(), object2 instanceof FArray ? object2 : string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.getTargetFrame())) {
            xMLPrintWriter.startTAG("TargetFrame").textNode(this.getTargetFrame()).end();
        }
        xMLPrintWriter.startTAG("Features");
        if (this.width > 0) {
            xMLPrintWriter.attr(WIDTH, this.width);
        }
        if (this.height > 0) {
            xMLPrintWriter.attr(HEIGHT, this.height);
        }
        xMLPrintWriter.end();
    }

    protected boolean isPost() {
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof Hyperlink && super.equals(object) && this.height == ((Hyperlink)object).height && this.width == ((Hyperlink)object).width && ComparatorUtils.equals(this.targetFrame, ((Hyperlink)object).targetFrame);
    }
}

