/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.importer;

import com.fr.base.BaseUtils;
import com.fr.base.ConfigManager;
import com.fr.base.CoreDecimalFormat;
import com.fr.base.ExcelUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Margin;
import com.fr.base.ResultFormula;
import com.fr.base.Style;
import com.fr.base.TextFormat;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.cache.Attachment;
import com.fr.data.TableDataSource;
import com.fr.form.ui.Widget;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.io.importer.AbstractExcelPicture;
import com.fr.io.importer.TemplateBookAdapter;
import com.fr.io.importer.WriteExcelImportException;
import com.fr.main.FineBook;
import com.fr.main.TemplateWorkBook;
import com.fr.main.impl.WorkBook;
import com.fr.main.workbook.WriteWorkBook;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.cell.WidgetAttrElem;
import com.fr.report.cell.WriteCellElement;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.core.A.A;
import com.fr.report.core.ReportUtils;
import com.fr.report.core.namespace.SimpleCellValueNameSpace;
import com.fr.report.report.ECReport;
import com.fr.report.report.Report;
import com.fr.report.report.WriteECReport;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.Constants;
import com.fr.stable.StringUtils;
import com.fr.stable.unit.INCH;
import com.fr.stable.unit.OLDPIX;
import com.fr.stable.unit.PT;
import com.fr.stable.xml.FRFile;
import com.fr.third.org.apache.poi.ddf.EscherClientAnchorRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.hssf.record.EscherAggregate;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFont;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPictureData;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.HSSFColor;
import com.fr.third.org.apache.poi.hssf.util.Region;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.fr.web.core.A.YB;
import com.fr.write.WriteException;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelReportImporter {
    private static final int EXCEL_IMPORT_UC_MAPPING_ERR_SIZE = 0;
    private static final int VERTICALROTATION = -165;
    public static int DEFAULT_EXCEL_CELL_WIDTH = 8;
    public static int KILO = 1023;
    public static int FULL_COLOR = 256;

    public WorkBook generateWorkBookByStream(InputStream inputStream) throws Exception {
        return this.generateWorkBookByStream(inputStream, new HashMap());
    }

    public WorkBook generateWorkBookByStream(InputStream inputStream, Map map) throws Exception {
        return (WorkBook)this.generate(inputStream, new TemplateBookAdapter(), map);
    }

    private FineBook generate(InputStream inputStream, TemplateBookAdapter templateBookAdapter, Map map) throws Exception {
        POIFSFileSystem pOIFSFileSystem = null;
        try {
            pOIFSFileSystem = new POIFSFileSystem(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(Inter.getLocText("NS_exception_readExcelError"));
        }
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(pOIFSFileSystem);
        FineBook fineBook = templateBookAdapter.getBookInstance();
        List list = ExcelReportImporter.getAllPictures(hSSFWorkbook);
        int n2 = hSSFWorkbook.getNumberOfSheets();
        Object v2 = map.get(YB.O);
        if (v2 != null) {
            ((YB)v2).A(n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (v2 != null) {
                ((YB)v2).D(i2);
            }
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(i2);
            ECReport eCReport = templateBookAdapter.getChildReportInstance(hSSFWorkbook.getSheetName(i2));
            ReportSettingsProvider reportSettingsProvider = eCReport.getReportSettings();
            PaperSettingProvider paperSettingProvider = reportSettingsProvider.getPaperSetting();
            HSSFPrintSetup hSSFPrintSetup = hSSFSheet.getPrintSetup();
            reportSettingsProvider.setHeaderHeight(new INCH((float)hSSFPrintSetup.getHeaderMargin()));
            reportSettingsProvider.setFooterHeight(new INCH((float)hSSFPrintSetup.getFooterMargin()));
            paperSettingProvider.setOrientation(hSSFPrintSetup.getLandscape() ? 1 : 0);
            reportSettingsProvider.setPageOrder(hSSFPrintSetup.getLeftToRight() ? 1 : 0);
            Margin margin = paperSettingProvider.getMargin();
            margin.setTop(new INCH((float)hSSFSheet.getMargin((short)2)));
            margin.setLeft(new INCH((float)hSSFSheet.getMargin((short)0)));
            margin.setBottom(new INCH((float)hSSFSheet.getMargin((short)3)));
            margin.setRight(new INCH((float)hSSFSheet.getMargin((short)1)));
            this.traverseByRows(eCReport, hSSFWorkbook, hSSFSheet, templateBookAdapter, list, v2);
            this.dealWithImage(hSSFSheet, eCReport, templateBookAdapter, list);
        }
        inputStream.close();
        return fineBook;
    }

    private void traverseByRows(ECReport eCReport, HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, TemplateBookAdapter templateBookAdapter, List list, Object object) {
        int n2 = hSSFSheet.getLastRowNum();
        int n3 = hSSFSheet.getFirstRowNum();
        if (object != null) {
            ((YB)object).E(n2 - n3);
        }
        for (int i2 = n3; i2 <= n2; ++i2) {
            HSSFRow hSSFRow;
            if (object != null) {
                ((YB)object).B(i2 - n3);
            }
            if ((hSSFRow = hSSFSheet.getRow(i2)) == null) continue;
            eCReport.setRowHeight(i2, new PT((float)hSSFRow.getHeight() / ConfigManager.getInstance().getExcelAdjustHeight()));
            short s2 = hSSFRow.getLastCellNum();
            for (int i3 = Math.max(0, hSSFRow.getFirstCellNum()); i3 <= s2; ++i3) {
                HSSFCell hSSFCell;
                if (hSSFSheet.getColumnWidth((short)i3) != DEFAULT_EXCEL_CELL_WIDTH) {
                    eCReport.setColumnWidth(i3, new OLDPIX((float)((short)((double)hSSFSheet.getColumnWidth((short)i3) / ConfigManager.getInstance().getExcelAdjustWidth()))));
                }
                if ((hSSFCell = hSSFRow.getCell((short)i3)) == null || this.isHiddenMergedCell(hSSFSheet, i3, i2)) continue;
                int[] nArray = this.getMergetColumnRow(hSSFSheet, i3, i2);
                int n4 = 1;
                int n5 = 1;
                if (nArray != null && nArray.length > 0) {
                    n4 = nArray[0];
                    n5 = nArray[1];
                }
                CellElement cellElement = templateBookAdapter.addNewCellElement(eCReport, i3, i2, n4, n5, ExcelUtils.getHSSFCellValue(hSSFCell));
                int[] nArray2 = this.getMergetColumnRowTo(hSSFSheet, i3, i2);
                HSSFRow hSSFRow2 = hSSFSheet.getRow(nArray2[1]);
                HSSFCell hSSFCell2 = hSSFRow2.getCell((short)nArray2[0]);
                cellElement.setStyle(this.createStyle(hSSFWorkbook, hSSFCell, hSSFCell2));
            }
        }
    }

    private void dealWithImage(HSSFSheet hSSFSheet, ECReport eCReport, TemplateBookAdapter templateBookAdapter, List list) {
        try {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ColumnRow columnRow;
                ExcelPicture excelPicture = (ExcelPicture)list.get(i2);
                if (!this.shouldSetImageToCellValue(hSSFSheet, eCReport, excelPicture, columnRow = excelPicture.getLeftTopColumnRow())) continue;
                BufferedImage bufferedImage = BaseUtils.readImage(new ByteArrayInputStream(excelPicture.getData()));
                templateBookAdapter.addNewCellElement(eCReport, columnRow.column, columnRow.row, 1, 1, bufferedImage);
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().debug(iOException.getMessage());
        }
    }

    private boolean shouldSetImageToCellValue(HSSFSheet hSSFSheet, ECReport eCReport, ExcelPicture excelPicture, ColumnRow columnRow) {
        return ComparatorUtils.equals(hSSFSheet, excelPicture.getSheet()) && columnRow != null && columnRow.column != -1 && columnRow.row != -1;
    }

    private BufferedImage getImageValue(HSSFSheet hSSFSheet, int n2, int n3, List list) {
        BufferedImage bufferedImage = null;
        try {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ExcelPicture excelPicture = (ExcelPicture)list.get(i2);
                if (!ComparatorUtils.equals(hSSFSheet, excelPicture.getSheet()) || excelPicture.getColumnRow().column != n2 || excelPicture.getColumnRow().row != n3) continue;
                bufferedImage = BaseUtils.readImage(new ByteArrayInputStream(excelPicture.getData()));
                list.remove(excelPicture);
                break;
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().debug(iOException.getMessage());
        }
        return bufferedImage;
    }

    private boolean isHiddenMergedCell(HSSFSheet hSSFSheet, int n2, int n3) {
        for (int i2 = 0; i2 < hSSFSheet.getNumMergedRegions(); ++i2) {
            Region region = hSSFSheet.getMergedRegionAt(i2);
            if (!this.columnRowInRegion(region, n2, n3)) continue;
            return region.getColumnFrom() != n2 || region.getRowFrom() != n3;
        }
        return false;
    }

    private boolean columnRowInRegion(Region region, int n2, int n3) {
        return region.getColumnFrom() <= n2 && region.getColumnTo() >= n2 && region.getRowFrom() <= n3 && region.getRowTo() >= n3;
    }

    private int[] getMergetColumnRow(HSSFSheet hSSFSheet, int n2, int n3) {
        for (int i2 = 0; i2 < hSSFSheet.getNumMergedRegions(); ++i2) {
            Region region = hSSFSheet.getMergedRegionAt(i2);
            if (!this.columnRowInRegion(region, n2, n3)) continue;
            return new int[]{region.getColumnTo() - region.getColumnFrom() + 1, region.getRowTo() - region.getRowFrom() + 1};
        }
        return new int[0];
    }

    private int[] getMergetColumnRowTo(HSSFSheet hSSFSheet, int n2, int n3) {
        for (int i2 = 0; i2 < hSSFSheet.getNumMergedRegions(); ++i2) {
            Region region = hSSFSheet.getMergedRegionAt(i2);
            if (!this.columnRowInRegion(region, n2, n3)) continue;
            return new int[]{region.getColumnTo(), region.getRowTo()};
        }
        return new int[]{n2, n3};
    }

    private Style createStyle(HSSFWorkbook hSSFWorkbook, HSSFCell hSSFCell, HSSFCell hSSFCell2) {
        if (hSSFCell == null) {
            return Style.DEFAULT_STYLE;
        }
        Style style = Style.DEFAULT_STYLE;
        HSSFCellStyle hSSFCellStyle = hSSFCell.getCellStyle();
        HSSFCellStyle hSSFCellStyle2 = hSSFCell2 == null ? hSSFCellStyle : hSSFCell2.getCellStyle();
        short s2 = hSSFCellStyle.getDataFormat();
        String string = hSSFWorkbook.createDataFormat().getFormat(s2);
        style = ExcelReportImporter.format(string, style);
        FRFont fRFont = this.createFontStyle(hSSFWorkbook, hSSFCellStyle);
        style = style.deriveFRFont(fRFont);
        Color color = this.createColor(hSSFWorkbook, hSSFCellStyle.getFillForegroundColor());
        if (color != null) {
            style = style.deriveBackground(ColorBackground.getInstance(color));
        }
        short s3 = hSSFCellStyle.getAlignment();
        short s4 = hSSFCellStyle.getVerticalAlignment();
        style = ExcelReportImporter.getStyle(s3, s4, style);
        style = hSSFCellStyle.getWrapText() ? style.deriveTextStyle(0) : style.deriveTextStyle(1);
        short s5 = hSSFCellStyle.getRotation();
        if (s5 == -165) {
            style = style.deriveVerticalText(1);
            style = style.deriveRotation(0);
            style = style.deriveTextDirection(0);
        } else {
            style = style.deriveRotation(s5);
        }
        style = this.createBorderStyle(style, hSSFWorkbook, hSSFCellStyle, hSSFCellStyle2);
        return style;
    }

    private FRFont createFontStyle(HSSFWorkbook hSSFWorkbook, HSSFCellStyle hSSFCellStyle) {
        Object object;
        HSSFFont hSSFFont = hSSFWorkbook.getFontAt(hSSFCellStyle.getFontIndex());
        int n2 = 0;
        if (hSSFFont.getBoldweight() == 700) {
            ++n2;
        }
        if (hSSFFont.getItalic()) {
            n2 += 2;
        }
        short s2 = hSSFFont.getFontHeightInPoints();
        FRFont fRFont = FRFont.getInstance(hSSFFont.getFontName(), n2, s2);
        if (ComparatorUtils.equals(FRContext.getLocale(), Locale.CHINA) && !fRFont.canDisplay(((String)(object = Inter.getLocText("Song_TypeFace"))).charAt(0))) {
            fRFont = FRFont.getInstance((String)object, n2, s2);
        }
        if ((object = this.createColor(hSSFWorkbook, hSSFFont.getColor())) != null) {
            fRFont = fRFont.applyForeground((Color)object);
        }
        if (hSSFFont.getStrikeout()) {
            fRFont = fRFont.applyStrikethrough(true);
        }
        if (hSSFFont.getUnderline() == 0) {
            fRFont = fRFont.applyUnderline(0);
        } else if (hSSFFont.getUnderline() == 1 || hSSFFont.getUnderline() == 33) {
            fRFont = fRFont.applyUnderline(1);
        } else if (hSSFFont.getUnderline() == 2 || hSSFFont.getUnderline() == 34) {
            fRFont = fRFont.applyUnderline(6);
        }
        return fRFont;
    }

    private Style createBorderStyle(Style style, HSSFWorkbook hSSFWorkbook, HSSFCellStyle hSSFCellStyle, HSSFCellStyle hSSFCellStyle2) {
        Color color = this.createColor(hSSFWorkbook, hSSFCellStyle.getTopBorderColor());
        Color color2 = this.createColor(hSSFWorkbook, hSSFCellStyle.getLeftBorderColor());
        Color color3 = this.createColor(hSSFWorkbook, hSSFCellStyle2.getBottomBorderColor());
        Color color4 = this.createColor(hSSFWorkbook, hSSFCellStyle2.getRightBorderColor());
        style = style.deriveBorder(ExcelReportImporter.getBorderStyle(hSSFCellStyle.getBorderTop()), color == null ? style.getBorderTopColor() : color, ExcelReportImporter.getBorderStyle(hSSFCellStyle2.getBorderBottom()), color3 == null ? style.getBorderBottomColor() : color3, ExcelReportImporter.getBorderStyle(hSSFCellStyle.getBorderLeft()), color2 == null ? style.getBorderLeftColor() : color2, ExcelReportImporter.getBorderStyle(hSSFCellStyle2.getBorderRight()), color4 == null ? style.getBorderRightColor() : color4);
        return style;
    }

    public static Style getStyle(short s2, short s3, Style style) {
        style = s2 == 2 ? style.deriveHorizontalAlignment(0) : (s2 == 3 ? style.deriveHorizontalAlignment(4) : style.deriveHorizontalAlignment(2));
        style = s3 == 0 ? style.deriveVerticalAlignment(1) : (s3 == 2 ? style.deriveVerticalAlignment(3) : style.deriveVerticalAlignment(0));
        return style;
    }

    public static Style format(String string, Style style) {
        try {
            if (string != null) {
                Format format;
                if (ComparatorUtils.equals(string, "@")) {
                    format = TextFormat.getInstance();
                } else if (ComparatorUtils.equals(string.toUpperCase(), "GENERAL")) {
                    format = null;
                } else {
                    int n2;
                    if ((string = string.trim()).endsWith("_")) {
                        string = string.substring(0, string.length() - 1);
                    } else {
                        n2 = string.indexOf("_);");
                        if (n2 != -1) {
                            string = string.substring(0, n2);
                        }
                        if (string.startsWith("_(*")) {
                            string = string.substring(3);
                        }
                    }
                    if (string.indexOf("#,##0_") != -1) {
                        string = "#,##0";
                    }
                    if (string.indexOf("#,##0.00") != -1) {
                        string = "#,##0.00";
                    }
                    n2 = -1;
                    n2 = string.indexOf("+");
                    if (n2 != -1) {
                        string = string.substring(0, n2) + string.substring(n2 + 1);
                    }
                    DecimalFormat decimalFormat = new DecimalFormat();
                    decimalFormat.applyPattern(string);
                    format = new CoreDecimalFormat(decimalFormat, string);
                }
                return style.deriveFormat(format);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Excel format pattern not supported by java");
        }
        return style;
    }

    private Color createColor(HSSFWorkbook hSSFWorkbook, short s2) {
        HSSFColor hSSFColor = hSSFWorkbook.getCustomPalette().getColor(s2);
        if (hSSFColor == null) {
            return null;
        }
        if (hSSFColor instanceof HSSFColor.AUTOMATIC) {
            return null;
        }
        short[] sArray = hSSFColor.getTriplet();
        return new Color(sArray[0], sArray[1], sArray[2]);
    }

    public static int getBorderStyle(short s2) {
        switch (s2) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
        }
        return 0;
    }

    private static void setProcessPercent(YB yB2, int n2, int n3, boolean bl) {
        if (yB2 == null) {
            return;
        }
        switch (n2) {
            case 0: {
                yB2.F(n3);
                break;
            }
            case 1: {
                if (bl) {
                    yB2.G(n3);
                    break;
                }
                yB2.C(n3);
                break;
            }
            case 2: {
                if (bl) {
                    yB2.A(n3);
                    break;
                }
                yB2.D(n3);
                break;
            }
            case 3: {
                if (bl) {
                    yB2.E(n3);
                    break;
                }
                yB2.B(n3);
            }
        }
    }

    public static void importExcel2Book(WriteWorkBook writeWorkBook, TableDataSource tableDataSource, TemplateWorkBook templateWorkBook, Map map) throws WriteExcelImportException, Exception {
        ExcelReportImporter.importExcel2Book(writeWorkBook, tableDataSource, templateWorkBook, map, true);
    }

    public static void importExcel2Book(WriteWorkBook writeWorkBook, TableDataSource tableDataSource, TemplateWorkBook templateWorkBook, Map map, boolean bl) throws Exception {
        long l2 = System.currentTimeMillis();
        YB yB2 = (YB)map.get(YB.O);
        if (templateWorkBook != null && writeWorkBook != null) {
            int n2 = writeWorkBook.getReportCount();
            int n3 = Math.min(templateWorkBook.getReportCount(), n2);
            List[] listArray = new List[n3];
            if (yB2 != null) {
                yB2.A(n3);
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                if (yB2 != null) {
                    yB2.D(i2);
                }
                ECReport eCReport = (ECReport)templateWorkBook.getReport(i2);
                WriteECReport writeECReport = writeWorkBook.getWriteReport(i2);
                if (eCReport == null || writeECReport == null) continue;
                ExcelReportImporter.importExcel2BookBySheet(eCReport, writeECReport, listArray, i2, bl);
            }
            ExcelReportImporter.recalculateAfterImport(writeWorkBook, n2, map, listArray);
            ExcelReportImporter.modifySizeAfterImport(writeWorkBook);
        }
        FRContext.getLogger().info(Inter.getLocText(new String[]{"Utils-Import_Excel_Data", "INFO-Time_Taken", "Milliseconds"}, new String[]{"", System.currentTimeMillis() - l2 + ""}));
    }

    private static void importExcel2BookBySheet(ECReport eCReport, WriteECReport writeECReport, List[] listArray, int n2, boolean bl) throws Exception {
        ArrayList arrayList = new ArrayList();
        if (ExcelReportImporter.isByLocation(eCReport, writeECReport)) {
            ExcelReportImporter.doImportByLocation(writeECReport, eCReport, bl, arrayList);
            listArray[n2] = arrayList;
            return;
        }
        List list = writeECReport.findUnCertainWriteExpandRect();
        ExcelReportImporter.determineUnCertainList(writeECReport, list);
        int n3 = -1;
        int n4 = -1;
        ArrayList<CellElement> arrayList2 = new ArrayList<CellElement>();
        if (list != null && !list.isEmpty()) {
            arrayList2 = new ArrayList();
            int n5 = list.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                CellElement cellElement = (CellElement)list.get(i2);
                if (bl) {
                    if (((WidgetAttrElem)((Object)cellElement)).getWidget() != null) {
                        arrayList2.add(cellElement);
                    }
                } else {
                    arrayList2.add(cellElement);
                }
                int n6 = cellElement.getRow() + cellElement.getRowSpan() - 1;
                int n7 = cellElement.getColumn() + cellElement.getColumnSpan() - 1;
                n3 = Math.max(n6, n3);
                n4 = Math.max(n7, n4);
            }
        }
        ExcelReportImporter.doImportByUnCertain(writeECReport, eCReport, bl, n3, n4, list, arrayList2, arrayList);
        listArray[n2] = arrayList;
    }

    private static boolean isByLocation(ECReport eCReport, WriteECReport writeECReport) {
        return eCReport.getRowCount() == writeECReport.getRowCount() && eCReport.getColumnCount() == writeECReport.getColumnCount();
    }

    private static void determineUnCertainList(WriteECReport writeECReport, List list) {
        TemplateCellElement templateCellElement;
        int n2;
        int n3;
        boolean bl = true;
        boolean bl2 = true;
        ArrayList<TemplateCellElement> arrayList = new ArrayList<TemplateCellElement>();
        if (list != null) {
            n3 = list.size();
            for (n2 = 0; n2 < n3; ++n2) {
                templateCellElement = (TemplateCellElement)list.get(n2);
                arrayList.add(templateCellElement);
                if (templateCellElement.getCellExpandAttr().getDirection() == 0) {
                    bl2 = false;
                    continue;
                }
                if (templateCellElement.getCellExpandAttr().getDirection() != 1) continue;
                bl = false;
            }
        }
        if (bl || bl2) {
            return;
        }
        list.clear();
        n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            templateCellElement = (TemplateCellElement)arrayList.get(n2);
            CellExpandAttr cellExpandAttr = templateCellElement.getCellExpandAttr();
            int n4 = writeECReport.getBoxExpandSize(templateCellElement.getColumn(), templateCellElement.getRow(), cellExpandAttr.getDirection() == 0);
            if (n4 <= 1) continue;
            for (int i2 = n2 + 1; i2 < arrayList.size(); ++i2) {
                TemplateCellElement templateCellElement2 = (TemplateCellElement)arrayList.get(i2);
                CellExpandAttr cellExpandAttr2 = templateCellElement2.getCellExpandAttr();
                if (cellExpandAttr.getDirection() == 1 && cellExpandAttr2.getDirection() == 0 && ComparatorUtils.equals(cellExpandAttr2.getUpParentColumnRow(), ColumnRow.valueOf(templateCellElement.getColumn(), templateCellElement.getRow()))) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        list.add(writeECReport.getCellElement(templateCellElement2.getColumn() + i3, templateCellElement2.getRow()));
                    }
                    return;
                }
                if (cellExpandAttr.getDirection() != 0 || cellExpandAttr2.getDirection() != 1 || !ComparatorUtils.equals(cellExpandAttr2.getLeftParentColumnRow(), ColumnRow.valueOf(templateCellElement.getColumn(), templateCellElement.getRow()))) continue;
                for (int i4 = 0; i4 < n4; ++i4) {
                    list.add(writeECReport.getCellElement(templateCellElement2.getColumn() + i4, templateCellElement2.getRow()));
                }
                return;
            }
        }
    }

    private static void doImportByUnCertain(WriteECReport writeECReport, ECReport eCReport, boolean bl, int n2, int n3, List list, List list2, List list3) throws Exception {
        boolean bl2 = false;
        if (list != null && !list.isEmpty()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                CellElement cellElement = (CellElement)list.get(i2);
                boolean bl3 = true;
                if (cellElement.getCellExpandAttr().getDirection() == 1) {
                    bl3 = false;
                }
                if (bl2 = bl3 ? ExcelReportImporter.dealWithUCImport(writeECReport, eCReport, cellElement, cellElement.getRow(), bl, list2, list3, n2, eCReport.getRowCount(), bl3) : ExcelReportImporter.dealWithUCImport(writeECReport, eCReport, cellElement, cellElement.getColumn(), bl, list2, list3, n3, eCReport.getColumnCount(), bl3)) break;
            }
        }
        if (!bl2) {
            ExcelReportImporter.doImportByLocation(writeECReport, eCReport, bl, list3);
        }
    }

    private static void doImportByLocation(WriteECReport writeECReport, ECReport eCReport, boolean bl, List list) {
        Iterator iterator = writeECReport.cellIterator();
        while (iterator.hasNext()) {
            Object object;
            WriteCellElement writeCellElement = (WriteCellElement)iterator.next();
            if (bl) {
                Object object2;
                object = writeCellElement.getWidget();
                if (object == null || (object2 = eCReport.getCellValue(writeCellElement.getColumn(), writeCellElement.getRow())) == null) continue;
                ExcelReportImporter.setValue4ExcelImport(writeCellElement, object2, list);
                continue;
            }
            object = eCReport.getCellValue(writeCellElement.getColumn(), writeCellElement.getRow());
            if (object == null) continue;
            ExcelReportImporter.setValue4ExcelImport(writeCellElement, object, list);
        }
    }

    private static boolean dealWithUCImport(WriteECReport writeECReport, ECReport eCReport, CellElement cellElement, int n2, boolean bl, List list, List list2, int n3, int n4, boolean bl2) throws Exception {
        ArrayList arrayList;
        int[] nArray = bl2 ? writeECReport.getRowMappingArray() : writeECReport.getColumnMappingArray();
        ArrayList arrayList2 = new ArrayList();
        int n5 = ExcelReportImporter.getExLastRC(writeECReport, nArray, n3, bl2, arrayList2);
        int n6 = Integer.MAX_VALUE;
        n6 = ExcelReportImporter.matchReportToVerify(eCReport, n5, n4, n6, arrayList2, bl2);
        int n7 = -1;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != n2) continue;
            n7 = i2;
            break;
        }
        if (n7 >= 0) {
            arrayList = new ArrayList();
            int n8 = writeECReport.getBoxExpandSize(cellElement.getColumn(), cellElement.getRow(), bl2);
            int n9 = ExcelReportImporter.doAppendData(writeECReport, eCReport, n7, n3, n2, n8, cellElement, n4, n6, bl2, arrayList, list);
            if (n9 <= n8) {
                return false;
            }
        } else {
            return false;
        }
        ExcelReportImporter.setDataAfterAppend(writeECReport, eCReport, bl2, bl, n7, list2, arrayList, list);
        return true;
    }

    private static int getExLastRC(WriteECReport writeECReport, int[] nArray, int n2, boolean bl, List list) {
        int n3 = -1;
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            Iterator iterator;
            if (nArray[i2] == n2) {
                n3 = i2;
                break;
            }
            if (nArray[i2] <= n2) continue;
            Iterator iterator2 = iterator = bl ? writeECReport.getRow(i2) : writeECReport.getColumn(i2);
            while (iterator.hasNext()) {
                Object object;
                WriteCellElement writeCellElement = (WriteCellElement)iterator.next();
                if (writeCellElement == null || writeCellElement.getPresent() != null || writeCellElement.getWidget() != null || (!((object = writeCellElement.getValue()) instanceof String) || !StringUtils.isNotBlank((String)object)) && !(object instanceof Number)) continue;
                list.add(writeCellElement);
            }
        }
        return n3;
    }

    private static int doAppendData(WriteECReport writeECReport, ECReport eCReport, int n2, int n3, int n4, int n5, CellElement cellElement, int n6, int n7, boolean bl, List list, List list2) throws Exception {
        Point[] pointArray = new Point[list2.size()];
        int n8 = ExcelReportImporter.matchReportForLocation(writeECReport, eCReport, pointArray, list2, cellElement, bl);
        if (n8 < 0) {
            ExcelReportImporter.importDataWithoutMatchTitle(pointArray, cellElement, list2, bl);
            n8 = n2 - 1;
        }
        int n9 = Math.min(n7, n6 - 1);
        int n10 = n3 - n4 + 1;
        int n11 = pointArray.length;
        int n12 = n8;
        int n13 = 0;
        int n14 = ExcelReportImporter.computeStepCount(n8, n9 - 1, n10) - n5;
        ExcelReportImporter.insertData(writeECReport, cellElement, bl, n2 + n5 * n10, n10, n14);
        HashMap<CellElement, Integer> hashMap = new HashMap<CellElement, Integer>();
        while (n8 < n9) {
            ArrayList<CellElement> arrayList = new ArrayList<CellElement>(n11);
            for (int i2 = 0; i2 < n11; ++i2) {
                if (pointArray[i2] == null) continue;
                CellElement cellElement2 = bl ? eCReport.getCellElement(pointArray[i2].y, n8 + 1) : eCReport.getCellElement(n8 + 1, pointArray[i2].x);
                arrayList.add(cellElement2);
                if (!ExcelReportImporter.isMergeCell(cellElement2) || hashMap.containsKey(cellElement2)) continue;
                hashMap.put(cellElement2, i2);
            }
            if (arrayList.isEmpty()) break;
            ++n13;
            list.add(arrayList);
            n2 += n10;
            n8 += n10;
        }
        try {
            ExcelReportImporter.dealMergeCells(writeECReport, hashMap, cellElement, n12, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n13;
    }

    private static void importDataWithoutMatchTitle(Point[] pointArray, CellElement cellElement, List list, boolean bl) {
        for (int i2 = 0; i2 < pointArray.length; ++i2) {
            CellElement cellElement2 = (CellElement)list.get(i2);
            pointArray[i2] = bl ? new Point(cellElement2.getRow() - cellElement.getRow(), cellElement2.getColumn()) : new Point(cellElement2.getRow(), cellElement2.getColumn() - cellElement.getColumn());
        }
    }

    private static void insertData(WriteECReport writeECReport, CellElement cellElement, boolean bl, int n2, int n3, int n4) throws WriteException {
        if (bl) {
            writeECReport.simpleAppendData(ColumnRow.valueOf(cellElement.getColumn(), n2 - n3), false, n4, true);
        } else {
            writeECReport.simpleAppendData(ColumnRow.valueOf(n2 - n3, cellElement.getRow()), false, n4, true);
        }
    }

    private static int computeStepCount(int n2, int n3, int n4) {
        if (n2 > n3) {
            return 0;
        }
        return (n3 - n2) / n4 + 1;
    }

    private static boolean isMergeCell(CellElement cellElement) {
        return cellElement != null && (cellElement.getRowSpan() > 1 || cellElement.getColumnSpan() > 1);
    }

    private static void dealMergeCells(WriteECReport writeECReport, Map<CellElement, Integer> map, CellElement cellElement, int n2, boolean bl) {
        for (CellElement cellElement2 : map.keySet()) {
            CellElement cellElement3;
            int n3;
            int n4;
            int n5;
            int n6 = map.get(cellElement2);
            if (cellElement2 == null) continue;
            int n7 = bl ? cellElement.getColumn() + n6 : cellElement.getColumn() - 1 + cellElement2.getColumn() - n2;
            int n8 = n5 = bl ? cellElement.getRow() - 1 + cellElement2.getRow() - n2 : cellElement.getRow() + n6;
            if (cellElement2.getRowSpan() > 1) {
                n4 = cellElement2.getRowSpan();
                for (n3 = 0; n3 < n4; ++n3) {
                    cellElement3 = writeECReport.getCellElement(n7, n5 + n3);
                    if (cellElement3 == null) continue;
                    cellElement3.setRowSpan(n4);
                    cellElement3.setRow(n5);
                    if (!bl) continue;
                    cellElement3.doExcelImportWithLeftSon(writeECReport, cellElement3, n7, n7, n4);
                }
            }
            if (cellElement2.getColumnSpan() <= 1) continue;
            n4 = cellElement2.getColumnSpan();
            for (n3 = 0; n3 < n4; ++n3) {
                cellElement3 = writeECReport.getCellElement(n7 + n3, n5);
                if (cellElement3 != null) {
                    cellElement3.setColumnSpan(n4);
                    cellElement3.setColumn(n7);
                }
                if (bl || cellElement3 == null) continue;
                cellElement3.doExcelImportWithUpSon(writeECReport, cellElement3, n7, n5, n4);
            }
        }
    }

    private static CellElement getExcelCell4Import(ECReport eCReport, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            CellElement cellElement = eCReport.getCellElement(n2, n4);
            if (cellElement != null && cellElement.getColumn() == n2 && cellElement.getRow() == n4) {
                return cellElement;
            }
        } else {
            CellElement cellElement = eCReport.getCellElement(n4, n3);
            if (cellElement != null && cellElement.getColumn() == n4 && cellElement.getRow() == n3) {
                return cellElement;
            }
        }
        return null;
    }

    private static void dealValue4ExcelImport(boolean bl, boolean bl2, WriteCellElement writeCellElement, int n2, ECReport eCReport, List list) {
        Object object;
        if (bl) {
            int n3 = bl2 ? writeCellElement.getColumn() : writeCellElement.getColumn() + n2;
            int n4 = bl2 ? writeCellElement.getRow() + n2 : writeCellElement.getRow();
            object = eCReport.getCellValue(n3, n4);
        } else {
            int n5 = bl2 ? writeCellElement.getColumn() : writeCellElement.getColumn() - n2;
            int n6 = bl2 ? writeCellElement.getRow() - n2 : writeCellElement.getRow();
            object = eCReport.getCellValue(n5, n6);
        }
        if (object != null) {
            ExcelReportImporter.setValue4ExcelImport(writeCellElement, object, list);
        }
    }

    private static void setValue4ExcelImport(WriteCellElement writeCellElement, Object object, List list) {
        if (writeCellElement.getOriValue() == Constants.INIT_NULL) {
            writeCellElement.setOriValue(writeCellElement.getValue());
        }
        if (object instanceof Attachment) {
            Attachment attachment = (Attachment)object;
            object = new FRFile(attachment.getType(), attachment.getFilename(), attachment.getBytes());
        } else if (object instanceof Formula) {
            object = new ResultFormula((Formula)object);
        }
        writeCellElement.setValue(object);
        if (writeCellElement.getPresent() != null) {
            list.add(writeCellElement);
        }
    }

    private static void setDataAfterAppend(WriteECReport writeECReport, ECReport eCReport, boolean bl, boolean bl2, int n2, List list, List list2, List list3) {
        Object object;
        int n3 = n2 - 1;
        CellElement cellElement = (CellElement)((List)list2.get(0)).get(0);
        int n4 = n3;
        if (cellElement != null) {
            n4 = bl ? cellElement.getRow() - 1 : cellElement.getColumn() - 1;
        }
        int n5 = n4 - n3;
        boolean bl3 = true;
        if (n3 > n4) {
            n5 = n3 - n4;
            bl3 = false;
            n3 = n4;
        }
        for (int i2 = n5; i2 < n5 + n3; ++i2) {
            Object object2 = object = bl ? writeECReport.getRow(i2) : writeECReport.getColumn(i2);
            while (object.hasNext()) {
                WriteCellElement writeCellElement = (WriteCellElement)object.next();
                if (bl2) {
                    Widget widget = writeCellElement.getWidget();
                    if (widget == null) continue;
                    ExcelReportImporter.dealValue4ExcelImport(bl3, bl, writeCellElement, n5, eCReport, list);
                    continue;
                }
                ExcelReportImporter.dealValue4ExcelImport(bl3, bl, writeCellElement, n5, eCReport, list);
            }
        }
        int n6 = list2.size();
        for (int i3 = 0; i3 < n6; ++i3) {
            List list4 = (List)list2.get(i3);
            int n7 = list4.size();
            for (int i4 = 0; i4 < n7; ++i4) {
                Object object3;
                object = (CellElement)list4.get(i4);
                CellElement cellElement2 = (CellElement)list3.get(i4);
                WriteCellElement writeCellElement = bl ? writeECReport.getWriteCellElement(cellElement2.getColumn(), cellElement2.getRow() + i3) : writeECReport.getWriteCellElement(cellElement2.getColumn() + i3, cellElement2.getRow());
                Object object4 = object3 = object == null ? null : object.getValue();
                if (object3 == null) continue;
                ExcelReportImporter.setValue4ExcelImport(writeCellElement, object3, list);
            }
        }
    }

    private static void recalculateAfterImport(WriteWorkBook writeWorkBook, int n2, Map map, List[] listArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            List list;
            WriteECReport writeECReport = writeWorkBook.getWriteReport(i2);
            writeECReport.recalculate(null, map, true);
            int n3 = listArray.length;
            if (i2 >= n3 || (list = listArray[i2]) == null || list.isEmpty()) continue;
            Calculator calculator = Calculator.createCalculator();
            calculator.pushNameSpace(SimpleCellValueNameSpace.getInstance());
            calculator.setAttribute(Report.class, writeECReport);
            int n4 = list.size();
            for (int i3 = 0; i3 < n4; ++i3) {
                WriteCellElement writeCellElement = (WriteCellElement)list.get(i3);
                writeCellElement.setPresentValue(writeCellElement.getPresent().present(writeCellElement.getValue(), calculator));
            }
        }
    }

    private static void modifySizeAfterImport(WriteWorkBook writeWorkBook) {
        int n2 = writeWorkBook.getReportCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            WriteECReport writeECReport = (WriteECReport)writeWorkBook.getReport(i2);
            int n3 = ReportUtils.getReportSettings(writeECReport).getShrinkToFitMode();
            Iterator iterator = writeECReport.cellIterator();
            while (iterator.hasNext()) {
                A a2 = (A)iterator.next();
                CellGUIAttr cellGUIAttr = a2.getCellGUIAttr();
                if (cellGUIAttr == null) {
                    if (n3 == 1) {
                        writeECReport.shrinkTOFitRowHeightForCellElement(a2);
                        continue;
                    }
                    if (n3 != 2) continue;
                    writeECReport.shrinkTOFitColumnWidthForCellElement(a2);
                    continue;
                }
                if (n3 == 1 && cellGUIAttr.getAdjustMode() == 3 || cellGUIAttr.getAdjustMode() == 1) {
                    writeECReport.shrinkTOFitRowHeightForCellElement(a2);
                    continue;
                }
                if ((n3 != 2 || cellGUIAttr.getAdjustMode() != 3) && cellGUIAttr.getAdjustMode() != 2) continue;
                writeECReport.shrinkTOFitColumnWidthForCellElement(a2);
            }
        }
    }

    private static int matchReportToVerify(ECReport eCReport, int n2, int n3, int n4, List list, boolean bl) throws Exception {
        if (n2 >= 0 && !list.isEmpty()) {
            CellElement cellElement = (CellElement)list.get(0);
            for (int i2 = n3 - 1; i2 >= 0; --i2) {
                Object object;
                CellElement cellElement2 = ExcelReportImporter.getExcelCell4Import(eCReport, cellElement.getColumn(), cellElement.getRow(), i2, bl);
                if (cellElement2 == null || (object = cellElement2.getValue()) == null || !ComparatorUtils.equals(object.toString().trim(), cellElement.getValue().toString().trim())) continue;
                int n5 = 0;
                if (list.size() > 1) {
                    int n6 = list.size();
                    for (int i3 = 1; i3 < n6; ++i3) {
                        int n7;
                        CellElement cellElement3 = (CellElement)list.get(i3);
                        int n8 = cellElement2.getColumn() + cellElement3.getColumn() - cellElement.getColumn();
                        CellElement cellElement4 = eCReport.getCellElement(n8, n7 = cellElement2.getRow() + cellElement3.getRow() - cellElement.getRow());
                        if (cellElement4 == null || cellElement4.getColumn() != n8 || cellElement4.getRow() != n7 ? ++n5 > 0 : ((object = cellElement4.getValue()) == null || !ComparatorUtils.equals(object.toString().trim(), cellElement.getValue().toString().trim())) && ++n5 > 0) break;
                    }
                }
                if (n5 > 0 || (n4 = n2 - (bl ? cellElement.getRow() : cellElement.getColumn()) + i2) != Integer.MAX_VALUE) break;
                throw new WriteExcelImportException(Inter.getLocText("ExcelImport_Write_Match_Error_Info"));
            }
        }
        return n4;
    }

    private static int matchReportForLocation(WriteECReport writeECReport, ECReport eCReport, Point[] pointArray, List list, CellElement cellElement, boolean bl) throws Exception {
        int n2 = -1;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                CellElement cellElement2 = (CellElement)list.get(i2);
                CellElement cellElement3 = bl ? writeECReport.getCellElement(cellElement2.getColumn(), cellElement2.getRow() - 1) : writeECReport.getCellElement(cellElement2.getColumn() - 1, cellElement2.getRow());
                arrayList.add(i2, cellElement3 == null ? "" : Utils.objectToString(cellElement3.getValue()));
            }
            boolean[] blArray = new boolean[]{false, false};
            n2 = ExcelReportImporter.getStartRC(eCReport, arrayList, bl, blArray, pointArray, n2);
            if (!blArray[0]) {
                for (int i3 = 0; i3 < pointArray.length; ++i3) {
                    pointArray[i3] = null;
                }
                return -1;
            }
        }
        catch (Exception exception) {
            n2 = -1;
        }
        for (int i4 = 0; i4 < pointArray.length; ++i4) {
            if (pointArray[i4] != null) continue;
            pointArray[i4] = new Point(-1, -1);
        }
        return n2;
    }

    private static int getStartRC(ECReport eCReport, List list, boolean bl, boolean[] blArray, Point[] pointArray, int n2) {
        int n3 = bl ? eCReport.getRowCount() : eCReport.getColumnCount();
        int n4 = bl ? eCReport.getColumnCount() : eCReport.getRowCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = 0;
            boolean[] blArray2 = new boolean[n4];
            HashMap<Integer, Point> hashMap = new HashMap<Integer, Point>();
            for (int i3 = 0; i3 < n4; ++i3) {
                int n6;
                String string;
                CellElement cellElement;
                CellElement cellElement2 = cellElement = bl ? eCReport.getCellElement(i3, i2) : eCReport.getCellElement(i2, i3);
                if (cellElement == null || cellElement.getValue() == null || StringUtils.isEmpty(string = Utils.objectToString(cellElement.getValue())) || (n6 = ExcelReportImporter.checkTitleContains(list, 0, string, blArray2)) == -1) continue;
                ++n5;
                if (n6 < blArray2.length) {
                    blArray2[n6] = true;
                }
                hashMap.put(new Integer(n6), bl ? new Point(i2, i3) : new Point(i3, i2));
            }
            if (n5 > 1) {
                blArray[0] = true;
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    int n7 = (Integer)iterator.next();
                    pointArray[n7] = (Point)hashMap.get(n7);
                }
                continue;
            }
            if (!blArray[0]) continue;
            n2 = i2 - 1;
            break;
        }
        return n2;
    }

    private static int checkTitleContains(List list, int n2, String string, boolean[] blArray) {
        int n3 = list.indexOf(string);
        if (n3 == -1) {
            return -1;
        }
        int n4 = n2 + n3;
        if (n4 < blArray.length && blArray[n4]) {
            return ExcelReportImporter.checkTitleContains(list.subList(n3 + 1, list.size()), n4 + 1, string, blArray);
        }
        return n4;
    }

    public static List getAllPictures(HSSFWorkbook hSSFWorkbook) {
        ArrayList<ExcelPicture> arrayList = new ArrayList<ExcelPicture>();
        List list = hSSFWorkbook.getAllPictures();
        List list2 = ExcelReportImporter.getClientAnchorRecords(hSSFWorkbook);
        if (list.size() != list2.size()) {
            FRContext.getLogger().error("Error Happens On Picture Analysis");
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            HSSFPictureData hSSFPictureData = (HSSFPictureData)list.get(i2);
            ClientAnchorInfo clientAnchorInfo = (ClientAnchorInfo)list2.get(i2);
            HSSFSheet hSSFSheet = clientAnchorInfo.sheet;
            EscherClientAnchorRecord escherClientAnchorRecord = clientAnchorInfo.clientAnchorRecord;
            arrayList.add(new ExcelPicture(hSSFWorkbook, hSSFSheet, hSSFPictureData, escherClientAnchorRecord));
        }
        return arrayList;
    }

    private static List getClientAnchorRecords(HSSFWorkbook hSSFWorkbook) {
        ArrayList arrayList = new ArrayList();
        int n2 = hSSFWorkbook.getNumberOfSheets();
        for (int i2 = 0; i2 < n2; ++i2) {
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(i2);
            EscherAggregate escherAggregate = hSSFSheet.getDrawingEscherAggregate();
            if (escherAggregate == null) continue;
            List list = escherAggregate.getEscherRecords();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExcelReportImporter.getClientAnchorRecords(hSSFSheet, (EscherRecord)iterator.next(), 1, arrayList);
            }
        }
        return arrayList;
    }

    private static void getClientAnchorRecords(HSSFSheet hSSFSheet, EscherRecord escherRecord, int n2, List list) {
        List list2 = escherRecord.getChildRecords();
        for (EscherRecord escherRecord2 : list2) {
            if (escherRecord2 instanceof EscherClientAnchorRecord) {
                ClientAnchorInfo clientAnchorInfo = new ClientAnchorInfo(hSSFSheet, (EscherClientAnchorRecord)escherRecord2);
                list.add(clientAnchorInfo);
            }
            if (escherRecord2.getChildRecords().size() <= 0) continue;
            ExcelReportImporter.getClientAnchorRecords(hSSFSheet, escherRecord2, n2 + 1, list);
        }
    }

    public static class ExcelPicture
    extends AbstractExcelPicture {
        private final HSSFWorkbook workbook;
        private final HSSFSheet sheet;
        private final HSSFPictureData pictureData;

        public ExcelPicture(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, HSSFPictureData hSSFPictureData, EscherClientAnchorRecord escherClientAnchorRecord) {
            this.workbook = hSSFWorkbook;
            this.sheet = hSSFSheet;
            this.pictureData = hSSFPictureData;
            this.clientAnchor = escherClientAnchorRecord;
        }

        public HSSFSheet getSheet() {
            return this.sheet;
        }

        public byte[] getData() {
            return this.pictureData.getData();
        }
    }

    private static class ClientAnchorInfo {
        public HSSFSheet sheet;
        public EscherClientAnchorRecord clientAnchorRecord;

        public ClientAnchorInfo(HSSFSheet hSSFSheet, EscherClientAnchorRecord escherClientAnchorRecord) {
            this.sheet = hSSFSheet;
            this.clientAnchorRecord = escherClientAnchorRecord;
        }
    }
}

