/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.importer;

import com.fr.base.ConfigManager;
import com.fr.base.ExcelUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Margin;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.io.importer.AbstractExcelPicture;
import com.fr.io.importer.ExcelReportImporter;
import com.fr.io.importer.TemplateBookAdapter;
import com.fr.main.FineBook;
import com.fr.main.impl.WorkBook;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.CellElement;
import com.fr.report.report.ECReport;
import com.fr.stable.StableUtils;
import com.fr.stable.unit.INCH;
import com.fr.stable.unit.OLDPIX;
import com.fr.stable.unit.PT;
import com.fr.third.org.apache.poi.ddf.EscherClientAnchorRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.web.core.A.YB;
import java.awt.Color;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel2007ReportImporter {
    private static final int VERTICALROTATION = 255;
    private static final int EXCELRGB = 256;

    public WorkBook generateWorkBookByStream(InputStream inputStream) throws Exception {
        return this.generateWorkBookByStream(inputStream, new HashMap());
    }

    public WorkBook generateWorkBookByStream(InputStream inputStream, Map map) throws Exception {
        ExcelUtils.checkPOI();
        return (WorkBook)this.generate(inputStream, new TemplateBookAdapter(), map);
    }

    private FineBook generate(InputStream inputStream, TemplateBookAdapter templateBookAdapter, Map map) throws Exception {
        XSSFWorkbook xSSFWorkbook = new XSSFWorkbook(inputStream);
        FineBook fineBook = templateBookAdapter.getBookInstance();
        int n2 = xSSFWorkbook.getNumberOfSheets();
        Object v2 = map.get(YB.O);
        if (v2 != null) {
            ((YB)v2).A(n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (v2 != null) {
                ((YB)v2).D(i2);
            }
            XSSFSheet xSSFSheet = xSSFWorkbook.getSheetAt(i2);
            ECReport eCReport = templateBookAdapter.getChildReportInstance(xSSFWorkbook.getSheetName(i2));
            ReportSettingsProvider reportSettingsProvider = eCReport.getReportSettings();
            PaperSettingProvider paperSettingProvider = reportSettingsProvider.getPaperSetting();
            XSSFPrintSetup xSSFPrintSetup = xSSFSheet.getPrintSetup();
            reportSettingsProvider.setHeaderHeight(new INCH((float)xSSFPrintSetup.getHeaderMargin()));
            reportSettingsProvider.setFooterHeight(new INCH((float)xSSFPrintSetup.getFooterMargin()));
            if (xSSFPrintSetup.getLandscape()) {
                paperSettingProvider.setOrientation(1);
            } else {
                paperSettingProvider.setOrientation(0);
            }
            if (xSSFPrintSetup.getLeftToRight()) {
                reportSettingsProvider.setPageOrder(1);
            } else {
                reportSettingsProvider.setPageOrder(0);
            }
            Margin margin = paperSettingProvider.getMargin();
            margin.setTop(new INCH((float)xSSFSheet.getMargin((short)2)));
            margin.setLeft(new INCH((float)xSSFSheet.getMargin((short)0)));
            margin.setBottom(new INCH((float)xSSFSheet.getMargin((short)3)));
            margin.setRight(new INCH((float)xSSFSheet.getMargin((short)1)));
            this.traverseByRows(eCReport, xSSFWorkbook, xSSFSheet, templateBookAdapter, v2);
        }
        inputStream.close();
        return fineBook;
    }

    private void traverseByRows(ECReport eCReport, XSSFWorkbook xSSFWorkbook, XSSFSheet xSSFSheet, TemplateBookAdapter templateBookAdapter, Object object) {
        int n2 = xSSFSheet.getLastRowNum();
        int n3 = xSSFSheet.getFirstRowNum();
        if (object != null) {
            ((YB)object).E(n2 - n3);
        }
        for (int i2 = xSSFSheet.getFirstRowNum(); i2 <= n2; ++i2) {
            XSSFRow xSSFRow;
            if (object != null) {
                ((YB)object).B(i2 - n3);
            }
            if ((xSSFRow = xSSFSheet.getRow(i2)) == null) continue;
            eCReport.setRowHeight(i2, new PT((float)xSSFRow.getHeight() / ConfigManager.getInstance().getExcelAdjustHeight()));
            short s2 = xSSFRow.getLastCellNum();
            for (int i3 = Math.max(0, xSSFRow.getFirstCellNum()); i3 <= s2; ++i3) {
                XSSFCell xSSFCell;
                if (xSSFSheet.getColumnWidth((int)((short)i3)) != ExcelReportImporter.DEFAULT_EXCEL_CELL_WIDTH) {
                    eCReport.setColumnWidth(i3, new OLDPIX((float)((int)((double)xSSFSheet.getColumnWidth((int)((short)i3)) / ConfigManager.getInstance().getExcelAdjustWidth()))));
                }
                if ((xSSFCell = xSSFRow.getCell((int)((short)i3))) == null || this.isHiddenMergedCell(xSSFSheet, i3, i2)) continue;
                int[] nArray = this.getMergetColumnRow(xSSFSheet, i3, i2);
                int n4 = 1;
                int n5 = 1;
                if (nArray != null && nArray.length > 0) {
                    n4 = nArray[0];
                    n5 = nArray[1];
                }
                CellElement cellElement = templateBookAdapter.addNewCellElement(eCReport, i3, i2, n4, n5, Excel2007ReportImporter.getXSSFCellValue(xSSFCell));
                int[] nArray2 = this.getMergetColumnRowTo(xSSFSheet, i3, i2);
                XSSFRow xSSFRow2 = xSSFSheet.getRow(nArray2[1]);
                XSSFCell xSSFCell2 = xSSFRow2.getCell((int)((short)nArray2[0]));
                Style style = this.createStyle(xSSFWorkbook, xSSFCell, xSSFCell2);
                cellElement.setStyle(style);
            }
        }
    }

    public static Object getXSSFCellValue(XSSFCell xSSFCell) {
        Object object = null;
        if (xSSFCell.getCellType() == 1) {
            object = xSSFCell.getStringCellValue();
        } else if (xSSFCell.getCellType() == 0) {
            if (DateUtil.isCellDateFormatted((Cell)xSSFCell)) {
                return xSSFCell.getDateCellValue();
            }
            object = StableUtils.string2Number(StableUtils.convertNumberStringToString(new Double(xSSFCell.getNumericCellValue()), true));
        } else if (xSSFCell.getCellType() == 4) {
            object = xSSFCell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE;
        } else if (xSSFCell.getCellType() == 2) {
            String string = xSSFCell.getCellFormula();
            object = new Formula(string);
        } else if (xSSFCell.getCellType() == 5) {
            object = "" + xSSFCell.getErrorCellValue();
        } else if (xSSFCell.getCellType() == 3) {
            object = "";
        }
        return object;
    }

    private boolean isHiddenMergedCell(XSSFSheet xSSFSheet, int n2, int n3) {
        for (int i2 = 0; i2 < xSSFSheet.getNumMergedRegions(); ++i2) {
            CellRangeAddress cellRangeAddress = xSSFSheet.getMergedRegion(i2);
            if (!this.columnRowInRegion(cellRangeAddress, n2, n3)) continue;
            return cellRangeAddress.getFirstColumn() != n2 || cellRangeAddress.getFirstRow() != n3;
        }
        return false;
    }

    private boolean columnRowInRegion(CellRangeAddress cellRangeAddress, int n2, int n3) {
        return cellRangeAddress.getFirstColumn() <= n2 && cellRangeAddress.getLastColumn() >= n2 && cellRangeAddress.getFirstRow() <= n3 && cellRangeAddress.getLastRow() >= n3;
    }

    private int[] getMergetColumnRow(XSSFSheet xSSFSheet, int n2, int n3) {
        for (int i2 = 0; i2 < xSSFSheet.getNumMergedRegions(); ++i2) {
            CellRangeAddress cellRangeAddress = xSSFSheet.getMergedRegion(i2);
            if (!this.columnRowInRegion(cellRangeAddress, n2, n3)) continue;
            return new int[]{cellRangeAddress.getLastColumn() - cellRangeAddress.getFirstColumn() + 1, cellRangeAddress.getLastRow() - cellRangeAddress.getFirstRow() + 1};
        }
        return new int[0];
    }

    private int[] getMergetColumnRowTo(XSSFSheet xSSFSheet, int n2, int n3) {
        for (int i2 = 0; i2 < xSSFSheet.getNumMergedRegions(); ++i2) {
            CellRangeAddress cellRangeAddress = xSSFSheet.getMergedRegion(i2);
            if (!this.columnRowInRegion(cellRangeAddress, n2, n3)) continue;
            return new int[]{cellRangeAddress.getLastColumn(), cellRangeAddress.getLastRow()};
        }
        return new int[]{n2, n3};
    }

    private Style createStyle(XSSFWorkbook xSSFWorkbook, XSSFCell xSSFCell, XSSFCell xSSFCell2) {
        Style style = Style.DEFAULT_STYLE;
        XSSFCellStyle xSSFCellStyle = xSSFCell.getCellStyle();
        XSSFCellStyle xSSFCellStyle2 = xSSFCell2.getCellStyle();
        short s2 = xSSFCellStyle.getDataFormat();
        String string = xSSFWorkbook.createDataFormat().getFormat(s2);
        style = ExcelReportImporter.format(string, style);
        FRFont fRFont = this.createFontStyle(xSSFWorkbook, xSSFCellStyle);
        style = style.deriveFRFont(fRFont);
        XSSFColor xSSFColor = xSSFCellStyle.getFillForegroundColorColor();
        if (xSSFColor != null) {
            byte[] byArray = xSSFColor.getRgb();
            if (byArray == null || byArray.length == 0) {
                byArray = xSSFColor.getRgbWithTint();
            }
            style = style.deriveBackground(ColorBackground.getInstance(this.getStyleColor(byArray)));
        }
        short s3 = xSSFCellStyle.getAlignment();
        short s4 = xSSFCellStyle.getVerticalAlignment();
        style = ExcelReportImporter.getStyle(s3, s4, style);
        style = xSSFCellStyle.getWrapText() ? style.deriveTextStyle(0) : style.deriveTextStyle(1);
        short s5 = xSSFCellStyle.getRotation();
        if (s5 == 255) {
            style = style.deriveVerticalText(1);
            style = style.deriveRotation(0);
            style = style.deriveTextDirection(0);
        } else {
            style = style.deriveRotation(s5);
        }
        style = this.createBorderStyle(style, xSSFCellStyle, xSSFCellStyle2);
        return style;
    }

    private FRFont createFontStyle(XSSFWorkbook xSSFWorkbook, XSSFCellStyle xSSFCellStyle) {
        XSSFFont xSSFFont = xSSFWorkbook.getFontAt(xSSFCellStyle.getFontIndex());
        int n2 = 0;
        if (xSSFFont.getBoldweight() == 700) {
            ++n2;
        }
        if (xSSFFont.getItalic()) {
            n2 += 2;
        }
        short s2 = xSSFFont.getFontHeightInPoints();
        FRFont fRFont = FRFont.getInstance(xSSFFont.getFontName(), n2, s2);
        if (ComparatorUtils.equals(FRContext.getLocale(), Locale.CHINA) && !fRFont.canDisplay('\u5b8b')) {
            fRFont = FRFont.getInstance(Inter.getLocText("Song_TypeFace"), n2, s2);
        }
        fRFont = this.getFontColor(xSSFFont, fRFont);
        if (xSSFFont.getStrikeout()) {
            fRFont = fRFont.applyStrikethrough(true);
        }
        if (xSSFFont.getUnderline() == 0) {
            fRFont = fRFont.applyUnderline(0);
        } else if (xSSFFont.getUnderline() == 1 || xSSFFont.getUnderline() == 33) {
            fRFont = fRFont.applyUnderline(1);
        } else if (xSSFFont.getUnderline() == 2 || xSSFFont.getUnderline() == 34) {
            fRFont = fRFont.applyUnderline(6);
        }
        return fRFont;
    }

    private Style createBorderStyle(Style style, XSSFCellStyle xSSFCellStyle, XSSFCellStyle xSSFCellStyle2) {
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        if (xSSFCellStyle.getTopBorderXSSFColor() != null) {
            color = this.getStyleColor(xSSFCellStyle.getTopBorderXSSFColor().getRgb());
            color3 = this.getStyleColor(xSSFCellStyle.getTopBorderXSSFColor().getRgb());
        }
        if (xSSFCellStyle2.getTopBorderXSSFColor() != null) {
            color2 = this.getStyleColor(xSSFCellStyle2.getTopBorderXSSFColor().getRgb());
            color4 = this.getStyleColor(xSSFCellStyle2.getTopBorderXSSFColor().getRgb());
        }
        style = style.deriveBorder(ExcelReportImporter.getBorderStyle(xSSFCellStyle.getBorderTop()), color == null ? style.getBorderTopColor() : color, ExcelReportImporter.getBorderStyle(xSSFCellStyle2.getBorderBottom()), color2 == null ? style.getBorderBottomColor() : color2, ExcelReportImporter.getBorderStyle(xSSFCellStyle.getBorderLeft()), color3 == null ? style.getBorderLeftColor() : color3, ExcelReportImporter.getBorderStyle(xSSFCellStyle2.getBorderRight()), color4 == null ? style.getBorderRightColor() : color4);
        return style;
    }

    private Color getStyleColor(byte[] byArray) {
        if (byArray == null) {
            return Color.BLACK;
        }
        Color color = null;
        int[] nArray = new int[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            nArray[i2] = byArray[i2] < 0 ? byArray[i2] + 256 : byArray[i2];
        }
        color = new Color(nArray[0], nArray[1], nArray[2]);
        return color;
    }

    private FRFont getFontColor(XSSFFont xSSFFont, FRFont fRFont) {
        XSSFColor xSSFColor = xSSFFont.getXSSFColor();
        if (xSSFColor != null) {
            byte[] byArray = xSSFColor.getRgb();
            if (byArray != null) {
                Color color = this.getStyleColor(byArray);
                if (color != null) {
                    fRFont = fRFont.applyForeground(color);
                }
            } else {
                fRFont = fRFont.applyForeground(new Color(0, 0, 0));
            }
        } else {
            fRFont = fRFont.applyForeground(new Color(0, 0, 0));
        }
        return fRFont;
    }

    public static List getAllPictures(XSSFWorkbook xSSFWorkbook) {
        ArrayList<Excel2007Picture> arrayList = new ArrayList<Excel2007Picture>();
        List list = xSSFWorkbook.getAllPictures();
        List list2 = Excel2007ReportImporter.getClientAnchorRecords(xSSFWorkbook);
        if (list.size() != list2.size()) {
            FRContext.getLogger().error("Error Happens On Picture Analysis");
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            XSSFPictureData xSSFPictureData = (XSSFPictureData)list.get(i2);
            ClientAnchorInfo clientAnchorInfo = (ClientAnchorInfo)list2.get(i2);
            XSSFSheet xSSFSheet = clientAnchorInfo.sheet;
            EscherClientAnchorRecord escherClientAnchorRecord = clientAnchorInfo.clientAnchorRecord;
            arrayList.add(new Excel2007Picture(xSSFWorkbook, xSSFSheet, xSSFPictureData, escherClientAnchorRecord));
        }
        return arrayList;
    }

    private static List getClientAnchorRecords(XSSFWorkbook xSSFWorkbook) {
        ArrayList arrayList = new ArrayList();
        int n2 = xSSFWorkbook.getNumberOfSheets();
        for (int i2 = 0; i2 < n2; ++i2) {
            XSSFSheet xSSFSheet = xSSFWorkbook.getSheetAt(i2);
        }
        return arrayList;
    }

    private static void getClientAnchorRecords(XSSFSheet xSSFSheet, EscherRecord escherRecord, int n2, List list) {
        List list2 = escherRecord.getChildRecords();
        for (EscherRecord escherRecord2 : list2) {
            if (escherRecord2 instanceof EscherClientAnchorRecord) {
                ClientAnchorInfo clientAnchorInfo = new ClientAnchorInfo(xSSFSheet, (EscherClientAnchorRecord)escherRecord2);
                list.add(clientAnchorInfo);
            }
            if (escherRecord2.getChildRecords().size() <= 0) continue;
            Excel2007ReportImporter.getClientAnchorRecords(xSSFSheet, escherRecord2, n2 + 1, list);
        }
    }

    public static class Excel2007Picture
    extends AbstractExcelPicture {
        private final XSSFWorkbook workbook;
        private final XSSFSheet sheet;
        private final XSSFPictureData pictureData;

        public Excel2007Picture(XSSFWorkbook xSSFWorkbook, XSSFSheet xSSFSheet, XSSFPictureData xSSFPictureData, EscherClientAnchorRecord escherClientAnchorRecord) {
            this.workbook = xSSFWorkbook;
            this.sheet = xSSFSheet;
            this.pictureData = xSSFPictureData;
            this.clientAnchor = escherClientAnchorRecord;
        }

        public XSSFSheet getSheet() {
            return this.sheet;
        }

        public byte[] getData() {
            return this.pictureData.getData();
        }
    }

    private static class ClientAnchorInfo {
        public XSSFSheet sheet;
        public EscherClientAnchorRecord clientAnchorRecord;

        public ClientAnchorInfo(XSSFSheet xSSFSheet, EscherClientAnchorRecord escherClientAnchorRecord) {
            this.sheet = xSSFSheet;
            this.clientAnchorRecord = escherClientAnchorRecord;
        }
    }
}

