/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.Style;
import com.fr.io.core.ExporterUtils;
import com.fr.io.exporter.AbstractAppExporter;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.PaperSettingProvider;
import com.fr.report.cell.CellElement;
import com.fr.report.core.A.A.A;
import com.fr.report.core.A.A.B;
import com.fr.report.core.PackedReport;
import com.fr.report.core.ReportUtils;
import com.fr.report.report.ResultECReport;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.Format;
import java.util.Iterator;
import java.util.List;

public class TextExporter
extends AbstractAppExporter {
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        if (resultWorkBook == null) {
            throw new Exception("Report can not be null!");
        }
        List<PaperSettingProvider> list = ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook);
        for (int i2 = 0; i2 < resultWorkBook.getReportCount(); ++i2) {
            ResultECReport resultECReport = (ResultECReport)resultWorkBook.getResultReport(i2);
            while (resultECReport instanceof PackedReport) {
                resultECReport = (ResultECReport)((PackedReport)resultECReport).getPackee();
            }
            this.export(outputStream, resultECReport, list.get(i2));
        }
    }

    private void export(OutputStream outputStream, ResultECReport resultECReport, PaperSettingProvider paperSettingProvider) throws Exception {
        if (resultECReport == null) {
            throw new Exception("Report can not be null!");
        }
        if (resultECReport instanceof A || resultECReport instanceof B) {
            PageSetProvider pageSetProvider = resultECReport.generateReportPageSet(paperSettingProvider).traverse4Export();
            this.export(outputStream, pageSetProvider);
            pageSetProvider.release();
        } else {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
            Iterator iterator = resultECReport.cellIterator();
            this.writeCells(printWriter, iterator);
            printWriter.flush();
        }
    }

    private void writeCells(PrintWriter printWriter, Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            Object object = cellElement.getValue();
            if (object == null) {
                object = " ";
            }
            Style style = cellElement.getStyle();
            Format format = style.getFormat();
            string = Style.valueToText(object, format);
            int n4 = cellElement.getColumn();
            int n5 = cellElement.getRow();
            if (n5 > n2) {
                if (stringBuffer != null) {
                    printWriter.println(stringBuffer.toString());
                }
                n2 = n5;
                n3 = 0;
                stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                n3 = n4;
                continue;
            }
            for (int i2 = n3; i2 < n4; ++i2) {
                stringBuffer.append('\t');
            }
            stringBuffer.append(string);
            n3 = n4;
        }
        if (stringBuffer != null) {
            printWriter.print(stringBuffer.toString());
        }
    }

    public void export(OutputStream outputStream, PageSetProvider pageSetProvider) throws Exception {
        ClippedPageProvider clippedPageProvider;
        if (pageSetProvider == null) {
            throw new Exception("Error! pages is null");
        }
        for (int i2 = 0; i2 < pageSetProvider.size() && (clippedPageProvider = ExporterUtils.support(pageSetProvider.getPage(i2))) != null; ++i2) {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
            if (clippedPageProvider != null) {
                Iterator iterator = clippedPageProvider.cellIterator();
                this.writeCells(printWriter, iterator);
                printWriter.println();
                printWriter.println();
                printWriter.println();
                printWriter.println();
            }
            printWriter.flush();
        }
    }
}

