/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.FRContext;
import com.fr.io.attr.PDFExportAttr;
import com.fr.io.attr.ReportExportAttr;
import com.fr.io.exporter.AbstractAppExporter;
import com.fr.io.exporter.PDFExporterNameSpace;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PagePainterProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.ReportPageProvider;
import com.fr.report.core.ReportUtils;
import com.fr.script.Calculator;
import com.fr.stable.OperatingSystem;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.third.com.lowagie.text.Document;
import com.fr.third.com.lowagie.text.ExceptionConverter;
import com.fr.third.com.lowagie.text.Rectangle;
import com.fr.third.com.lowagie.text.pdf.BaseFont;
import com.fr.third.com.lowagie.text.pdf.FontMapper;
import com.fr.third.com.lowagie.text.pdf.PdfContentByte;
import com.fr.third.com.lowagie.text.pdf.PdfReader;
import com.fr.third.com.lowagie.text.pdf.PdfStamper;
import com.fr.third.com.lowagie.text.pdf.PdfWriter;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;

public class PDFExporter
extends AbstractAppExporter {
    protected static MyFontMapper fontMapper = null;
    protected boolean isPrint = false;

    public boolean isPrint() {
        return this.isPrint;
    }

    public PDFExporter() {
        this(false);
    }

    public PDFExporter(boolean bl) {
        this.isPrint = bl;
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSetProvider pageSetProvider = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).traverse4Export();
        Calculator.putThreadSavedNameSpace(new PDFExporterNameSpace(resultWorkBook));
        this.export(outputStream, pageSetProvider, resultWorkBook.getReportExportAttr());
        pageSetProvider.release();
    }

    public void export(OutputStream outputStream, PageSetProvider pageSetProvider) throws Exception {
        this.export(outputStream, pageSetProvider, null);
    }

    public void export(OutputStream outputStream, PageSetProvider pageSetProvider, ReportExportAttr reportExportAttr) throws Exception {
        ReportPageProvider reportPageProvider;
        PDFExportAttr pDFExportAttr;
        Document document = null;
        String string = null;
        PdfWriter pdfWriter = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PDFExportAttr pDFExportAttr2 = pDFExportAttr = reportExportAttr == null ? null : reportExportAttr.getPDFExportAttr();
        if (pDFExportAttr != null && StringUtils.isNotEmpty(pDFExportAttr.getPassword())) {
            string = pDFExportAttr.getPassword();
        }
        boolean bl = true;
        for (int i2 = 0; i2 < pageSetProvider.size() && (reportPageProvider = pageSetProvider.getPage(i2)) != null; ++i2) {
            float f2 = reportPageProvider.getPaperWidth().toPixF(72);
            float f3 = reportPageProvider.getPaperHeight().toPixF(72);
            if (document == null) {
                document = new Document(new Rectangle(f2, f3));
                pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
                document.open();
            }
            if (!bl) {
                document.setPageSize(new Rectangle(f2, f3));
                document.newPage();
            }
            bl = false;
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            Graphics2D graphics2D = pdfContentByte.createGraphics(f2, f3, (FontMapper)PDFExporter.prepareFontMapper());
            double d2 = 0.75;
            graphics2D.scale(d2, d2);
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            hashMap.put("0", ReportPageProvider.class);
            hashMap.put("1", Graphics2D.class);
            PagePainterProvider pagePainterProvider = (PagePainterProvider)StableFactory.createNewObject("PagePainter", new Object[]{reportPageProvider, graphics2D, Integer.valueOf(String.valueOf(96)), this.isPrint}, hashMap);
            pagePainterProvider.convert();
            graphics2D.dispose();
        }
        if (document != null) {
            document.close();
        }
        if (string != null) {
            PdfReader pdfReader = new PdfReader(byteArrayOutputStream.toByteArray());
            pdfReader.removeUsageRights();
            reportPageProvider = new PdfStamper(pdfReader, outputStream);
            reportPageProvider.setEncryption(false, string, "", 3900);
            reportPageProvider.close();
        }
        try {
            outputStream.write(byteArrayOutputStream.toByteArray());
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static MyFontMapper prepareFontMapper() {
        if (fontMapper != null) {
            return fontMapper;
        }
        fontMapper = new MyFontMapper();
        try {
            Object object;
            String string;
            if (OperatingSystem.isWindows()) {
                string = System.getProperty("java.library.path");
                object = StableUtils.splitString(string, ";");
                for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                    File file = new File(object[i2]);
                    PDFExporter.InsertDirectory(fontMapper, new File(file, "Fonts"));
                }
                PDFExporter.InsertDirectory(fontMapper, new File("C:\\WINNT\\Fonts"));
                PDFExporter.InsertDirectory(fontMapper, new File("C:\\WINDOWS\\Fonts"));
            } else {
                PDFExporter.InsertDirectory(fontMapper, new File("/usr/X11R6/lib/X11/fonts"));
                PDFExporter.InsertDirectory(fontMapper, new File("/usr/share/fonts"));
                string = StableUtils.pathJoin(new String[]{FRContext.getCurrentEnv().getPath(), "fonts"});
                PDFExporter.InsertDirectory(fontMapper, new File(string));
                PDFExporter.InsertDirectory(fontMapper, new File("/usr/X/lib/X11/fonts/TrueType"));
                PDFExporter.InsertDirectory(fontMapper, new File("/usr/openwin/lib/X11/fonts/TrueType"));
            }
            string = System.getProperty("java.home");
            if (string != null && ((File)(object = new File(StableUtils.pathJoin(new String[]{string, "lib", "fonts"})))).exists() && ((File)object).isDirectory()) {
                PDFExporter.InsertDirectory(fontMapper, (File)object);
            }
            MyFontMapper.defaultFont = FRContext.getLocale() == Locale.CHINA || FRContext.getLocale() == Locale.CHINESE ? BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false) : (FRContext.getLocale() == Locale.TAIWAN || FRContext.getLocale() == Locale.TRADITIONAL_CHINESE ? BaseFont.createFont((String)"MSung-Light", (String)"UniCNS-UCS2-H", (boolean)false) : (FRContext.getLocale() == Locale.JAPAN || FRContext.getLocale() == Locale.JAPANESE ? BaseFont.createFont((String)"HeiseiKakuGo-W5", (String)"UniJIS-UCS2-H", (boolean)false) : (FRContext.getLocale() == Locale.KOREA || FRContext.getLocale() == Locale.KOREAN ? BaseFont.createFont((String)"HYGoThic-Medium", (String)"UniKS-UCS2-H", (boolean)false) : BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false))));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        return fontMapper;
    }

    protected static void InsertDirectory(MyFontMapper myFontMapper, File file) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return;
        }
        myFontMapper.insertDirectory(file.getAbsolutePath());
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            PDFExporter.InsertDirectory(myFontMapper, fileArray[i2]);
        }
    }

    public static class MyFontMapper
    implements FontMapper {
        public static final String CHINESE_SIMPLIFIED_FONT = "STSong-Light";
        public static final String CHINESE_SIMPLIFIED_ENCODING_H = "UniGB-UCS2-H";
        public static final String CHINESE_SIMPLIFIED_ENCODING_V = "UniGB-UCS2-V";
        public static final String CHINESE_TRADITIONAL_FONT_M_HEI = "MHei-Medium";
        public static final String CHINESE_TRADITIONAL_FONT_M_SUNG = "MSung-Light";
        public static final String CHINESE_TRADITIONAL_ENCODING_H = "UniCNS-UCS2-H";
        public static final String CHINESE_TRADITIONAL_ENCODING_V = "UniCNS-UCS2-V";
        public static final String JAPANESE_FONT_GO = "HeiseiKakuGo-W5";
        public static final String JAPANESE_FONT_MIN = "HeiseiMin-W3";
        public static final String JAPANESE_ENCODING_H = "UniJIS-UCS2-H";
        public static final String JAPANESE_ENCODING_V = "UniJIS-UCS2-V";
        public static final String JAPANESE_ENCODING_HW_H = "UniJIS-UCS2-HW-H";
        public static final String JAPANESE_ENCODING_HW_V = "UniJIS-UCS2-HW-V";
        public static final String KOREAN_FONT_GO_THIC = "HYGoThic-Medium";
        public static final String KOREAN_FONT_S_MYEONG_JO = "HYSMyeongJo-Medium";
        public static final String KOREAN_ENCODING_H = "UniKS-UCS2-H";
        public static final String KOREAN_ENCODING_V = "UniKS-UCS2-V";
        public static BaseFont defaultFont;
        private HashMap mapper = new HashMap();

        public BaseFont awtToPdf(Font font) {
            try {
                BaseFontParameters baseFontParameters = this.getBaseFontParameters(font.getFontName());
                if (baseFontParameters == null) {
                    baseFontParameters = this.getBaseFontParameters(font.getName());
                }
                if (baseFontParameters != null) {
                    return BaseFont.createFont((String)baseFontParameters.fontName, (String)baseFontParameters.encoding, (boolean)baseFontParameters.embedded, (boolean)baseFontParameters.cached, (byte[])baseFontParameters.ttfAfm, (byte[])baseFontParameters.pfb);
                }
                if (defaultFont != null) {
                    return defaultFont;
                }
                String string = "Courier";
                if (font.isBold() && font.isItalic()) {
                    string = "Courier-BoldOblique";
                } else if (font.isBold()) {
                    string = "Courier-Bold";
                } else if (font.isItalic()) {
                    string = "Courier-Oblique";
                }
                return BaseFont.createFont((String)string, (String)"Cp1252", (boolean)false);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
                throw new ExceptionConverter(exception);
            }
        }

        public Font pdfToAwt(BaseFont baseFont, int n2) {
            String string;
            String[][] stringArray = baseFont.getFullFontName();
            if (stringArray.length == 1) {
                return new Font(stringArray[0][3], 0, n2);
            }
            String string2 = null;
            String string3 = null;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String[] stringArray2 = stringArray[i2];
                if (stringArray2[0].equals("1") && stringArray2[1].equals("0")) {
                    string2 = stringArray2[3];
                    continue;
                }
                if (!stringArray2[2].equals("1033")) continue;
                string3 = stringArray2[3];
                break;
            }
            if ((string = string3) == null) {
                string = string2;
            }
            if (string == null) {
                string = stringArray[0][3];
            }
            return new Font(string, 0, n2);
        }

        private BaseFontParameters getBaseFontParameters(String string) {
            return (BaseFontParameters)this.mapper.get(string);
        }

        protected void insertNames(String[][] stringArray, String string) {
            Object object;
            int n2;
            String string2 = null;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                object = stringArray[n2];
                if (!object[2].equals("1033")) continue;
                string2 = object[3];
                break;
            }
            if (string2 == null) {
                string2 = stringArray[0][3];
            }
            object = new BaseFontParameters(string);
            this.mapper.put(string2, object);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                this.mapper.put(stringArray[n2][3], object);
            }
        }

        public int insertDirectory(String string) {
            File file = new File(string);
            if (!file.exists() || !file.isDirectory()) {
                return 0;
            }
            File[] fileArray = file.listFiles();
            int n2 = 0;
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                file = fileArray[i2];
                String string2 = file.getPath().toLowerCase();
                try {
                    String[][] stringArray;
                    if (string2.endsWith(".ttf") || string2.endsWith(".otf") || string2.endsWith(".afm")) {
                        stringArray = BaseFont.getFullFontName((String)file.getPath(), (String)"Cp1252", null);
                        this.insertNames(stringArray, file.getPath());
                        ++n2;
                        continue;
                    }
                    if (!string2.endsWith(".ttc")) continue;
                    stringArray = BaseFont.enumerateTTCNames((String)file.getPath());
                    for (int i3 = 0; i3 < stringArray.length; ++i3) {
                        String string3 = String.valueOf(new StringBuffer(file.getPath()).append(',').append(i3));
                        String[][] stringArray2 = BaseFont.getFullFontName((String)string3, (String)"Cp1252", null);
                        this.insertNames(stringArray2, string3);
                    }
                    ++n2;
                    continue;
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                }
            }
            return n2;
        }

        public static class BaseFontParameters {
            public String fontName;
            public String encoding;
            public boolean embedded;
            public boolean cached;
            public byte[] ttfAfm;
            public byte[] pfb;

            public BaseFontParameters(String string) {
                this.fontName = string;
                this.encoding = "Identity-H";
                this.embedded = true;
                this.cached = true;
            }

            public String toString() {
                return "{fontName:" + this.fontName + ",encoding:" + this.encoding + ",embedded:" + this.embedded + ",cached:" + this.cached;
            }
        }
    }
}

