/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.BaseUtils;
import com.fr.base.DynamicUnitList;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Margin;
import com.fr.base.PaperSize;
import com.fr.base.ResultFormula;
import com.fr.base.Style;
import com.fr.base.TextFormat;
import com.fr.base.headerfooter.DateHFElement;
import com.fr.base.headerfooter.HFElement;
import com.fr.base.headerfooter.NewLineHFElement;
import com.fr.base.headerfooter.NumberOfPageHFElement;
import com.fr.base.headerfooter.PageNumberHFElement;
import com.fr.base.headerfooter.TextHFElement;
import com.fr.base.headerfooter.TimeHFElement;
import com.fr.cache.list.IntList;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.io.attr.ReportExportAttr;
import com.fr.io.core.ExcelExporterReport;
import com.fr.io.exporter.AbstractAppExporter;
import com.fr.io.exporter.POIPictureLocation;
import com.fr.io.exporter.POIWrapper.POICellAction;
import com.fr.io.exporter.POIWrapper.POICellStyleAction;
import com.fr.io.exporter.POIWrapper.POIClientAnchorAction;
import com.fr.io.exporter.POIWrapper.POIFontAction;
import com.fr.io.exporter.POIWrapper.POIHeaderFooterAction;
import com.fr.io.exporter.POIWrapper.POIPatriarchAction;
import com.fr.io.exporter.POIWrapper.POIPrintSetupAction;
import com.fr.io.exporter.POIWrapper.POISheetAction;
import com.fr.io.exporter.POIWrapper.POIWorkbookAction;
import com.fr.main.FineBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.parser.FRLexer;
import com.fr.parser.FRParser;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.DefaultPageCellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.cellattr.CellPageAttr;
import com.fr.report.core.PackedReport;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.report.ECReport;
import com.fr.report.report.Report;
import com.fr.report.report.ResultECReport;
import com.fr.report.report.WriteECReport;
import com.fr.report.worksheet.PageRWorkSheet;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.ExportConstants;
import com.fr.stable.StringUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ColumnRowLiteral;
import com.fr.stable.script.ColumnRowRange;
import com.fr.stable.script.ExTool;
import com.fr.stable.script.Expression;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.third.com.lowagie.text.Font;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFooter;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFHeader;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExcelExporter
extends AbstractAppExporter {
    protected static final short DEFAULT_FONT = 11;
    protected static final short DEFAULT_COL_WIDTH = 9;
    protected static final int PICTURE_TYPE_PNG = 6;
    protected static final int EXCEL_EXPORT_RESOLUTION = 96;
    protected static final String FORMULA_ERROR = "\"FR(" + Inter.getLocText("Excel_formula_error") + "!)\"";
    protected static final int MAX_PROPER_FONT = 14;
    protected static final double FONT_SCALE = 0.95;
    protected List paperSettingList = null;
    protected Hashtable hssfFontHash = new Hashtable();
    protected Hashtable hssfCellStyleHash = new Hashtable();
    protected IntList colorList = new IntList();
    protected Map[] columnRowPostileMaps = null;
    protected EXT ex_tool = new EXT();
    protected int totalBreak;

    @Override
    public abstract void export(OutputStream var1, ResultWorkBook var2) throws Exception;

    protected abstract short getFormat(POIWorkbookAction var1, String var2);

    protected abstract POIFontAction createFont(POIWorkbookAction var1, java.awt.Font var2);

    protected abstract short getRotation(Style var1);

    protected abstract int getFloatLeftMax(double var1);

    protected abstract int getFloatTopMax(double var1);

    protected String checkValueVertical(int n2, int n3, int n4, int n5, Object object, Style style, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2) {
        int n6 = dynamicUnitList.getRangeValue(n2, n2 + n3).toPixI(96);
        int n7 = dynamicUnitList2.getRangeValue(n4, n4 + n5).toPixI(96);
        List list = BaseUtils.getLineTextList((String)object, style, style.getFRFont().applyResolutionNP(96), n6, n7, 96);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = i2 == list.size() - 1 ? "" : "\n";
            stringBuffer.append(list.get(i2)).append(string);
        }
        return stringBuffer.toString();
    }

    protected boolean isShowAsImage(int n2, CellGUIAttr cellGUIAttr) {
        return n2 == 2 || n2 == 3 || cellGUIAttr.isShowAsImage();
    }

    protected int[] dealWithHiddenCR(int n2, int n3, IntList intList) {
        int[] nArray = new int[]{n2, n3};
        for (int i2 = 0; i2 < intList.size(); ++i2) {
            int n4 = intList.get(i2);
            if (n4 >= n2 && n4 < n2 + n3) {
                nArray[1] = nArray[1] - 1;
                continue;
            }
            if (n4 >= n2) continue;
            nArray[0] = nArray[0] - 1;
        }
        return nArray;
    }

    protected String createHFString(List list, String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            HFElement hFElement = (HFElement)list.get(i2);
            if (!(hFElement instanceof TextHFElement)) continue;
            FRFont fRFont = ((TextHFElement)hFElement).getFRFont();
            String string5 = "";
            if (fRFont.getStyle() == 0) {
                string5 = "Plain";
            } else if (fRFont.getStyle() == 1) {
                string5 = "Bold";
            } else if (fRFont.getStyle() == 2) {
                string5 = "Italic";
            } else if (fRFont.getStyle() == 3) {
                string5 = "Bold Italic";
            }
            stringBuffer.append(HSSFHeader.font((String)fRFont.getName(), (String)string5));
            stringBuffer.append(HSSFHeader.fontSize((short)((short)fRFont.getSize())));
            stringBuffer.append(' ');
            if (hFElement.getClass().equals(TextHFElement.class)) {
                stringBuffer.append(((TextHFElement)hFElement).getText());
                continue;
            }
            if (hFElement.getClass().equals(DateHFElement.class)) {
                stringBuffer.append(string);
                continue;
            }
            if (hFElement.getClass().equals(TimeHFElement.class)) {
                stringBuffer.append(string2);
                continue;
            }
            if (hFElement.getClass().equals(PageNumberHFElement.class)) {
                stringBuffer.append(string3);
                continue;
            }
            if (hFElement.getClass().equals(NumberOfPageHFElement.class)) {
                stringBuffer.append(string4);
                continue;
            }
            if (!hFElement.getClass().equals(NewLineHFElement.class)) continue;
        }
        return stringBuffer.toString();
    }

    protected String dealWithSumFormula(String string, Object object, Formula formula, boolean bl) {
        String string2 = ((ResultFormula)object).getTransferContent();
        if (!bl && this.checkSumValid(string, string2)) {
            String[] stringArray = string2.split(",");
            string = stringArray[0] + ":" + stringArray[stringArray.length - 1];
        } else {
            string = string2;
            string = ComparatorUtils.equals(string, "=") ? formula.getContent() : string;
        }
        return string;
    }

    private boolean checkSumValid(String string, String string2) {
        try {
            String string3 = StringUtils.perfectStart(string, "=").replaceAll(" ", "").toUpperCase();
            return string3.indexOf("=SUM(") != -1 && string.indexOf(":") != -1 && string.split("[(:,)]").length == 3 && string2.indexOf(",") != -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected Object checkNumberFormat(Format format, Object object) {
        if (format instanceof NumberFormat && object instanceof String && Pattern.matches("[\\d.]+", (String)object)) {
            object = Double.valueOf((String)object);
        }
        return object;
    }

    protected void setAttr4ECReportSIL(Calculator calculator, IntList intList, IntList intList2, ElementCase elementCase) {
        calculator.setAttribute(ExTool.TAG, this.ex_tool);
        this.ex_tool.rowHiddenList = intList;
        this.ex_tool.colHiddenList = intList2;
        this.ex_tool.report = (Report)((Object)elementCase);
        this.ex_tool.hhMap = null;
    }

    public void setPostilMap(Map[] mapArray) {
        this.columnRowPostileMaps = mapArray;
    }

    protected void dealWithFormula(POICellAction pOICellAction, String string) {
        if (!this.checkInvalidFormula(string)) {
            pOICellAction.setCellType(1);
            pOICellAction.setCellValue("=" + string);
            return;
        }
        try {
            pOICellAction.setCellType(2);
            pOICellAction.setCellFormula(string);
            if (!string.equalsIgnoreCase(pOICellAction.getCellFormula()) && !string.matches(".+![\\w&&[\\D]]+\\d+.*")) {
                pOICellAction.setCellType(1);
                pOICellAction.setCellFormula(string);
                FRContext.getLogger().error(Inter.getLocText("NS_export_excelFormula") + string);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(Inter.getLocText("NS_export_excelFormula") + string);
            if (string.indexOf("[!0") != -1) {
                pOICellAction.setCellType(0);
                pOICellAction.setCellValue(0.0);
            }
            pOICellAction.setCellType(1);
            pOICellAction.setCellValue("=" + string);
        }
    }

    protected String getPassword(ResultWorkBook resultWorkBook) {
        String string = null;
        ReportExportAttr reportExportAttr = resultWorkBook.getReportExportAttr();
        if (reportExportAttr != null && reportExportAttr.getExcelExportAttr() != null) {
            string = reportExportAttr.getExcelExportAttr().getPassword();
        }
        return string;
    }

    protected void setSheetName(POIWorkbookAction pOIWorkbookAction, String string) {
        if (StringUtils.isEmpty(string)) {
            return;
        }
        int n2 = 30;
        if (string.length() > n2) {
            string = string.substring(0, n2);
        }
        int n3 = 1;
        while (pOIWorkbookAction.getSheet(string) != null) {
            string = "Sheet" + n3;
            ++n3;
        }
        pOIWorkbookAction.setSheetName(pOIWorkbookAction.getNumberOfSheets() - 1, string);
    }

    protected void dealWithPrintSetUp(POIPrintSetupAction pOIPrintSetupAction, PaperSize paperSize, int n2, ReportSettingsProvider reportSettingsProvider) {
        if (paperSize.equals(PaperSize.PAPERSIZE_A4)) {
            pOIPrintSetupAction.setPaperSize((short)9);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_LETTER)) {
            pOIPrintSetupAction.setPaperSize((short)5);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_HALFLETTER)) {
            pOIPrintSetupAction.setPaperSize((short)2);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_TABLOID)) {
            pOIPrintSetupAction.setPaperSize((short)3);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_LEDGER)) {
            pOIPrintSetupAction.setPaperSize((short)4);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_LEGAL)) {
            pOIPrintSetupAction.setPaperSize((short)5);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_A3)) {
            pOIPrintSetupAction.setPaperSize((short)8);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_A5)) {
            pOIPrintSetupAction.setPaperSize((short)11);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_A6)) {
            pOIPrintSetupAction.setPaperSize((short)70);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_B4)) {
            pOIPrintSetupAction.setPaperSize((short)12);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_B5_JIS)) {
            pOIPrintSetupAction.setPaperSize((short)13);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_NOTE)) {
            pOIPrintSetupAction.setPaperSize((short)18);
        } else {
            pOIPrintSetupAction.setPaperSize((short)9);
        }
        pOIPrintSetupAction.setLandscape(n2 == 1);
        pOIPrintSetupAction.setLeftToRight(reportSettingsProvider.getPageOrder() == 1);
        pOIPrintSetupAction.setHeaderMargin(reportSettingsProvider.getHeaderHeight().toINCHValue4Scale3());
        pOIPrintSetupAction.setFooterMargin(reportSettingsProvider.getFooterHeight().toINCHValue4Scale3());
    }

    protected void dealWithAlignAndMargin(POISheetAction pOISheetAction, ReportSettingsProvider reportSettingsProvider, Margin margin) {
        pOISheetAction.setVerticallyCenter(reportSettingsProvider.isVerticalCenterOnPage());
        pOISheetAction.setMargin((short)2, margin.getTop().toINCHValue4Scale3());
        pOISheetAction.setMargin((short)0, margin.getLeft().toINCHValue4Scale3());
        pOISheetAction.setMargin((short)3, margin.getBottom().toINCHValue4Scale3());
        pOISheetAction.setMargin((short)1, margin.getRight().toINCHValue4Scale3());
    }

    protected void dealWithBufferImage(Object object, POIClientAnchorAction pOIClientAnchorAction, POIPatriarchAction pOIPatriarchAction, Style style, int n2, int n3, BufferedImage bufferedImage, POIWorkbookAction pOIWorkbookAction) {
        if (object != null) {
            pOIClientAnchorAction.setAnchorType(2);
            try {
                int n4 = this.loadPicture(bufferedImage, pOIWorkbookAction);
                pOIPatriarchAction.createPicture(pOIClientAnchorAction, n4);
            }
            catch (IOException iOException) {
                FRContext.getLogger().error(iOException.getMessage());
            }
        }
    }

    protected POIFontAction createSimpleFont(POIWorkbookAction pOIWorkbookAction, FontAdapter fontAdapter, POIFontAction pOIFontAction, String string) {
        Enumeration enumeration = this.hssfFontHash.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            if (!((Object)fontAdapter).equals(k2)) continue;
            pOIFontAction.setFont(this.hssfFontHash.get(k2));
            break;
        }
        if (pOIFontAction.getFont() == null) {
            pOIFontAction.setFont(pOIWorkbookAction.createFont());
            this.hssfFontHash.put(fontAdapter.getPackee(), pOIFontAction.getFont());
        }
        pOIFontAction.setFontHeight((short)(fontAdapter.getSize() * 20.0f));
        pOIFontAction.setFontName(ComparatorUtils.equals(fontAdapter.getName(), "unknown") ? string : fontAdapter.getName());
        if (fontAdapter.isBold()) {
            pOIFontAction.setBoldweight((short)700);
        } else {
            pOIFontAction.setBoldweight((short)400);
        }
        if (fontAdapter.isItalic()) {
            pOIFontAction.setItalic(true);
        } else {
            pOIFontAction.setItalic(false);
        }
        return pOIFontAction;
    }

    protected void createComplexFont4Itext(Font font, Map map, POIFontAction pOIFontAction) {
        if (font.isStrikethru()) {
            pOIFontAction.setStrikeout(true);
        }
        if (font.isUnderlined()) {
            pOIFontAction.setUnderline((byte)1);
        }
        if (map != null && map.containsKey("SUBSUPSCRIPT")) {
            float f2 = ((Number)map.get("SUBSUPSCRIPT")).floatValue();
            if (f2 > 0.0f) {
                pOIFontAction.setTypeOffset((short)1);
            } else {
                pOIFontAction.setTypeOffset((short)2);
            }
        }
    }

    protected void createComplexFont4FR(FRFont fRFont, POIFontAction pOIFontAction) {
        int n2;
        if (fRFont.isStrikethrough()) {
            pOIFontAction.setStrikeout(true);
        }
        if (fRFont.isSubscript()) {
            pOIFontAction.setTypeOffset((short)2);
        }
        if (fRFont.isSuperscript()) {
            pOIFontAction.setTypeOffset((short)1);
        }
        if ((n2 = GraphHelper.getLineStyleSize(fRFont.getUnderline())) == 0) {
            pOIFontAction.setUnderline((byte)0);
        } else if (n2 == 1) {
            pOIFontAction.setUnderline((byte)1);
        } else if (n2 == 2) {
            pOIFontAction.setUnderline((byte)2);
        }
    }

    protected void executeCellStyle(POIWorkbookAction pOIWorkbookAction, POICellStyleAction pOICellStyleAction, Style style) {
        Object object;
        Format format = style.getFormat();
        if (format != null) {
            if (format instanceof DecimalFormat) {
                object = ((DecimalFormat)format).toPattern();
                object = ((String)object).replace('\u00a4', '\uffe5');
                pOICellStyleAction.setDataFormat(this.getFormat(pOIWorkbookAction, (String)object));
            } else if (format instanceof SimpleDateFormat) {
                pOICellStyleAction.setDataFormat(this.getFormat(pOIWorkbookAction, ((SimpleDateFormat)format).toPattern()));
            } else if (format instanceof TextFormat) {
                pOICellStyleAction.setDataFormat((short)49);
            }
        }
        if ((object = this.createFont(pOIWorkbookAction, style.getFRFont())) != null) {
            pOICellStyleAction.setFont((POIFontAction)object);
        }
        pOICellStyleAction.setBorderTop(this.getMapBorder(style.getBorderTop()));
        pOICellStyleAction.setBorderLeft(this.getMapBorder(style.getBorderLeft()));
        pOICellStyleAction.setBorderBottom(this.getMapBorder(style.getBorderBottom()));
        pOICellStyleAction.setBorderRight(this.getMapBorder(style.getBorderRight()));
        pOICellStyleAction.setWrapText(style.getTextStyle() == 0);
        pOICellStyleAction.setRotation(this.getRotation(style));
        int n2 = BaseUtils.getAlignment4Horizontal(style);
        if (n2 == 2) {
            pOICellStyleAction.setAlignment((short)1);
        } else if (n2 == 0) {
            pOICellStyleAction.setAlignment((short)2);
        } else if (n2 == 4) {
            pOICellStyleAction.setAlignment((short)3);
        } else if (n2 == 6 || n2 == -1) {
            // empty if block
        }
        if (style.getVerticalAlignment() == 1) {
            pOICellStyleAction.setVerticalAlignment((short)0);
        } else if (style.getVerticalAlignment() == 0) {
            pOICellStyleAction.setVerticalAlignment((short)1);
        } else if (style.getVerticalAlignment() == 3) {
            pOICellStyleAction.setVerticalAlignment((short)2);
        } else if (style.getVerticalAlignment() == 6) {
            // empty if block
        }
    }

    protected short getMapBorder(int n2) {
        if (n2 == 1) {
            return 1;
        }
        if (n2 == 2) {
            return 2;
        }
        if (n2 == 3) {
            return 3;
        }
        if (n2 == 4) {
            return 4;
        }
        if (n2 == 5) {
            return 5;
        }
        if (n2 == 6) {
            return 6;
        }
        if (n2 == 7) {
            return 7;
        }
        if (n2 == 8) {
            return 8;
        }
        if (n2 == 9) {
            return 9;
        }
        if (n2 == 10) {
            return 10;
        }
        if (n2 == 11) {
            return 11;
        }
        if (n2 == 12) {
            return 12;
        }
        if (n2 == 13) {
            return 13;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int loadPicture(BufferedImage bufferedImage, POIWorkbookAction pOIWorkbookAction) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            GeneralUtils.writeImage(bufferedImage, "png", byteArrayOutputStream);
            n2 = pOIWorkbookAction.addPicture(byteArrayOutputStream.toByteArray(), 6);
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
        }
        return n2;
    }

    protected void applyReportHFHeader(ReportHFProvider reportHFProvider, POIHeaderFooterAction pOIHeaderFooterAction) {
        pOIHeaderFooterAction.setLeft(this.createHFString(reportHFProvider.getLeftList(), HSSFHeader.date(), HSSFHeader.time(), HSSFHeader.page(), HSSFHeader.numPages()));
        pOIHeaderFooterAction.setCenter(this.createHFString(reportHFProvider.getCenterList(), HSSFHeader.date(), HSSFHeader.time(), HSSFHeader.page(), HSSFHeader.numPages()));
        pOIHeaderFooterAction.setRight(this.createHFString(reportHFProvider.getRightList(), HSSFHeader.date(), HSSFHeader.time(), HSSFHeader.page(), HSSFHeader.numPages()));
    }

    protected void applyReportHFFooter(ReportHFProvider reportHFProvider, POIHeaderFooterAction pOIHeaderFooterAction) {
        pOIHeaderFooterAction.setLeft(this.createHFString(reportHFProvider.getLeftList(), HSSFFooter.date(), HSSFFooter.time(), HSSFFooter.page(), HSSFFooter.numPages()));
        pOIHeaderFooterAction.setCenter(this.createHFString(reportHFProvider.getCenterList(), HSSFFooter.date(), HSSFFooter.time(), HSSFFooter.page(), HSSFFooter.numPages()));
        pOIHeaderFooterAction.setRight(this.createHFString(reportHFProvider.getRightList(), HSSFFooter.date(), HSSFFooter.time(), HSSFFooter.page(), HSSFFooter.numPages()));
    }

    protected boolean checkInvalidFormula(String string) {
        StringReader stringReader = new StringReader(string);
        FRLexer fRLexer = new FRLexer(stringReader);
        FRParser fRParser = new FRParser(fRLexer);
        Expression expression = null;
        try {
            expression = fRParser.parse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return expression != null;
    }

    protected void setDefaultFont(POIWorkbookAction pOIWorkbookAction) {
        POIFontAction pOIFontAction = pOIWorkbookAction.getFontAt((short)0);
        pOIFontAction.setCharSet((byte)1);
        pOIFontAction.setFontHeightInPoints((short)11);
        pOIFontAction.setFontName(Inter.getLocText("Song_TypeFace"));
    }

    protected void exportBook(ResultWorkBook resultWorkBook, POIWorkbookAction pOIWorkbookAction, List list, List<String> list2, List<Report> list3, boolean bl) throws Exception {
        Report report;
        int n2;
        int n3 = resultWorkBook.getReportCount();
        for (n2 = 0; n2 < n3; ++n2) {
            report = resultWorkBook.getReport(n2);
            list3.add(report);
            while (report instanceof PackedReport) {
                report = ((PackedReport)report).getPackee();
                list3.set(n2, report);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            report = list3.get(n2);
            this.processResultEC(report, resultWorkBook, pOIWorkbookAction, list, list2, list3, n2);
        }
    }

    private void processResultEC(Object object, ResultWorkBook resultWorkBook, POIWorkbookAction pOIWorkbookAction, List list, List<String> list2, List<Report> list3, int n2) {
        ResultECReport resultECReport;
        if (!(object instanceof ResultECReport)) {
            return;
        }
        if (object instanceof WriteECReport) {
            object = ((WriteECReport)object).processWidgetAsImageInWB((WriteECReport)object);
        }
        if (!(resultECReport = (ResultECReport)object).cellIterator().hasNext()) {
            PageRWorkSheet pageRWorkSheet = new PageRWorkSheet();
            Iterator iterator = resultECReport.floatIterator();
            while (iterator.hasNext()) {
                pageRWorkSheet.addFloatElement((FloatElement)iterator.next());
            }
            pageRWorkSheet.addCellElement(new DefaultPageCellElement(0, 0, ""));
            resultECReport = pageRWorkSheet;
        }
        this.innerExportReports(resultECReport, resultWorkBook, pOIWorkbookAction, list, list2, list3, n2);
    }

    protected Style adjustProperFontSize(Style style) {
        FRFont fRFont = style.getFRFont();
        int n2 = fRFont.getSize();
        if (n2 > 14 && style.getTextStyle() == 0) {
            fRFont = fRFont.applySize((int)((double)n2 * 0.95));
        }
        return style.deriveFRFont(fRFont);
    }

    protected abstract void innerExportReports(ResultECReport var1, ResultWorkBook var2, POIWorkbookAction var3, List var4, List<String> var5, List<Report> var6, int var7);

    protected String replaceNewLineChar(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.replaceAll("\\\\n", "\n");
    }

    protected String splitAndFilterString(String string) {
        if (string == null || string.trim().equals("")) {
            return "";
        }
        String string2 = string.replaceAll("<[a-zA-Z]+[1-9]?[^><]*>", "").replaceAll("</[a-zA-Z]+[1-9]?>", "");
        string2 = string2.replaceAll("[(/>)<]", "").replaceAll("&nbsp;", " ");
        return string2;
    }

    protected POIPictureLocation locateFloatElementInExcel(FloatElement floatElement, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, ElementCase elementCase, Object object) {
        int n2;
        Object[] objectArray = ReportHelper.calculateLastColumnAndRowOfFloatElement(elementCase, floatElement);
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        l2 = floatElement.getLeftDistance().toFU();
        l3 = floatElement.getTopDistance().toFU();
        l4 = ((UNIT)objectArray[1]).toFU();
        l5 = ((UNIT)objectArray[2]).toFU();
        Point point = ReportHelper.calculateStartColumnAndRowOfFloatElement(elementCase, floatElement);
        int n3 = point.x;
        int n4 = point.y;
        int n5 = ((Point)objectArray[0]).x;
        int n6 = ((Point)objectArray[0]).y;
        int n7 = FU.getInstance(l2).toPixI(96);
        int n8 = FU.getInstance(l3).toPixI(96);
        int n9 = FU.getInstance(l4).toPixI(96);
        int n10 = FU.getInstance(l5).toPixI(96);
        int n11 = 0;
        int n12 = 0;
        for (n2 = n3; n2 > 0; --n2) {
            n11 = (int)((double)n11 + dynamicUnitList2.get(n3).toPixD(96));
        }
        for (n2 = n4; n2 > 0; --n2) {
            n12 = (int)((double)n12 + dynamicUnitList.get(n4).toPixD(96));
        }
        n7 = n7 > n11 ? n7 - n11 : 0;
        n8 = n8 > n12 ? n8 - n12 : 0;
        double d2 = dynamicUnitList2.get(n3).toPixD(96);
        double d3 = dynamicUnitList.get(n4).toPixD(96);
        double d4 = dynamicUnitList2.get(n5).toPixD(96);
        double d5 = dynamicUnitList.get(n6).toPixD(96);
        int n13 = this.getFloatLeftMax(d2);
        int n14 = this.getFloatTopMax(d3);
        int n15 = this.getFloatLeftMax(d4);
        int n16 = this.getFloatTopMax(d5);
        n7 = (int)(new Double(n7) / d2 * (double)n13);
        n8 = (int)(new Double(n8) / d3 * (double)n14);
        n9 = (int)(new Double(n9) / d4 * (double)n15);
        n10 = (int)(new Double(n10) / d5 * (double)n16);
        n7 = n7 < n13 ? n7 : n13;
        n8 = n8 < n14 ? n8 : n14;
        n9 = n9 < n13 ? n9 : n15;
        n10 = n10 < n14 ? n10 : n16;
        return new POIPictureLocation(n7, n8, n9, n10, (short)n3, n4, (short)((Point)objectArray[0]).x, ((Point)objectArray[0]).y);
    }

    protected void setColumnRowBreak(CellElement cellElement, POISheetAction pOISheetAction, int n2, int n3, int n4, int n5) {
        if (this.totalBreak > 1000) {
            return;
        }
        CellPageAttr cellPageAttr = cellElement.getCellPageAttr();
        if (cellPageAttr != null) {
            if (cellPageAttr.isPageBeforeColumn() && n2 > 1) {
                ++this.totalBreak;
                pOISheetAction.setColumnBreak((short)(n2 - 1));
            }
            if (cellPageAttr.isPageAfterColumn() && n4 < ExportConstants.MAX_COLS - 1) {
                ++this.totalBreak;
                pOISheetAction.setColumnBreak((short)n4);
            }
            if (cellPageAttr.isPageBeforeRow() && n3 > 1) {
                ++this.totalBreak;
                pOISheetAction.setRowBreak(n3 - 1);
            }
            if (cellPageAttr.isPageAfterRow() && n5 < ExportConstants.MAX_ROWS - 1) {
                ++this.totalBreak;
                pOISheetAction.setRowBreak(n5);
            }
        }
    }

    protected static class TextFontAdapter
    implements FontAdapter {
        private Font font;

        protected TextFontAdapter(Font font) {
            this.font = font;
        }

        public boolean equals(Object object) {
            return this.font.equals(object);
        }

        public String getName() {
            return this.font.getFamilyname();
        }

        public Object getPackee() {
            return this.font;
        }

        public float getSize() {
            return this.font.getSize();
        }

        public boolean isBold() {
            return this.font.isBold();
        }

        public boolean isItalic() {
            return this.font.isItalic();
        }
    }

    protected static interface FontAdapter {
        public boolean equals(Object var1);

        public Object getPackee();

        public boolean isBold();

        public boolean isItalic();

        public float getSize();

        public String getName();
    }

    protected static class JavaFontAdapter
    implements FontAdapter {
        private java.awt.Font font;

        protected JavaFontAdapter(java.awt.Font font) {
            this.font = font;
        }

        public float getSize() {
            return this.font.getSize();
        }

        public boolean isBold() {
            return this.font.isBold();
        }

        public boolean isItalic() {
            return this.font.isItalic();
        }

        public boolean equals(Object object) {
            return this.font.equals(object);
        }

        public String getName() {
            return this.font.getName();
        }

        public Object getPackee() {
            return this.font;
        }
    }

    protected class EXT
    implements ExTool {
        IntList rowHiddenList = null;
        IntList colHiddenList = null;
        Report report = null;
        Map hhMap = null;

        protected EXT() {
        }

        public void setCreateRelation(boolean bl) {
        }

        public String exSIL(CalculatorProvider calculatorProvider, String string, ColumnRowRange columnRowRange) {
            FineBook fineBook;
            if (StringUtils.isBlank(string) || columnRowRange == null) {
                return null;
            }
            if (this.report != null && this.report instanceof ExcelExporterReport && (fineBook = this.report.getBook()) != null) {
                for (int i2 = 0; i2 < fineBook.getReportCount(); ++i2) {
                    IntList[] intListArray;
                    if (!ComparatorUtils.equals(string, fineBook.getReportName(i2))) continue;
                    Report report = fineBook.getReport(i2);
                    if (report == null || !(report instanceof ECReport)) break;
                    ECReport eCReport = (ECReport)report;
                    if (eCReport.getRowCount() > ExportConstants.MAX_ROWS_2007 || eCReport.getColumnCount() > ExportConstants.MAX_COLS_2007) {
                        return null;
                    }
                    if (this.hhMap == null) {
                        this.hhMap = new HashMap();
                    }
                    if ((intListArray = (IntList[])this.hhMap.get(new Integer(i2))) == null) {
                        IntList intList = new IntList();
                        DynamicUnitList dynamicUnitList = ReportHelper.getRowHeightList(eCReport);
                        for (int i3 = dynamicUnitList.size() - 1; i3 >= 0; --i3) {
                            if (!eCReport.getRowHeight(i3).equal_zero()) continue;
                            intList.add(i3);
                        }
                        IntList intList2 = new IntList();
                        DynamicUnitList dynamicUnitList2 = ReportHelper.getColumnWidthList(eCReport);
                        for (int i4 = dynamicUnitList2.size() - 1; i4 >= 0; --i4) {
                            if (!eCReport.getColumnWidth(i4).equal_zero()) continue;
                            intList2.add(i4);
                        }
                        intListArray = new IntList[]{intList, intList2};
                        this.hhMap.put(new Integer(i2), intListArray);
                    }
                    return "'" + string + "'!" + this.deleteFromHiddenList(columnRowRange, intListArray[0], intListArray[1]).toString();
                }
            }
            return null;
        }

        public List exBoxes(ColumnRowRange columnRowRange) {
            return null;
        }

        public ColumnRow deleteFromHiddenList(ColumnRowRange columnRowRange, IntList intList, IntList intList2) {
            if (columnRowRange == null) {
                return null;
            }
            ColumnRowLiteral columnRowLiteral = columnRowRange.getFrom();
            ColumnRowLiteral columnRowLiteral2 = columnRowRange.getTo();
            ColumnRow columnRow = columnRowLiteral.getTargetColumnRow();
            ColumnRow columnRow2 = columnRowLiteral2 == null ? null : columnRowLiteral2.getTargetColumnRow();
            ArrayList arrayList = new ArrayList();
            if (columnRowLiteral2 == null) {
                return this.getHiddenColumnRow(columnRow.getColumn(), columnRow.getRow(), intList, intList2);
            }
            throw new RuntimeException();
        }

        private ColumnRow getHiddenColumnRow(int n2, int n3, IntList intList, IntList intList2) {
            int n4;
            int n5 = n2;
            int n6 = n3;
            for (n4 = 0; n4 < n2; ++n4) {
                if (!intList2.contain(n4)) continue;
                --n5;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (!intList.contain(n4)) continue;
                --n6;
            }
            return ColumnRow.valueOf(n5, n6);
        }

        public String ex(CalculatorProvider calculatorProvider, ColumnRowRange columnRowRange) {
            ColumnRow columnRow = this.deleteFromHiddenList(columnRowRange, this.rowHiddenList, this.colHiddenList);
            if (columnRow != null) {
                return columnRow.toString();
            }
            return "";
        }
    }
}

