/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.http;

import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient {
    public static final String HEADER = "__header__";
    private static final int TIME_OUT = 300000;
    private String url;
    private HttpURLConnection conn;
    private int timeout = -1;
    private String header;
    private String charSet;

    public HttpClient(String string) {
        this.url = string;
    }

    public HttpClient(String string, HashMap<String, String> hashMap) {
        this(string, hashMap, true);
    }

    public HttpClient(String string, HashMap<String, String> hashMap, boolean bl) {
        this.url = string;
        this.appendPara(hashMap, bl);
    }

    private void appendPara(HashMap<String, String> hashMap, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.url);
        stringBuilder.append(this.url.indexOf(63) != -1 ? (char)'&' : '?');
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (ComparatorUtils.equals(string, HEADER)) {
                this.header = string2;
                continue;
            }
            stringBuilder.append('&');
            stringBuilder.append(this.encodeString(string, bl));
            stringBuilder.append('=');
            stringBuilder.append(this.encodeString(string2, bl));
        }
        this.url = stringBuilder.toString();
    }

    private String encodeString(String string, boolean bl) {
        String string2 = CodeUtils.cjkEncode(string);
        if (!bl) {
            return string2;
        }
        try {
            String string3 = StringUtils.isEmpty(this.charSet) ? "UTF-8" : this.charSet;
            return URLEncoder.encode(string2, string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string2;
        }
    }

    public void setByteEntity(byte[] byArray) {
        this.connect();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            OutputStream outputStream = this.conn.getOutputStream();
            GeneralUtils.copyBinaryTo(byteArrayInputStream, outputStream);
            byteArrayInputStream.close();
            outputStream.close();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }

    private void applyHeader() {
        if (StringUtils.isEmpty(this.header)) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(this.header);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = jSONObject.getString(string);
                this.conn.setRequestProperty(string, string2);
            }
        }
        catch (JSONException jSONException) {
            FRLogger.getLogger().error(jSONException.getMessage());
        }
    }

    public void setTimeout(int n2) {
        this.timeout = n2;
    }

    public void setCharSet(String string) {
        this.charSet = string;
    }

    private void connect() {
        if (this.conn != null) {
            return;
        }
        try {
            URL uRL = new URL(this.url);
            this.conn = (HttpURLConnection)uRL.openConnection();
            this.conn.setUseCaches(false);
            String string = StringUtils.isEmpty(this.charSet) ? "UTF-8" : this.charSet;
            this.conn.setRequestProperty("Content-Type", "text/xml;charset=" + string);
            this.conn.setRequestMethod("GET");
            this.applyHeader();
            int n2 = this.timeout == -1 ? 300000 : this.timeout;
            this.conn.setDoOutput(true);
            this.conn.setDoInput(true);
            this.conn.setReadTimeout(n2);
            this.conn.setConnectTimeout(n2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }

    public int getResponseCode() {
        this.connect();
        try {
            return this.conn.getResponseCode();
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage());
            return -1;
        }
    }

    public String getResponseText() {
        return this.getResponseText("UTF-8");
    }

    public byte[] getResponseBytes() {
        InputStream inputStream = this.getResponseStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GeneralUtils.copyBinaryTo(inputStream, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getResponseText(String string) {
        InputStream inputStream = this.getResponseStream();
        if (inputStream == null) {
            return this.getResponseCode() + "";
        }
        try {
            return GeneralUtils.inputStream2String(inputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.getResponseCode() + "";
        }
    }

    public InputStream getResponseStream() {
        this.connect();
        try {
            return this.conn.getInputStream();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            return null;
        }
    }

    public String getHeaderField(String string) {
        this.connect();
        return this.conn.getHeaderField(string);
    }

    public Iterator<String> getHeaderFieldIterator(String string) {
        Map<String, List<String>> map = this.getAllHeader();
        return map.get(string).iterator();
    }

    public Map<String, List<String>> getAllHeader() {
        this.connect();
        return this.conn.getHeaderFields();
    }

    public void release() {
        if (this.conn != null) {
            this.conn.disconnect();
            this.conn = null;
        }
    }
}

