/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.cache.Attachment;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.DefaultValues;
import com.fr.general.DesUtils;
import com.fr.general.EnvProvider;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.general.process.ExecuteResult;
import com.fr.general.process.LocalCommandExecutorServiceImpl;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.FormulaProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.encoder.GIFEncoder;
import com.fr.stable.pinyin.ChineseHelper;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.Expression;
import com.fr.stable.xml.XMLWriter;
import com.fr.third.antlr.ANTLRException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class GeneralUtils {
    private static final int TAIL_LENGTH = 9;
    public static final int TW_MB = 32768;
    public static final String EMAIL_SUBJECT = "SUBJECT";
    private static final int TEN_M = 10240;
    public static int ascCodeA = 65;
    public static int ascCodeZ = 90;
    public static int ascCodea = 97;
    public static int ascCodez = 122;
    public static int ascCode0 = 48;
    public static int ascCode9 = 57;
    public static int ascCodef = 102;
    public static int ascCodeW = 87;
    private static short macMax = (short)255;
    private static int hexStep = 4;
    private static int macPara = 5;
    public static final String RESOURCE_ENCODER = "GBK";
    private static final int CMD_TIME_OUT = 5000;
    private static Map imageMap = new HashMap();

    private GeneralUtils() {
    }

    public static String objectToString(Object object) {
        if (object == null) {
            object = "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            return StableUtils.convertNumberStringToString((Number)object, false);
        }
        if (object instanceof Date) {
            DefaultValues defaultValues = GeneralContext.getDefaultValues();
            if (object instanceof Time) {
                return defaultValues.getTimeFormat().format(object);
            }
            String string = defaultValues.getDateTimeFormat().format(object);
            if (string.endsWith("00:00:00")) {
                return string.substring(0, string.length() - 9);
            }
            return string;
        }
        if (object instanceof Image || object instanceof Attachment) {
            return "";
        }
        return object.toString();
    }

    public static Number objectToNumber(Object object, boolean bl) {
        Number number;
        if (object == null) {
            return bl ? null : Integer.valueOf(0);
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        String string = GeneralUtils.objectToString(object);
        if (string != null) {
            string = string.trim();
        }
        if ((number = GeneralUtils.string2Number(string)) == null && !bl) {
            number = 0;
        }
        return number;
    }

    public static Number string2Number(String string) {
        return StableUtils.string2Number(string);
    }

    public static Map jsonString2Map(String string) throws JSONException {
        if (StringUtils.isNotBlank(string)) {
            return GeneralUtils.json2Map(new JSONObject(string));
        }
        return new HashMap();
    }

    public static Map json2Map(JSONObject jSONObject) throws JSONException {
        HashMap hashMap = new HashMap();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            XMLWriter xMLWriter;
            Object object;
            Object e2 = iterator.next();
            Object object2 = jSONObject.get(e2.toString());
            if (object2 instanceof JSONArray) {
                object = (JSONArray)object2;
                xMLWriter = new FArray();
                for (int i2 = 0; i2 < ((JSONArray)object).length(); ++i2) {
                    ((FArray)xMLWriter).add(((JSONArray)object).get(i2));
                }
                object2 = xMLWriter;
            } else if (object2 instanceof JSONObject && ((JSONObject)(object = (JSONObject)object2)).opt("type") != null && ((JSONObject)object).opt("value") != null) {
                if (ComparatorUtils.equals(((JSONObject)object).get("type"), "date")) {
                    object2 = DateUtils.string2Date(((JSONObject)object).get("value").toString(), false);
                } else if (ComparatorUtils.equals(((JSONObject)object).get("type"), "formula")) {
                    xMLWriter = (FormulaProvider)((Object)StableFactory.createXmlObject("Formula"));
                    xMLWriter.setContent(((JSONObject)object).get("value").toString());
                    object2 = xMLWriter;
                }
            }
            hashMap.put(e2, object2);
        }
        return hashMap;
    }

    public static Class classForName(String string) throws ClassNotFoundException, NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader;
            EnvProvider envProvider = GeneralContext.getEnvProvider();
            if (envProvider == null) {
                throw classNotFoundException;
            }
            String string2 = envProvider.getPath();
            File file = new File(StableUtils.pathJoin(new String[]{string2, "classes"}));
            try {
                classLoader = new URLClassLoader(new URL[]{file.toURL()}, GeneralUtils.class.getClassLoader());
            }
            catch (MalformedURLException malformedURLException) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            return Class.forName(string, true, classLoader);
        }
    }

    public static void dealBuidExecuteSequence(Object object, List list, CalculatorProvider calculatorProvider) {
        if (object instanceof FormulaProvider) {
            FormulaProvider formulaProvider = (FormulaProvider)object;
            String string = formulaProvider.getContent();
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            if (StringUtils.isEmpty(string) || StringUtils.isBlank(string)) {
                return;
            }
            try {
                Expression expression = calculatorProvider.parse(string);
                expression.trav4HuntBIL(list);
            }
            catch (ANTLRException aNTLRException) {
                FRLogger.getLogger().error(aNTLRException.getMessage(), aNTLRException);
            }
        }
    }

    public static String inputStream2String(InputStream inputStream) throws UnsupportedEncodingException {
        return new String(GeneralUtils.inputStream2Bytes(inputStream), "UTF-8");
    }

    public static String inputStream2String(InputStream inputStream, String string) throws UnsupportedEncodingException {
        return new String(GeneralUtils.inputStream2Bytes(inputStream), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] inputStream2Bytes(InputStream inputStream) {
        byte[] byArray = new byte[32768];
        byte[] byArray2 = new byte[]{};
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) > 0) {
                byte[] byArray3 = byArray.length == n2 ? byArray : ArrayUtils.subarray(byArray, 0, n2);
                byArray2 = ArrayUtils.addAll(byArray2, byArray3);
            }
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error(iOException.getMessage(), iOException);
            }
        }
        return byArray2;
    }

    public static void copyCharTo(Reader reader, Writer writer) throws IOException {
        int n2;
        char[] cArray = new char[32768];
        while ((n2 = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n2);
        }
        writer.flush();
    }

    public static BufferedImage readImageWithCache(String string) {
        return GeneralUtils.readImage(string, true);
    }

    private static BufferedImage readImage(String string, boolean bl) {
        Object var2_2 = null;
        if (bl) {
            var2_2 = imageMap.get(string);
        }
        if (var2_2 instanceof BufferedImage) {
            return var2_2;
        }
        InputStream inputStream = null;
        if (StringUtils.isNotEmpty(string) && string.toLowerCase().startsWith("http:")) {
            try {
                inputStream = new URL(string).openStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
                inputStream = GeneralUtils.readFromChinesePath(string);
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error(iOException.getMessage(), iOException);
            }
        } else {
            inputStream = GeneralUtils.readResource(string);
        }
        if (inputStream == null) {
            return null;
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = GeneralUtils.readImage(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
        if (bl) {
            imageMap.put(string, bufferedImage);
        }
        return bufferedImage;
    }

    private static InputStream readFromChinesePath(String string) {
        InputStream inputStream = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (ChineseHelper.isChineseCharacter(c2)) {
                    stringBuffer.append(URLEncoder.encode(String.valueOf(c2), "UTF-8"));
                    continue;
                }
                stringBuffer.append(c2);
            }
            inputStream = new URL(stringBuffer.toString()).openStream();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return inputStream;
    }

    public static BufferedImage readImage(String string) {
        return GeneralUtils.readImage(string, false);
    }

    public static Icon readIcon(String string) {
        return new ImageIcon(GeneralUtils.readImageWithCache(string));
    }

    public static BufferedImage readImage(InputStream inputStream) throws IOException {
        return ImageIO.read(inputStream);
    }

    private static boolean checkPrivilege(String string) {
        return string.indexOf("..") == -1 && !string.endsWith(".xml") && !string.endsWith(".cpt");
    }

    public static InputStream readResource(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        InputStream inputStream = string.startsWith("/") ? GeneralUtils.class.getResourceAsStream(string) : GeneralUtils.class.getResourceAsStream("/" + string);
        if (inputStream != null && GeneralUtils.checkPrivilege(string)) {
            return inputStream;
        }
        try {
            try {
                File file = new File(string);
                if (file.exists()) {
                    return new FileInputStream(string);
                }
                return GeneralUtils.checkEmbered(string);
            }
            catch (SecurityException securityException) {
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return null;
    }

    private static InputStream checkEmbered(String string) {
        InputStream inputStream = null;
        try {
            if (string.endsWith(".cpt")) {
                inputStream = GeneralContext.getEnvProvider().readBean(string, "reportlets");
            }
            if (string.endsWith(".xml")) {
                inputStream = GeneralContext.getEnvProvider().readBean(string, "resources");
            }
            if (inputStream != null) {
                String string2 = CodeUtils.passwordEncode(GeneralUtils.inputStream2String(inputStream, "UTF-8"));
                return new ByteArrayInputStream(string2.getBytes("UTF-8"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputStream;
    }

    public static void writeImage(Image image, String string, OutputStream outputStream) {
        CoreGraphHelper.waitForImage(image);
        try {
            if ("gif".equalsIgnoreCase(string)) {
                GIFEncoder gIFEncoder = new GIFEncoder(image, outputStream);
                gIFEncoder.encode();
            } else {
                ImageIO.write((RenderedImage)CoreGraphHelper.toBufferedImage(image), string, outputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String readBuildNO() {
        return GeneralUtils.readResourceAsString("build.txt");
    }

    public static String readResourceAsString(String string) {
        return GeneralUtils.readResourceAsString(string, RESOURCE_ENCODER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResourceAsString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        InputStream inputStream = GeneralUtils.readResource(string);
        String string3 = null;
        if (inputStream != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string2));
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append('\n');
                    }
                    stringBuffer.append(string3);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error(iOException.getMessage(), iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    FRLogger.getLogger().error(iOException.getMessage(), iOException);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static final String getUUID() {
        Object object;
        String[] stringArray;
        String string = "";
        String string2 = System.getProperty("os.name", "");
        try {
            String[] stringArray2;
            if (string2.startsWith("Windows")) {
                String[] stringArray3 = new String[4];
                stringArray3[0] = "wmic";
                stringArray3[1] = "csproduct";
                stringArray3[2] = "list";
                stringArray2 = stringArray3;
                stringArray3[3] = "full";
            } else {
                String[] stringArray4 = new String[3];
                stringArray4[0] = "dmidecode";
                stringArray4[1] = "-t";
                stringArray2 = stringArray4;
                stringArray4[2] = "1";
            }
            stringArray = stringArray2;
            object = new LocalCommandExecutorServiceImpl();
            ExecuteResult executeResult = object.executeCommand(stringArray, 5000L);
            string = GeneralUtils.checkResult4UUID(executeResult);
            if (StringUtils.isEmpty(string) && new File("/var/lib/dbus/machine-id").exists()) {
                File file = new File("/var/lib/dbus/machine-id");
                string = GeneralUtils.inputStream2String(new FileInputStream(file)).trim();
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        if (StringUtils.isEmpty(string)) {
            return Inter.getLocText("get-uuid-failed");
        }
        stringArray = DesUtils.getEncString(string, "finereport");
        object = DesUtils.getDesString((String)stringArray, "finereport");
        return ComparatorUtils.equals(object, string) ? stringArray : DesUtils.encodeWithHex(string);
    }

    private static String checkResult4UUID(ExecuteResult executeResult) {
        if (executeResult.getExitCode() != -1 && executeResult.getExecuteOut() != null) {
            String[] stringArray = executeResult.getExecuteOut().toUpperCase().split("\n");
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (stringArray[i2].indexOf("UUID") == -1) continue;
                return stringArray[i2].replaceAll("=", "").replaceAll("UUID", "").replaceAll(":", "").trim();
            }
        }
        return "";
    }

    public static boolean isUUIDMatch(String string) {
        if (StringUtils.isEmpty(string)) {
            return true;
        }
        String[] stringArray = string.toUpperCase().split(",");
        String string2 = GeneralUtils.getUUID().toUpperCase();
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ComparatorUtils.equals(string2, stringArray[i2].trim())) continue;
            return true;
        }
        return false;
    }

    public static final String[] getMacAddresses() throws IOException {
        Object object;
        String string = System.getProperty("os.name", "");
        String[] stringArray = null;
        if (string.startsWith("Windows")) {
            stringArray = new String[]{"ipconfig", "/all"};
        } else if (string.startsWith("AIX")) {
            stringArray = new String[]{"netstat", "-v"};
        } else if (string.startsWith("Solaris") || string.startsWith("SunOS")) {
            object = GeneralUtils.getFirstLineOfCommand(new String[]{"uname", "-n"});
            if (object != null) {
                stringArray = new String[]{"/usr/sbin/arp", object};
            }
        } else if (new File("/usr/sbin/lanscan").exists()) {
            stringArray = new String[]{"/usr/sbin/lanscan"};
        } else if (new File("/sbin/ifconfig").exists()) {
            stringArray = new String[]{"/sbin/ifconfig", "-a"};
        }
        object = new LocalCommandExecutorServiceImpl();
        ExecuteResult executeResult = object.executeCommand(stringArray, 5000L);
        return GeneralUtils.checkResult4Mac(executeResult);
    }

    private static String[] checkResult4Mac(ExecuteResult executeResult) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (executeResult.getExitCode() != -1 && executeResult.getExecuteOut() != null) {
            String[] stringArray = executeResult.getExecuteOut().split("\n");
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                string = GeneralUtils.parseMacAddress(stringArray[i2]);
                if (string == null || GeneralUtils.parseShort(string) == macMax || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isMacAddressMatch(String string) throws IOException {
        if (StringUtils.isBlank(string)) {
            return true;
        }
        string = string.replaceAll("-", ":");
        Object[] objectArray = GeneralUtils.getMacAddresses();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = objectArray[i2].toUpperCase();
        }
        String[] stringArray = string.split(",");
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            if (!ArrayUtils.contains(objectArray, stringArray[i3].toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public static String getMacAddress() throws IOException {
        return GeneralUtils.getMacAddresses()[0];
    }

    public static String[] getSystemPrinterNameArray() {
        ArrayList<String> arrayList = new ArrayList<String>();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, new HashPrintRequestAttributeSet());
        for (int i2 = 0; i2 < printServiceArray.length; ++i2) {
            arrayList.add(printServiceArray[i2].getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static short parseShort(String string) throws NullPointerException {
        string = string.toLowerCase();
        short s2 = 0;
        int n2 = 0;
        for (int i2 = 0; i2 < string.length() && n2 < hexStep; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= ascCode0 && c2 <= ascCode9) {
                s2 = (short)(s2 << hexStep);
                n2 = (byte)(n2 + 1);
                s2 = (short)(s2 | c2 - ascCode0);
                continue;
            }
            if (c2 < ascCodea || c2 > ascCodef) continue;
            n2 = (byte)(n2 + 1);
            s2 = (short)(s2 << hexStep);
            s2 = (short)(s2 | c2 - ascCodeW);
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFirstLineOfCommand(String[] stringArray) throws IOException {
        Process process = null;
        BufferedReader bufferedReader = null;
        try {
            process = Runtime.getRuntime().exec(stringArray);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 128);
            String string = bufferedReader.readLine();
            return string;
        }
        finally {
            if (process != null) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException iOException) {}
                try {
                    process.getOutputStream().close();
                }
                catch (IOException iOException) {}
                process.destroy();
            }
        }
    }

    private static String parseMacAddress(String string) {
        int n2;
        int n3;
        int n4 = string.indexOf("0x");
        if (n4 != -1 && string.indexOf("ETHER") != -1 && (n3 = string.indexOf(32, n4)) > n4 + 2) {
            return string.substring(n4, n3);
        }
        n3 = 0;
        if (string.indexOf(45) > -1) {
            string = string.replace('-', ':');
        }
        if ((n2 = string.lastIndexOf(58)) > string.length() - 2) {
            return null;
        }
        int n5 = Math.min(string.length(), n2 + 3);
        ++n3;
        int n6 = n2;
        while (n3 != macPara && n2 != -1 && n2 > 1) {
            --n2;
            if (n6 - (n2 = string.lastIndexOf(58, n2)) != 3 && n6 - n2 != 2) continue;
            ++n3;
            n6 = n2;
        }
        if (n3 == macPara && n2 > 1) {
            return string.substring(n2 - 2, n5).trim();
        }
        return null;
    }

    public static boolean isLetter(char c2) {
        return c2 >= ascCodeA && c2 <= ascCodeZ || c2 >= ascCodea && c2 <= ascCodez;
    }

    public static void copy(File file, File file2) throws IOException {
        File file3;
        if (file.isFile()) {
            GeneralUtils.copy(new FileInputStream(file), file.getName(), file2);
        } else if (file.isDirectory() && StableUtils.mkdirs(file3 = new File(file2, file.getName()))) {
            File[] fileArray = file.listFiles();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                GeneralUtils.copy(fileArray[i2], file3);
            }
        }
    }

    public static void copy(InputStream inputStream, String string, File file) throws IOException {
        File file2 = new File(file, string);
        StableUtils.makesureFileExist(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        GeneralUtils.copyBinaryTo(inputStream, fileOutputStream);
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
    }

    public static void copyBinaryTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[10240];
        while ((n2 = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n2);
        }
        outputStream.flush();
    }
}

