/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.FRFont;
import com.fr.general.GeneralContext;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public final class DefaultValues
implements Serializable,
Cloneable {
    private DateFormat timeFormat = null;
    private DateFormat dateTimeFormat = null;
    private FRFont frFont = null;

    DefaultValues() {
    }

    public DateFormat getTimeFormat() {
        if (this.timeFormat == null) {
            this.timeFormat = new SimpleDateFormat("HH:mm:ss");
        }
        return this.timeFormat;
    }

    public DateFormat getDateTimeFormat() {
        if (this.dateTimeFormat == null) {
            this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return this.dateTimeFormat;
    }

    public FRFont getFRFont() {
        if (this.frFont == null) {
            Locale locale = GeneralContext.getLocale();
            this.frFont = Locale.SIMPLIFIED_CHINESE.equals(locale) ? FRFont.getInstance("SimSun", 0, 9.0f) : (Locale.TRADITIONAL_CHINESE.equals(locale) || Locale.KOREAN.equals(locale) ? FRFont.getInstance("Dialog", 0, 9.0f) : (Locale.JAPANESE.equals(locale) || Locale.JAPAN.equals(locale) ? FRFont.getInstance("MS UI Gothic", 0, 9.0f) : FRFont.getInstance("Times New Roman", 0, 9.0f)));
        }
        try {
            return (FRFont)this.frFont.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this.frFont;
        }
    }

    public void setFRFont(FRFont fRFont) {
        this.frFont = fRFont;
    }
}

