/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.DateUtils;
import com.fr.general.doubleparse.NumberParser;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.stable.ArrayData;
import com.fr.stable.Primitive;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ComparatorUtils {
    private static final double NUMBER_FOR_PRECISE_COMPARE = 1.0E-9;
    private static Class[] commonIntNumberType = new Class[]{Integer.class, Long.class, Short.class, Byte.class};
    private static Class[] commonDecimalNumberType = new Class[]{Double.class, Float.class};

    private ComparatorUtils() {
    }

    public static int compare(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == null && object2 == null ? 0 : (object == null ? -1 : 1);
        }
        if (object instanceof Date || object2 instanceof Date) {
            long l2;
            Date date = DateUtils.object2Date(object, true);
            Date date2 = DateUtils.object2Date(object2, true);
            long l3 = date == null ? 0L : date.getTime();
            long l4 = l2 = date2 == null ? 0L : date2.getTime();
            return l3 < l2 ? -1 : (l3 == l2 ? 0 : 1);
        }
        if (object instanceof Number && !(object2 instanceof Number)) {
            object2 = ComparatorUtils.parseDouble(object2);
        }
        if (object2 instanceof Number && !(object instanceof Number)) {
            object = ComparatorUtils.parseDouble(object);
        }
        if (object instanceof Number && object2 instanceof Number) {
            return ComparatorUtils.compareNumber((Number)object, (Number)object2);
        }
        return object.toString().toLowerCase().compareTo(object2.toString().toLowerCase());
    }

    public static int compareSQLType(Object object, Object object2) throws IllegalArgumentException {
        if (object == null || object2 == null) {
            return ComparatorUtils.compareIfHasNull(object, object2);
        }
        if (object == Primitive.NULL || object2 == Primitive.NULL) {
            return ComparatorUtils.compareIfHasPrimitiveNull(object, object2);
        }
        if (object instanceof String && object2 instanceof String) {
            return ((String)object).compareTo((String)object2);
        }
        if (object instanceof String) {
            object = ComparatorUtils.parseDouble(object);
        }
        if (object2 instanceof String) {
            object2 = ComparatorUtils.parseDouble(object2);
        }
        if (object instanceof Number || object2 instanceof Number) {
            return ComparatorUtils.compareIfHasNumber(object, object2);
        }
        if (object instanceof Date || object2 instanceof Date) {
            return ComparatorUtils.compare(object, object2);
        }
        if (object instanceof Boolean || object2 instanceof Boolean) {
            return object.toString().compareTo(object2.toString());
        }
        throw new IllegalArgumentException("Unknown comparable type:" + object.getClass() + " " + object2.getClass());
    }

    private static int compareIfHasPrimitiveNull(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        return object == Primitive.NULL ? -1 : 1;
    }

    private static int compareIfHasNull(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        return object == null ? -1 : 1;
    }

    private static int compareIfHasNumber(Object object, Object object2) {
        if (!(object instanceof Number)) {
            return 1;
        }
        if (!(object2 instanceof Number)) {
            return -1;
        }
        return ComparatorUtils.compareNumber((Number)object, (Number)object2);
    }

    private static int compareNumber(Number number, Number number2) {
        if (number instanceof BigDecimal || number2 instanceof BigDecimal) {
            return ComparatorUtils.compareIfHasBigDecimal(number, number2);
        }
        if (number instanceof BigInteger || number2 instanceof BigInteger) {
            return ComparatorUtils.compareIfHasBigInteger(number, number2);
        }
        return ComparatorUtils.compare(number.doubleValue(), number2.doubleValue());
    }

    private static int compareIfHasBigDecimal(Number number, Number number2) {
        if (number instanceof BigDecimal && number2 instanceof BigDecimal) {
            return ((BigDecimal)number).compareTo((BigDecimal)number2);
        }
        if (number instanceof Double && ((Double)number).isInfinite()) {
            return number2 instanceof Double && ((Double)number2).isInfinite() ? 0 : 1;
        }
        if (number2 instanceof Double && ((Double)number2).isInfinite()) {
            return -1;
        }
        if (number instanceof BigDecimal) {
            return ComparatorUtils.compareBigDecimalWithOther((BigDecimal)number, number2);
        }
        return -ComparatorUtils.compareBigDecimalWithOther((BigDecimal)number2, number);
    }

    private static int compareBigDecimalWithOther(BigDecimal bigDecimal, Number number) {
        if (ComparatorUtils.isCommonIntNumber(number)) {
            return bigDecimal.compareTo(new BigDecimal(number.longValue()));
        }
        return bigDecimal.compareTo(new BigDecimal(number.toString()));
    }

    private static int compareIfHasBigInteger(Number number, Number number2) {
        if (number instanceof BigInteger && number2 instanceof BigInteger) {
            return ((BigInteger)number).compareTo((BigInteger)number2);
        }
        if (number instanceof BigInteger) {
            return ComparatorUtils.compareBigIntegerWithOther((BigInteger)number, number2);
        }
        return -ComparatorUtils.compareBigIntegerWithOther((BigInteger)number2, number);
    }

    private static int compareBigIntegerWithOther(BigInteger bigInteger, Number number) {
        if (ComparatorUtils.isCommonIntNumber(number)) {
            return bigInteger.compareTo(BigInteger.valueOf(number.longValue()));
        }
        return new BigDecimal(bigInteger).compareTo(new BigDecimal(number.toString()));
    }

    private static int compareLongValue(long l2, long l3) {
        if (l2 == l3) {
            return 0;
        }
        return l2 > l3 ? 1 : -1;
    }

    private static boolean isCommonIntNumber(Number number) {
        return ComparatorUtils.isBelongTypeArray(commonIntNumberType, number);
    }

    private static boolean isBelongTypeArray(Class[] classArray, Number number) {
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (!classArray[i2].isInstance(number)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCommonDecimalNumber(Number number) {
        return ComparatorUtils.isBelongTypeArray(commonDecimalNumberType, number);
    }

    private static Object parseDouble(Object object) {
        Object object2 = object;
        NumberParser numberParser = NumberParser.readJavaFormatString(object2.toString());
        if (numberParser != NumberParser.EMPTY) {
            object2 = new Double(numberParser.doubleValue());
        }
        return object2;
    }

    public static boolean isInteger(Object object) {
        if (object != null && (object.toString().startsWith("0") || object.toString().indexOf(".") != -1)) {
            return false;
        }
        try {
            Integer.parseInt(object.toString());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static int compare(double d2, double d3) {
        double d4 = d2 - d3;
        return Math.abs(d4) < 1.0E-9 ? 0 : (d4 > 0.0 ? 1 : -1);
    }

    public static int compare(Comparator comparator, Object object, Object object2) {
        if (comparator instanceof Collator && object != null && object2 != null) {
            return comparator.compare(object.toString().toLowerCase(), object2.toString().toLowerCase());
        }
        return ComparatorUtils.compare(object, object2);
    }

    public static boolean arg1InArg2(Object object, Object object2) {
        if (object2 instanceof ArrayData) {
            ArrayData arrayData = (ArrayData)object2;
            boolean bl = false;
            int n2 = arrayData.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (arrayData.elementAt(i2) instanceof JSONArray) {
                    JSONArray jSONArray = (JSONArray)arrayData.elementAt(i2);
                    int n3 = jSONArray.length();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        try {
                            if (!ComparatorUtils.equals(object, jSONArray.get(i3))) continue;
                            bl = true;
                            break;
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    if (bl) break;
                }
                if (!ComparatorUtils.equals(object, arrayData.elementAt(i2))) continue;
                bl = true;
                break;
            }
            return bl;
        }
        if (object instanceof String && object2 instanceof String) {
            return object2.toString().indexOf(object.toString()) >= 0;
        }
        if (object instanceof Number && object2 instanceof Number) {
            return (Double)ComparatorUtils.parseDouble(object2) >= (Double)ComparatorUtils.parseDouble(object);
        }
        try {
            if (object instanceof Number && object2 instanceof String || object2 instanceof Number && object instanceof String) {
                return ComparatorUtils.arg1InArg2(object.toString(), object2.toString()) || ComparatorUtils.arg1InArg2(Double.valueOf(object.toString()), Double.valueOf(object2.toString()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return ComparatorUtils.equals(object, object2);
    }

    public static boolean equalsFast(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return object == null && object2 == null;
        }
        return object.equals(object2);
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return object == null && object2 == null;
        }
        if (object instanceof String && object2 instanceof String) {
            return object.equals(object2);
        }
        if (object instanceof Date || object2 instanceof Date) {
            return ComparatorUtils.compare(object, object2) == 0;
        }
        try {
            if (object instanceof String && object2 instanceof BigDecimal) {
                return ((BigDecimal)object2).compareTo(new BigDecimal((String)object)) == 0;
            }
            if (object2 instanceof String && object instanceof BigDecimal) {
                return ((BigDecimal)object).compareTo(new BigDecimal((String)object2)) == 0;
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (object instanceof Number && !(object2 instanceof Number) && !((object2 = ComparatorUtils.parseDouble(object2)) instanceof Number)) {
            return false;
        }
        if (object2 instanceof Number && !(object instanceof Number) && !((object = ComparatorUtils.parseDouble(object)) instanceof Number)) {
            return false;
        }
        if (object instanceof Number && object2 instanceof Number) {
            return ComparatorUtils.compareNumber((Number)object, (Number)object2) == 0;
        }
        if (object instanceof Boolean || object2 instanceof Boolean) {
            return object.toString().equals(object2.toString());
        }
        if (object instanceof Shape && object2 instanceof Shape) {
            return ComparatorUtils.equals((Shape)object, (Shape)object2);
        }
        if (object.getClass().isArray() && object2.getClass().isArray()) {
            int n2;
            int n3 = Array.getLength(object);
            if (n3 != (n2 = Array.getLength(object2))) {
                return false;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                if (ComparatorUtils.equals(Array.get(object, i2), Array.get(object2, i2))) continue;
                return false;
            }
            return true;
        }
        if (object instanceof List && object2 instanceof List) {
            if (((List)object).size() != ((List)object2).size()) {
                return false;
            }
            for (int i3 = 0; i3 < ((List)object).size(); ++i3) {
                if (ComparatorUtils.equals(((List)object).get(i3), ((List)object2).get(i3))) continue;
                return false;
            }
            return true;
        }
        if (object instanceof Set && object2 instanceof Set) {
            if (((Set)object).size() != ((Set)object2).size()) {
                return false;
            }
            Iterator iterator = ((Set)object).iterator();
            Iterator iterator2 = ((Set)object2).iterator();
            while (iterator.hasNext()) {
                if (ComparatorUtils.equals(iterator.next(), iterator2.next())) continue;
                return false;
            }
            return true;
        }
        return object.equals(object2);
    }

    public static boolean equals(Shape shape, Shape shape2) {
        if (shape != null) {
            Shape shape3;
            Shape shape4;
            if (shape2 == null) {
                return false;
            }
            if (!shape.getClass().getName().equals(shape2.getClass().getName())) {
                return false;
            }
            if (shape instanceof Arc2D && shape2 instanceof Arc2D) {
                shape4 = (Arc2D)shape;
                shape3 = (Arc2D)shape2;
                if (((Arc2D)shape4).getAngleExtent() != ((Arc2D)shape3).getAngleExtent() || ((Arc2D)shape4).getAngleStart() != ((Arc2D)shape3).getAngleStart() || ((Arc2D)shape4).getArcType() != ((Arc2D)shape3).getArcType() || ((RectangularShape)shape4).getX() != ((RectangularShape)shape3).getX() || ((RectangularShape)shape4).getY() != ((RectangularShape)shape3).getY() || ((RectangularShape)shape4).getWidth() != ((RectangularShape)shape3).getWidth() || ((RectangularShape)shape4).getHeight() != ((RectangularShape)shape3).getHeight()) {
                    return false;
                }
            }
            if (shape instanceof Rectangle2D && shape2 instanceof Rectangle2D) {
                shape4 = (Rectangle2D)shape;
                shape3 = (Rectangle2D)shape2;
                if (((RectangularShape)shape4).getX() != ((RectangularShape)shape3).getX() || ((RectangularShape)shape4).getY() != ((RectangularShape)shape3).getY() || ((RectangularShape)shape4).getWidth() != ((RectangularShape)shape3).getWidth() || ((RectangularShape)shape4).getHeight() != ((RectangularShape)shape3).getHeight()) {
                    return false;
                }
            }
            if (shape instanceof GeneralPath && shape2 instanceof GeneralPath) {
                shape4 = (GeneralPath)shape;
                shape3 = (GeneralPath)shape2;
                if (((Path2D)shape4).getWindingRule() != ((Path2D)shape3).getWindingRule()) {
                    return false;
                }
            }
        }
        if (shape2 == null) {
            return true;
        }
        return true;
    }

    public static boolean equals_exactly(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == null && object2 == null;
        }
        if (object instanceof Date && object2 instanceof Date) {
            return ((Date)object).getTime() == ((Date)object2).getTime();
        }
        if (object instanceof Number && object2 instanceof Number) {
            return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
        }
        return object.equals(object2);
    }

    public static boolean tableDataColumnNameEquals(String string, String string2) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        return string.toLowerCase().equals(string2.toLowerCase());
    }

    public static boolean equals(Iterator iterator, Iterator iterator2) {
        if (iterator == null) {
            iterator = Collections.EMPTY_LIST.iterator();
        }
        if (iterator2 == null) {
            iterator2 = Collections.EMPTY_LIST.iterator();
        }
        boolean bl = iterator.hasNext();
        boolean bl2 = iterator2.hasNext();
        while (bl && bl2) {
            if (!ComparatorUtils.equals(iterator.next(), iterator2.next())) {
                return false;
            }
            bl = iterator.hasNext();
            bl2 = iterator2.hasNext();
        }
        return bl == bl2;
    }
}

