/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service.ldap;

import com.fr.fs.FSConfig;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSLoadGetLdapAttrsAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        FSConfig fSConfig = FSConfig.getInstance();
        hashMap.put("ldapUrl", fSConfig.getLdapUrl());
        hashMap.put("ldapSearchBase", fSConfig.getLdapSearchBase());
        hashMap.put("principalSuffix", fSConfig.getPrincipalSuffix());
        hashMap.put("ldapSystemName", fSConfig.getLdapSystemName());
        hashMap.put("ldapSystemPassword", fSConfig.getLdapSystemPassword());
        String string = fSConfig.getReferral();
        String string2 = fSConfig.getContextFactory();
        String string3 = fSConfig.getAuthentication();
        hashMap.put("referral", this.getReferralInteger(string) + "");
        hashMap.put("contextFactory", this.getContextFactoryInteger(string2) + "");
        hashMap.put("authentication", this.getAuthentication(string3) + "");
        JSONObject jSONObject = new JSONObject(hashMap);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.write(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    private int getReferralInteger(String string) {
        if (ComparatorUtils.equals("follow", string)) {
            return 1;
        }
        if (ComparatorUtils.equals("ignore", string)) {
            return 2;
        }
        if (ComparatorUtils.equals("throw", string)) {
            return 3;
        }
        return 1;
    }

    private int getContextFactoryInteger(String string) {
        if (ComparatorUtils.equals("com.sun.jndi.ldap.LdapCtxFactory", string)) {
            return 1;
        }
        if (ComparatorUtils.equals("com.sun.jndi.ldap.connect.pool", string)) {
            return 2;
        }
        return 1;
    }

    private int getAuthentication(String string) {
        if (ComparatorUtils.equals("simple", string)) {
            return 1;
        }
        if (ComparatorUtils.equals("strong", string)) {
            return 2;
        }
        if (ComparatorUtils.equals("none", string)) {
            return 3;
        }
        return 1;
    }

    public String getCMD() {
        return "loginLdapAttrs";
    }
}

