/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service.ldap;

import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSLoadFetchLdapBaseDNsAction
extends ActionNoSessionCMD {
    private static LdapContext context;
    private static List<String> ldapDNList;
    private static String loginLdapUrl;
    private static String referral;
    private static String contextFactory;

    public String getCMD() {
        return "fetchLdapBaseDNs";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        loginLdapUrl = WebUtils.getHTTPRequestParameter(httpServletRequest, "loginLdapUrl");
        referral = WebUtils.getHTTPRequestParameter(httpServletRequest, "referral");
        contextFactory = WebUtils.getHTTPRequestParameter(httpServletRequest, "contextFactory");
        loginLdapUrl = loginLdapUrl.trim();
        referral = referral.trim();
        contextFactory = contextFactory.trim();
        this.fetchLdapBaseDNs();
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("DNList", ldapDNList);
        printWriter.print(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    private void fetchLdapBaseDNs() throws Exception {
        Attributes attributes;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.provider.url", loginLdapUrl);
        hashtable.put("java.naming.factory.initial", contextFactory);
        hashtable.put("java.naming.referral", referral);
        context = new InitialLdapContext(hashtable, null);
        String string = "";
        String string2 = "(objectclass=*)";
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(0);
        NamingEnumeration<SearchResult> namingEnumeration = context.search(string, string2, searchControls);
        ldapDNList = new ArrayList<String>();
        if (namingEnumeration.hasMore() && (attributes = namingEnumeration.next().getAttributes()) != null) {
            Attribute attribute = attributes.get("namingContexts");
            NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
            while (namingEnumeration2.hasMore()) {
                ldapDNList.add((String)namingEnumeration2.next());
            }
        }
        context.close();
    }
}

