/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.data.dao.DAOBean;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSetAuthGetEntryRolesAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasPrivilegeModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "entryId");
        if (StringUtils.isEmpty(string)) {
            return;
        }
        JSONArray jSONArray = new JSONArray();
        JSONArray jSONArray2 = UserControl.getInstance().getAllDepAndCRoleInfo(l2);
        this.addCompanyRole(jSONArray, string, jSONArray2);
        this.addCustomRole(jSONArray, string, jSONArray2);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(jSONArray);
        printWriter.flush();
        printWriter.close();
    }

    public String getCMD() {
        return "auth_getEntryRoles";
    }

    private void addCompanyRole(JSONArray jSONArray, String string, JSONArray jSONArray2) throws Exception {
        List list = CompanyRoleControl.getInstance().getAllCompanyRole();
        for (CompanyRole companyRole : list) {
            if (!this.hasDepOrCRolePrivilege(companyRole, jSONArray2)) continue;
            List list2 = CompanyRoleControl.getInstance().getAllEntryPrivileges(companyRole.getId());
            for (EntryTypeAndID entryTypeAndID : list2) {
                if (!ComparatorUtils.equals(string, entryTypeAndID.getType() + "" + entryTypeAndID.getId())) continue;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("view", entryTypeAndID.getView());
                jSONObject.put("design", entryTypeAndID.getAuthorized());
                jSONObject.put("edit", entryTypeAndID.getEdit());
                jSONObject.put("departmentId", companyRole.getDepartmentId());
                jSONObject.put("postId", companyRole.getPostId());
                jSONObject.put("id", "10086" + companyRole.getPostId());
                jSONArray.put(jSONObject);
            }
        }
    }

    private void addCustomRole(JSONArray jSONArray, String string, JSONArray jSONArray2) throws Exception {
        List list = CustomRoleControl.getInstance().getAllCustomRole();
        for (CustomRole customRole : list) {
            if (!this.hasDepOrCRolePrivilege(customRole, jSONArray2)) continue;
            List list2 = CustomRoleControl.getInstance().getAllEntryPrivileges(customRole.getId());
            for (EntryTypeAndID entryTypeAndID : list2) {
                if (!ComparatorUtils.equals(string, entryTypeAndID.getType() + "" + entryTypeAndID.getId())) continue;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("view", entryTypeAndID.getView());
                jSONObject.put("design", entryTypeAndID.getAuthorized());
                jSONObject.put("edit", entryTypeAndID.getEdit());
                jSONObject.put("id", customRole.getId());
                jSONArray.put(jSONObject);
            }
        }
    }

    private boolean hasDepOrCRolePrivilege(DAOBean dAOBean, JSONArray jSONArray) throws Exception {
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            if (!jSONObject.has("id")) continue;
            if (jSONObject.has("departmentid")) {
                long l2 = jSONObject.getLong("departmentid");
                if (!(dAOBean instanceof CompanyRole) || l2 != ((CompanyRole)dAOBean).getDepartmentId()) continue;
                return true;
            }
            String string2 = string = jSONObject.has("text") ? jSONObject.getString("text") : "";
            if (!(dAOBean instanceof CustomRole) || !ComparatorUtils.equals(string, ((CustomRole)dAOBean).getRolename())) continue;
            return true;
        }
        return false;
    }
}

