/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.CustomRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CustomRoleEntryPrivilege;
import com.fr.fs.base.entity.CustomRoleModulePrivilege;
import com.fr.fs.base.entity.CustomRoleTemplatePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.dao.tabledata.TableDataCustomRoleDAO;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSetAuthGetCustomRoleAuthAction
extends ActionNoSessionCMD {
    @Override
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasPrivilegeModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "name");
        long l3 = Long.valueOf(WebUtils.getHTTPRequestParameter(httpServletRequest, "id"));
        JSONObject jSONObject = this.getCustomRolePrivileges(l3, string, l2);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    public JSONObject getCustomRolePrivileges(long l2, String string, long l3) throws Exception {
        JSONObject jSONObject = new JSONObject();
        if (l2 <= -1000L) {
            jSONObject.put("users", CustomRoleControl.getInstance().getUsersInfo(l2));
            jSONObject.put("reports", this.getSyncRoleEntryPrivilegesJO(string, l3) + "");
            jSONObject.put("modules", this.getSyncRoleModulePrivilegesJO(string, l3) + "");
            jSONObject.put("depandcroles", this.getSyncDepAndCRolePrivileges(string, l3));
            jSONObject.put("templates", this.getSyncRoleTemplatePrivilegesJO(string, l3) + "");
            jSONObject.put("dataconnections", this.getSyncRoleDataConnectionsPrivileges(string, l3));
        } else {
            jSONObject.put("users", CustomRoleControl.getInstance().getUsersInfo(l2));
            jSONObject.put("reports", this.getAllEntryPrivilege(l2, l3) + "");
            jSONObject.put("modules", this.getAllModulePrivilege(l2, l3) + "");
            jSONObject.put("depandcroles", this.getAllDepAndCRolePrivilege(l2, l3));
            jSONObject.put("templates", this.getAllTemplatePrivileges(l2, l3) + "");
            jSONObject.put("dataconnections", this.getAllDataConnectionPrivileges(l2, l3));
        }
        Iterator<String> iterator = PlateFactory.plateNameIterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            jSONObject.put(string2, CustomRoleControl.getInstance().getAllPlatePrivileges(l2, string2));
        }
        return jSONObject;
    }

    private List getAllEntryPrivilege(long l2, long l3) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List list = CustomRoleControl.getInstance().getAllEntryPrivileges(l2);
        Set set = UserControl.getInstance().getAllEntryPrivileges(l3);
        for (EntryTypeAndID entryTypeAndID : list) {
            if (l3 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !this.hasEntryPrivilege((Set<EntryTypeAndID>)set, entryTypeAndID)) continue;
            linkedList.add(entryTypeAndID.toJSONObject());
        }
        return linkedList;
    }

    private List getAllModulePrivilege(long l2, long l3) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List list = CustomRoleControl.getInstance().getAllModulePrivileges(l2);
        Set set = UserControl.getInstance().getAllModulePrivileges(l3);
        for (RoleModulePrivilege roleModulePrivilege : list) {
            if (l3 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !this.hasModulePrivilege(set, roleModulePrivilege)) continue;
            linkedList.add(roleModulePrivilege.toJSONObject());
        }
        return linkedList;
    }

    private boolean hasEntryPrivilege(Set<EntryTypeAndID> set, EntryTypeAndID entryTypeAndID) {
        for (EntryTypeAndID entryTypeAndID2 : set) {
            if (entryTypeAndID2.getView() == 0L || entryTypeAndID2.getType() != entryTypeAndID.getType() || entryTypeAndID2.getId() != entryTypeAndID.getId()) continue;
            return true;
        }
        return false;
    }

    private boolean hasEntryPrivilege(Set<EntryTypeAndID> set, CustomRoleEntryPrivilege customRoleEntryPrivilege) {
        for (EntryTypeAndID entryTypeAndID : set) {
            if (entryTypeAndID.getView() == 0L || entryTypeAndID.getType() != customRoleEntryPrivilege.getType() || entryTypeAndID.getId() != customRoleEntryPrivilege.getEntryid()) continue;
            return true;
        }
        return false;
    }

    private boolean hasModulePrivilege(Set<RoleModulePrivilege> set, RoleModulePrivilege roleModulePrivilege) {
        for (RoleModulePrivilege roleModulePrivilege2 : set) {
            if (roleModulePrivilege2.getModuleid() != roleModulePrivilege.getModuleid()) continue;
            return true;
        }
        return false;
    }

    private List getAllDepAndCRolePrivilege(long l2, long l3) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        List list = CustomRoleControl.getInstance().getAllDepAndCRolePrivileges(l2, false);
        JSONArray jSONArray = UserControl.getInstance().getAllDepAndCRoleInfo(l3);
        LinkedList<String> linkedList2 = new LinkedList<String>();
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            if (jSONObject.has("departmentid")) {
                linkedList2.add("1" + jSONObject.getLong("id"));
                continue;
            }
            linkedList2.add("2" + jSONObject.getLong("id"));
        }
        for (String string : list) {
            if (l3 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !linkedList2.contains(string)) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    private List getAllTemplatePrivileges(long l2, long l3) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List list = CustomRoleControl.getInstance().getAllTemplatePrivileges(l2);
        Set set = UserControl.getInstance().getAllTemplatePrivileges(l3);
        for (RoleTemplatePrivilege roleTemplatePrivilege : list) {
            if (l3 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !FSPrivilegeTools.getInstance().hasPageOrWritePrivilege(roleTemplatePrivilege.getPath(), set)) continue;
            linkedList.add(roleTemplatePrivilege.toJSONObject());
        }
        return linkedList;
    }

    private List getAllDataConnectionPrivileges(long l2, long l3) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        List list = CustomRoleControl.getInstance().getAllDataConnectionPrivileges(l2);
        Set set = UserControl.getInstance().getAllDataConnectionPrivileges(l3);
        for (String string : list) {
            if (l3 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !set.contains(string)) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    private List getSyncRoleEntryPrivilegesJO(String string, long l2) throws Exception {
        Set set = TableDataCustomRoleDAO.getInstance().getEntryPrivileges(string);
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        Set set2 = UserControl.getInstance().getAllEntryPrivileges(l2);
        for (CustomRoleEntryPrivilege customRoleEntryPrivilege : set) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !this.hasEntryPrivilege((Set<EntryTypeAndID>)set2, customRoleEntryPrivilege)) continue;
            arrayList.add(EntryTypeAndID.getInstance(customRoleEntryPrivilege.getType(), customRoleEntryPrivilege.getEntryid(), customRoleEntryPrivilege.getView(), customRoleEntryPrivilege.getAuthorized(), customRoleEntryPrivilege.getEdit()).toJSONObject());
        }
        return arrayList;
    }

    private List getSyncRoleModulePrivilegesJO(String string, long l2) throws Exception {
        Set set = TableDataCustomRoleDAO.getInstance().getModulePrivileges(string);
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        Set set2 = UserControl.getInstance().getAllModulePrivileges(l2);
        for (CustomRoleModulePrivilege customRoleModulePrivilege : set) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !this.hasModulePrivilege(set2, customRoleModulePrivilege)) continue;
            arrayList.add(customRoleModulePrivilege.toJSONObject());
        }
        return arrayList;
    }

    private List getSyncDepAndCRolePrivileges(String string, long l2) throws Exception {
        Set set = TableDataCustomRoleDAO.getInstance().getDepAndCrolePrivileges(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        JSONArray jSONArray = UserControl.getInstance().getAllDepAndCRoleInfo(l2);
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            if (jSONObject.has("departmentid")) {
                linkedList.add("1" + jSONObject.getLong("departmentid"));
                continue;
            }
            linkedList.add("2" + jSONObject.getLong("id"));
        }
        for (CustomRoleDepAndCRolePrivilege customRoleDepAndCRolePrivilege : set) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !linkedList.contains(customRoleDepAndCRolePrivilege.getType() + "" + customRoleDepAndCRolePrivilege.getDeporcroleid())) continue;
            arrayList.add(customRoleDepAndCRolePrivilege.getType() + "" + customRoleDepAndCRolePrivilege.getDeporcroleid());
        }
        return arrayList;
    }

    private List getSyncRoleTemplatePrivilegesJO(String string, long l2) throws Exception {
        Set set = TableDataCustomRoleDAO.getInstance().getTemplatePrivileges(string);
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        Set set2 = UserControl.getInstance().getAllTemplatePrivileges(l2);
        for (CustomRoleTemplatePrivilege customRoleTemplatePrivilege : set) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !FSPrivilegeTools.getInstance().hasPageOrWritePrivilege(customRoleTemplatePrivilege.getPath(), set2)) continue;
            arrayList.add(customRoleTemplatePrivilege.toJSONObject());
        }
        return arrayList;
    }

    private List getSyncRoleDataConnectionsPrivileges(String string, long l2) throws Exception {
        Set set = TableDataCustomRoleDAO.getInstance().getDataConnectionPrivileges(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set2 = UserControl.getInstance().getAllDataConnectionPrivileges(l2);
        for (String string2 : set) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !set2.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public String getCMD() {
        return "auth_getsroleauth";
    }
}

