/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.FSConfig;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.CompanyRoleCache;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSetAuthGetCompanyRoleAuthAction
extends ActionNoSessionCMD {
    @Override
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2;
        long l3 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasPrivilegeModulePrivilege(l3)) {
            throw new NoPrivilegeException();
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "id");
        if (StringUtils.isEmpty(string)) {
            String string2;
            long l4;
            long l5 = Long.valueOf(WebUtils.getHTTPRequestParameter(httpServletRequest, "departmentId"));
            l2 = this.getRoleId(l5, l4 = StringUtils.isEmpty(string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "postId")) ? CompanyRoleControl.getInstance().getPostAllID() : Long.valueOf(string2).longValue());
            if (l2 < 0L) {
                CompanyRole companyRole = new CompanyRole(l4, l5, "");
                CompanyRoleControl.getInstance().addCompanyRole(companyRole);
                l2 = companyRole.getId();
            }
        } else {
            l2 = Long.valueOf(string);
        }
        JSONObject jSONObject = this.getCompanyRolePrivileges(l2, l3);
        printWriter.print(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    public JSONObject getCompanyRolePrivileges(long l2, long l3) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("reports", this.getAllEntryPrivilege(l2, l3) + "");
        jSONObject.put("modules", this.getAllModulePrivilege(l2, l3) + "");
        jSONObject.put("depandcroles", this.getAllDepAndCRolePrivilege(l2, l3));
        jSONObject.put("templates", this.getAllTemplatePrivileges(l2, l3) + "");
        jSONObject.put("dataconnections", this.getAllDataConnectionPrivileges(l2, l3));
        Iterator<String> iterator = PlateFactory.plateNameIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            jSONObject.put(string, CompanyRoleCache.getAllPrivilegesWithPlateName(l2, string));
        }
        return jSONObject;
    }

    private List getAllEntryPrivilege(long l2, long l3) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List list = CompanyRoleControl.getInstance().getAllEntryPrivileges(l2);
        Set set = UserControl.getInstance().getAllEntryPrivileges(l3);
        for (EntryTypeAndID entryTypeAndID : list) {
            if (l3 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !this.hasEntryPrivilege(set, entryTypeAndID)) continue;
            linkedList.add(entryTypeAndID.toJSONObject());
        }
        return linkedList;
    }

    private List getAllModulePrivilege(long l2, long l3) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List list = CompanyRoleControl.getInstance().getAllModulePrivileges(l2);
        Set set = UserControl.getInstance().getAllModulePrivileges(l3);
        for (RoleModulePrivilege roleModulePrivilege : list) {
            if (l3 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !this.hasModulePrivilege(set, roleModulePrivilege)) continue;
            linkedList.add(roleModulePrivilege.toJSONObject());
        }
        return linkedList;
    }

    private boolean hasEntryPrivilege(Set<EntryTypeAndID> set, EntryTypeAndID entryTypeAndID) {
        for (EntryTypeAndID entryTypeAndID2 : set) {
            if (entryTypeAndID2.getView() == 0L || entryTypeAndID2.getType() != entryTypeAndID.getType() || entryTypeAndID2.getId() != entryTypeAndID.getId()) continue;
            return true;
        }
        return false;
    }

    private boolean hasModulePrivilege(Set<RoleModulePrivilege> set, RoleModulePrivilege roleModulePrivilege) {
        for (RoleModulePrivilege roleModulePrivilege2 : set) {
            if (roleModulePrivilege2.getModuleid() != roleModulePrivilege.getModuleid()) continue;
            return true;
        }
        return false;
    }

    private List getAllDepAndCRolePrivilege(long l2, long l3) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        List list = CompanyRoleControl.getInstance().getAllDepAndCRolePrivileges(l2);
        JSONArray jSONArray = UserControl.getInstance().getAllDepAndCRoleInfo(l3);
        LinkedList<String> linkedList2 = new LinkedList<String>();
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            if (jSONObject.has("departmentid")) {
                linkedList2.add("1" + jSONObject.getLong("id"));
                continue;
            }
            linkedList2.add("2" + jSONObject.getLong("id"));
        }
        for (String string : list) {
            if (l3 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !linkedList2.contains(string)) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    private List getAllTemplatePrivileges(long l2, long l3) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List list = CompanyRoleControl.getInstance().getAllTemplatePrivileges(l2);
        Set set = UserControl.getInstance().getAllTemplatePrivileges(l3);
        for (RoleTemplatePrivilege roleTemplatePrivilege : list) {
            if (l3 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !FSPrivilegeTools.getInstance().hasPageOrWritePrivilege(roleTemplatePrivilege.getPath(), set)) continue;
            linkedList.add(roleTemplatePrivilege.toJSONObject());
        }
        return linkedList;
    }

    private List getAllDataConnectionPrivileges(long l2, long l3) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        List list = CompanyRoleControl.getInstance().getAllDataConnectionPrivileges(l2);
        Set set = UserControl.getInstance().getAllDataConnectionPrivileges(l3);
        for (String string : list) {
            if (l3 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !set.contains(string)) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    @Override
    public String getCMD() {
        return "auth_getjroleauth";
    }

    private long getRoleId(long l2, long l3) throws Exception {
        Long[] longArray = new Long[]{l2};
        List<CompanyRole> list = l3 == CompanyRoleControl.getInstance().getPostAllID() || l2 == CompanyRoleControl.getInstance().getDepartmentAllID() ? FSConfig.getInstance().getControl().getCompanyRoleDAO().findByPostAndDepartment(l3, longArray) : CompanyRoleControl.getInstance().getJRole(l2, l3);
        if (list == null || list.isEmpty()) {
            return -1L;
        }
        CompanyRole companyRole = list.get(0);
        for (CompanyRole companyRole2 : list) {
            if (companyRole2.getDepartmentId() != l2 || companyRole2.getPostId() != l3) continue;
            companyRole = companyRole2;
            break;
        }
        return companyRole.getId();
    }
}

