/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.FRContext;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.web.FSConstants;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSetAuthGetAllModuleAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasPrivilegeModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        JSONArray jSONArray = ModuleControl.getInstance().getAuthorizedModuleItems(l2);
        this.createI18NModuleName(jSONArray, httpServletRequest.getLocale());
        printWriter.print(jSONArray);
        printWriter.flush();
        printWriter.close();
    }

    public String getCMD() {
        return "auth_getallmodules";
    }

    private void createI18NModuleName(JSONArray jSONArray, Locale locale) throws JSONException {
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            int n2 = jSONObject.optInt("id");
            if (this.needRemoveWhenUS(locale, n2)) {
                jSONArray.remove(i2);
                --i2;
                continue;
            }
            String string = Inter.getLocText(FSConstants.MODULEID.I18NMAP.get(n2).toString(), locale);
            if (string == null) continue;
            jSONObject.put("text", string);
        }
    }

    private boolean needRemoveWhenUS(Locale locale, int n2) {
        return FRContext.isShouldForceEnglish() && (n2 == 7 || n2 == 13);
    }
}

