/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.cache.DepartmentCache;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSetAuthGetAllCompanyRoleAction
extends ActionNoSessionCMD {
    @Override
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONArray jSONArray;
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasPrivilegeModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        ArrayList<CompanyRole> arrayList = new ArrayList();
        if (FSConfig.getInstance().isGradeAuthority()) {
            jSONArray = UserControl.getInstance().getAllDepAndCRoleInfo(l2);
            int n2 = jSONArray.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                if (!jSONObject.has("departmentid")) continue;
                long l3 = jSONObject.getLong("id");
                CompanyRole companyRole = CompanyRoleControl.getInstance().getJRole(l3);
                arrayList.add(companyRole);
            }
        } else {
            arrayList = CompanyRoleControl.getInstance().getAllCompanyRole();
        }
        jSONArray = new JSONArray();
        this.getAllCompanyRole(arrayList, jSONArray);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(jSONArray);
        printWriter.flush();
        printWriter.close();
    }

    @Override
    public String getCMD() {
        return "auth_getcompanyrole";
    }

    public void getAllCompanyRole(List<CompanyRole> list, JSONArray jSONArray) throws Exception {
        for (CompanyRole companyRole : list) {
            Department department = DepartmentCache.getDepartment(companyRole.getDepartmentId());
            Post post = PostControl.getInstance().getPost(companyRole.getPostId());
            if (department == null || post == null || post.getId() == CompanyRoleControl.getInstance().getPostAllID() || department.getId() == CompanyRoleControl.getInstance().getDepartmentAllID()) continue;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("departmentName", department.getName());
            jSONObject.put("postName", post.getPostname());
            jSONObject.put("departmentId", department.getId() + "");
            jSONObject.put("departmentPId", department.getPid() + "");
            jSONObject.put("postId", post.getId() + "");
            jSONArray.put(jSONObject);
            while (department.getPid() > 0L) {
                department = DepartmentCache.getDepartment(department.getPid());
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("departmentName", department.getName());
                jSONObject2.put("departmentId", department.getId() + "");
                jSONObject2.put("departmentPId", department.getPid() + "");
                jSONArray.put(jSONObject2);
            }
        }
    }
}

