/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.FRContext;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.FSSetAuthGetAllCompanyRoleAction;
import com.fr.fs.web.service.FSSetAuthGetCompanyRoleAuthAction;
import com.fr.fs.web.service.FSSetAuthGetCustomRoleAuthAction;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.web.Browser;
import com.fr.web.core.ActionNoSessionCMD;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSetAuthExportRolePrivileges
extends ActionNoSessionCMD {
    public String getCMD() {
        return "export_role_privileges";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (l2 != UserControl.getInstance().getSuperManagerID()) {
            throw new NoPrivilegeException();
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("companyRoles", this.getAllCompanyRoles());
            jSONObject.put("customRolePrivileges", this.getAllCustomRolePrivileges());
            jSONObject.put("companyRolePrivileges", this.getAllCompanyRolePrivileges());
            this.sendFile(httpServletRequest, httpServletResponse, jSONObject.toString().getBytes());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    protected void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, byte[] byArray) throws Exception {
        String string = "FSPrivileges";
        Browser browser = Browser.resolve(httpServletRequest);
        string = browser.getEncodedFileName4Download(string);
        httpServletResponse.setContentType("text/plain");
        httpServletResponse.setHeader("extension", "data");
        httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + ".data");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            servletOutputStream.write(byArray);
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JSONArray getAllCompanyRoles() throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = CompanyRoleControl.getInstance().getAllCompanyRole();
        new FSSetAuthGetAllCompanyRoleAction().getAllCompanyRole(list, jSONArray);
        return jSONArray;
    }

    public JSONArray getAllCompanyRolePrivileges() throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = CompanyRoleControl.getInstance().getAllCompanyRole();
        FSSetAuthGetCompanyRoleAuthAction fSSetAuthGetCompanyRoleAuthAction = new FSSetAuthGetCompanyRoleAuthAction();
        for (CompanyRole companyRole : list) {
            JSONObject jSONObject = fSSetAuthGetCompanyRoleAuthAction.getCompanyRolePrivileges(companyRole.getId(), UserControl.getInstance().getSuperManagerID());
            jSONObject.put("departmentId", companyRole.getDepartmentId());
            jSONObject.put("postId", companyRole.getPostId());
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    public JSONArray getAllCustomRolePrivileges() throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = CustomRoleControl.getInstance().getAllCustomRole();
        FSSetAuthGetCustomRoleAuthAction fSSetAuthGetCustomRoleAuthAction = new FSSetAuthGetCustomRoleAuthAction();
        for (CustomRole customRole : list) {
            JSONObject jSONObject = fSSetAuthGetCustomRoleAuthAction.getCustomRolePrivileges(customRole.getId(), customRole.getRolename(), UserControl.getInstance().getSuperManagerID());
            jSONObject.put("roleId", customRole.getId());
            jSONObject.put("roleName", customRole.getRolename());
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }
}

