/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.BaseXMLUtils;
import com.fr.base.Parameter;
import com.fr.base.Utils;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.UserCache;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.dao.AnalysisEntryDAO;
import com.fr.fs.dao.FileEntryDAO;
import com.fr.fs.privilege.base.FSPrivilegeVote;
import com.fr.fs.schedule.ScheduleLinkOutput;
import com.fr.fs.schedule.ScheduleLinkOutputDAO;
import com.fr.fs.schedule.ScheduleUserAndCPRFile;
import com.fr.fs.schedule.entry.ReportletEntry;
import com.fr.fs.web.FSOutputReportlet;
import com.fr.fs.web.FSReportlet;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ADHOCInitAnalysisPanelAction;
import com.fr.fs.web.service.FSEntryService;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.RegistEditionException;
import com.fr.general.VT4FR;
import com.fr.stable.Actor;
import com.fr.stable.ActorFactory;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.xml.XMLFileReader;
import com.fr.web.core.A.H;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.platform.entry.AnalysisEntry;
import com.fr.web.platform.entry.Entry;
import com.fr.web.platform.entry.FileEntry;
import com.fr.web.platform.entry.ReportProcessEntry;
import com.fr.web.platform.entry.URLEntry;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSMainEntryReportAction
extends ActionNoSessionCMD {
    protected static boolean supportFS = true;
    private int fivehundred = 500;

    public String getCMD() {
        return "entry_report";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (l2 == ServiceUtils.noAuthenticatedUser) {
            FSPrivilegeVote.FS_AUTH_ERROR.action(httpServletRequest, httpServletResponse);
        }
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "id");
        EntryTypeAndID entryTypeAndID = FSEntryService.dealWithEntryInfo(string);
        String string2 = this.dealWithEntryResourceRequest(httpServletRequest, httpServletResponse, ServiceUtils.getCurrentUserID(httpServletRequest), entryTypeAndID.getType(), entryTypeAndID.getId());
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        if (StringUtils.isNotEmpty(string2)) {
            printWriter.write(string2);
        }
        printWriter.flush();
        printWriter.close();
    }

    private String dealWithEntryResourceRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long l2, int n2, long l3) throws Exception {
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return "";
        }
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        httpServletResponse.setDateHeader("Expires", -10L);
        if (!UserControl.getInstance().hasEntryPrivilege(l2, n2, l3)) {
            throw new NoPrivilegeException();
        }
        Entry entry = EntryControl.getInstance().getEntry(n2, l3);
        if (n2 == 4) {
            entry = AnalysisEntryDAO.getInstance().findByID(l3);
        }
        if (entry == null) {
            throw new Exception("The entry or node doesn't exsit!");
        }
        UserCache.addToHistory(l2, new UserCache.IDText(WebUtils.getHTTPRequestParameter(httpServletRequest, "id"), WebUtils.getHTTPRequestParameter(httpServletRequest, "ftext"), entry.getShowType()));
        if (entry.getEntryType() == 4) {
            if (!supportFS) {
                throw new RegistEditionException(VT4FR.FS_BI);
            }
            return this.dealWithAnalysis((AnalysisEntry)entry, httpServletResponse);
        }
        if (entry.getEntryType() == 2) {
            if (!supportFS) {
                throw new RegistEditionException(VT4FR.FS_BI);
            }
            return this.dealWithReportlet((ReportletEntry)entry, httpServletRequest, httpServletResponse);
        }
        if (entry.getEntryType() == 3) {
            return this.dealWithUrl((URLEntry)entry, httpServletRequest, httpServletResponse);
        }
        if (entry.getEntryType() == 1) {
            return this.dealWithFile((FileEntry)entry, httpServletRequest, httpServletResponse);
        }
        if (entry.getEntryType() == 8) {
            return this.dealWithReportProcess((ReportProcessEntry)entry, httpServletRequest, httpServletResponse);
        }
        return "";
    }

    private String dealWithAnalysis(AnalysisEntry analysisEntry, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("popConfig", "null");
        ADHOCInitAnalysisPanelAction.initAnalysisPanel(analysisEntry.getTableDataName(), null, false, hashMap, httpServletResponse);
        return "";
    }

    private String dealWithReportlet(ReportletEntry reportletEntry, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object v2;
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(8);
        if (reportletEntry.getTransmitParameters() != null && (object = reportletEntry.getTransmitParameters().toArray()) != null) {
            for (int i2 = 0; i2 < ((Parameter[])object).length; ++i2) {
                hashMap.put(object[i2].getName(), object[i2].getValue());
            }
        }
        if (reportletEntry.isForm()) {
            object = StableFactory.createWeblet("FSFormlet", reportletEntry.getWebletPath(), hashMap);
            object.dealWeblet(httpServletRequest, httpServletResponse);
            return "";
        }
        object = reportletEntry.isReportletPage() ? ActorFactory.getActor("view") : (reportletEntry.isReportletWrite() ? ActorFactory.getActor("write") : ((v2 = hashMap.get("__bypagesize__")) != null && "false".equals(v2.toString()) ? ActorFactory.getActor("nopage") : ActorFactory.getActor("page")));
        hashMap.put("reportName", reportletEntry.getWebletPath());
        FSReportlet fSReportlet = new FSReportlet(reportletEntry.getWebletPath(), reportletEntry.getDisplayName(), hashMap, (Actor)object);
        H.A(httpServletRequest, httpServletResponse, fSReportlet, false);
        return "";
    }

    private String dealWithUrl(URLEntry uRLEntry, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = uRLEntry.getUrl();
        if (StringUtils.isEmpty(WebUtils.getHTTPRequestParameter(httpServletRequest, "isTree"))) {
            return string;
        }
        if (StringUtils.isNotEmpty(string) && Utils.isEmbeddedParameter(string)) {
            String string2 = Calendar.getInstance().getTime().toString().replaceAll(" ", "");
            httpServletRequest.getSession().setAttribute(string2, (Object)string);
            return string2;
        }
        return "";
    }

    private String dealWithFile(FileEntry fileEntry, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (StringUtils.isNotBlank(fileEntry.getPath())) {
            if (fileEntry.getPath().endsWith(".cpt")) {
                FSOutputReportlet fSOutputReportlet = new FSOutputReportlet(fileEntry.getPath(), fileEntry.getDisplayName());
                H.A(httpServletRequest, httpServletResponse, fSOutputReportlet, false);
            } else if (fileEntry.getPath().endsWith(".cpr")) {
                String string;
                ScheduleLinkOutputDAO scheduleLinkOutputDAO = ScheduleLinkOutputDAO.getInstance();
                ScheduleLinkOutput scheduleLinkOutput = scheduleLinkOutputDAO.findByFileEntryId(fileEntry.getId());
                List list = null;
                if (scheduleLinkOutput != null) {
                    list = scheduleLinkOutputDAO.findByOutputId(scheduleLinkOutput.getOutputId());
                }
                if (list != null) {
                    long l2 = scheduleLinkOutput.getFileEntryId();
                    FileEntry fileEntry2 = FileEntryDAO.getInstance().findByID(l2);
                    if (fileEntry2 != null) {
                        fileEntry = fileEntry2;
                    }
                }
                ScheduleUserAndCPRFile scheduleUserAndCPRFile = this.checkUserCPR(fileEntry);
                String string2 = this.getCurrentUserName(httpServletRequest);
                boolean bl = false;
                if (!scheduleUserAndCPRFile.isEmpty()) {
                    bl = true;
                }
                if (StringUtils.isNotBlank(string = scheduleUserAndCPRFile.getPath(string2))) {
                    fileEntry.setPath(string);
                } else if (bl) {
                    throw new NoPrivilegeException();
                }
                FSOutputReportlet fSOutputReportlet = new FSOutputReportlet(fileEntry.getPath(), fileEntry.getDisplayName());
                Map map = fSOutputReportlet.generatorParameters4CRPFile();
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = iterator.next().toString();
                    httpServletRequest.setAttribute(string3, map.get(string3));
                }
                H.A(httpServletRequest, httpServletResponse, fSOutputReportlet, !fSOutputReportlet.isPage());
            } else {
                this.dealWithFSDownload(httpServletResponse, fileEntry.getPath(), fileEntry.getDisplayName());
            }
        }
        return "";
    }

    private String dealWithReportProcess(ReportProcessEntry reportProcessEntry, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!VT4FR.isLicAvailable(StableUtils.getBytes()) || !VT4FR.MULTI_DATA_REPORT.support()) {
            throw new RegistEditionException(VT4FR.MULTI_DATA_REPORT);
        }
        int n2 = reportProcessEntry.getProcessType();
        String string = "/com/fr/web/core/process/reportprocess/web/";
        if (n2 == 1) {
            string = string + "rp_taskmgr.html";
        } else if (n2 == 2) {
            string = string + "rp_processmgr.html";
        } else if (n2 == 3) {
            string = string + "rp_mytask.html";
        }
        WebUtils.writeOutTemplate(string, httpServletResponse, Collections.EMPTY_MAP);
        return "";
    }

    private String getCurrentUserName(HttpServletRequest httpServletRequest) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        return UserControl.getInstance().getUser(l2).getUsername();
    }

    private ScheduleUserAndCPRFile checkUserCPR(FileEntry fileEntry) throws FileNotFoundException, Exception {
        ScheduleUserAndCPRFile scheduleUserAndCPRFile = new ScheduleUserAndCPRFile();
        File file = new File(fileEntry.getPath());
        File file2 = new File(file.getParentFile().getParent(), "usercpr.xml");
        if (!file2.exists() && !(file2 = new File(file.getParent(), "usercpr.xml")).exists()) {
            return scheduleUserAndCPRFile;
        }
        return (ScheduleUserAndCPRFile)BaseXMLUtils.readXMLFile(new FileInputStream(file2), (XMLFileReader)scheduleUserAndCPRFile);
    }

    private void dealWithFSDownload(HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        byte[] byArray = new byte[this.fivehundred];
        File file = new File(string);
        httpServletResponse.reset();
        string2 = string2 == null ? "file" : string2;
        httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + string2 + "\"");
        httpServletResponse.setContentType("application/x-download");
        long l2 = file.length();
        String string3 = String.valueOf(l2);
        httpServletResponse.setHeader("Content_Length", string3);
        FileInputStream fileInputStream = new FileInputStream(file);
        int n2 = 0;
        while ((n2 = fileInputStream.read(byArray)) != -1) {
            servletOutputStream.write(byArray, 0, n2);
        }
        fileInputStream.close();
        servletOutputStream.flush();
        if (servletOutputStream != null) {
            servletOutputStream.close();
        }
    }

    static {
        supportFS = VT4FR.isLicAvailable(StableUtils.getBytes()) && VT4FR.FS_BI.support();
    }
}

