/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.FSConfig;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.base.FSPrivilegeConstants;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.platform.entry.Entry;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSEntryRemoveReportAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "removereport";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasReportManagerModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "entryIds");
        try {
            this.delEntrys(string, l2);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.write(FSPrivilegeConstants.NOPRISTR);
            printWriter.flush();
            printWriter.close();
        }
    }

    private void delEntrys(String string, long l2) throws Exception {
        String[] stringArray = string.split(",");
        Set set = UserControl.getInstance().getAllEntryPrivileges(l2);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n2 = Integer.parseInt(stringArray[i2].substring(0, 1));
            int n3 = Integer.parseInt(stringArray[i2].substring(1));
            this.deleteEntry(set, n2, n3);
        }
    }

    private void deleteEntry(Set set, int n2, int n3) throws Exception {
        FSPrivilegeTools fSPrivilegeTools = FSPrivilegeTools.getInstance();
        Entry entry = EntryControl.getInstance().getEntry(n2, n3);
        if (!FSConfig.getInstance().isEditReportAuthority() && !fSPrivilegeTools.hasFolderEditPrivilege(set, EntryTypeAndID.getInstance(n2, entry.getParentId()))) {
            throw new NoPrivilegeException();
        }
        EntryControl.getInstance().deleteEntry(n2, n3);
    }
}

