/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.FSConfig;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSEntryRemoveFolderAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "removefolder";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasReportManagerModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "folderId");
        try {
            this.deleleFolderByParentId(string, l2);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.write("-1");
            printWriter.flush();
            printWriter.close();
        }
    }

    private void deleleFolderByParentId(String string, long l2) throws Exception {
        long l3 = Long.parseLong(string);
        if (!UserControl.getInstance().hasEntryPrivilege(l2, 0, l3)) {
            throw new NoPrivilegeException();
        }
        FSPrivilegeTools fSPrivilegeTools = FSPrivilegeTools.getInstance();
        Set set = UserControl.getInstance().getAllEntryPrivileges(l2);
        if (FSConfig.getInstance().isEditReportAuthority() && l2 != UserControl.getInstance().getSuperManagerID() && !fSPrivilegeTools.hasFolderEditPrivilege(set, EntryTypeAndID.getInstance(0, l3))) {
            throw new NoPrivilegeException();
        }
        EntryControl.getInstance().deleteEntry(0, l3);
    }
}

