/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.FRContext;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.privilege.Authentication;
import com.fr.privilege.authentication.AuthenticationFactory;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSEntryGetFolderAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "getfolder";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        Authentication authentication = AuthenticationFactory.exAuth4CommonAccess(httpServletRequest);
        if (!(ModuleControl.getInstance().hasReportManagerModulePrivilege(l2) || authentication != null && authentication.isRoot())) {
            throw new NoPrivilegeException();
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        String string = this.getFolderEntrys(l2).toString();
        printWriter.print(string);
        printWriter.flush();
        printWriter.close();
    }

    private JSONArray getFolderEntrys(long l2) throws Exception {
        JSONArray jSONArray = new JSONArray();
        try {
            JSONObject jSONObject = EntryControl.getInstance().getRootNode().createManagerJSONConfig(l2);
            if (jSONObject != null) {
                jSONArray.put(jSONObject);
            }
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
        return jSONArray;
    }
}

