/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.control.EntryControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.privilege.base.FSPrivilegeConstants;
import com.fr.fs.schedule.entry.ReportletEntry;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.FSEntryAddFolderAction;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSEntryAddReportAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "addreport";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasReportManagerModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "reportJason");
        try {
            string = this.saveOrUpdateReport(string2, l2).toString();
        }
        catch (NoPrivilegeException noPrivilegeException) {
            string = FSPrivilegeConstants.NOPRISTR;
        }
        printWriter.print(string);
        printWriter.flush();
        printWriter.close();
    }

    private JSONObject saveOrUpdateReport(String string, long l2) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        String string2 = jSONObject.getString("path");
        int n2 = string2.lastIndexOf(".");
        if (n2 >= 0 && this.isFRFile(string2.substring(n2))) {
            ReportletEntry reportletEntry = new ReportletEntry();
            reportletEntry.parseJSON(jSONObject);
            FSEntryAddFolderAction.checkSaveOrUpdateEntryPrivilege(reportletEntry, l2);
            EntryControl.getInstance().saveOrUpdateEntry(reportletEntry);
            return reportletEntry.createJSONConfig();
        }
        return null;
    }

    private boolean isFRFile(String string) {
        return ComparatorUtils.equals(string, ".cpt") || ComparatorUtils.equals(string, ".frm") || ComparatorUtils.equals(string, ".form");
    }
}

