/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.schedule.entry.FolderEntry;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.platform.entry.BaseEntry;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSEntryAddFolderAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "addfolder";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasReportManagerModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "folderJason");
        try {
            string = FSEntryAddFolderAction.saveOrUpdateFolder(string2, l2).toString();
        }
        catch (NoPrivilegeException noPrivilegeException) {
            string = "-1";
        }
        printWriter.print(string);
        printWriter.flush();
        printWriter.close();
    }

    public static JSONObject saveOrUpdateFolder(String string, long l2) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        FolderEntry folderEntry = new FolderEntry();
        folderEntry.parseJSON(jSONObject);
        FSEntryAddFolderAction.checkSaveOrUpdateEntryPrivilege(folderEntry, l2);
        EntryControl.getInstance().saveOrUpdateEntry(folderEntry);
        if (folderEntry.getParentId() < 0L) {
            HashSet<EntryTypeAndID> hashSet = new HashSet<EntryTypeAndID>();
            hashSet.add(EntryTypeAndID.getInstance(0, folderEntry.getId(), 1L, 1L, 1L));
            Set<CompanyRole> set = CompanyRoleControl.getInstance().getCompanyRoleSet(l2);
            for (CompanyRole object2 : set) {
                CompanyRoleControl.getInstance().updateEntryPrivileges(object2.getId(), hashSet, null);
            }
            Set set2 = CustomRoleControl.getInstance().getCustomRoleSet(l2);
            for (CustomRole customRole : set2) {
                CustomRoleControl.getInstance().updateEntryPrivileges(customRole.getId(), hashSet, null);
            }
        }
        return folderEntry.createJSONConfig();
    }

    public static void checkSaveOrUpdateEntryPrivilege(BaseEntry baseEntry, long l2) throws Exception {
        String string;
        FSPrivilegeTools fSPrivilegeTools = FSPrivilegeTools.getInstance();
        if (!FSConfig.getInstance().isEditReportAuthority() || l2 == UserControl.getInstance().getSuperManagerID()) {
            return;
        }
        Set set = UserControl.getInstance().getAllEntryPrivileges(l2);
        if (baseEntry.getId() < 0L ? !fSPrivilegeTools.hasFolderEditPrivilege(set, EntryTypeAndID.getInstance(0, baseEntry.getParentId())) : (ComparatorUtils.equals(string = EntryControl.getInstance().getEntry(baseEntry.getEntryType(), baseEntry.getId()).getDisplayName(), baseEntry.getDisplayName()) || baseEntry.getParentId() < 0L ? !fSPrivilegeTools.hasFolderEditPrivilege(set, EntryTypeAndID.getInstance(baseEntry.getEntryType(), baseEntry.getId())) : !fSPrivilegeTools.hasFolderEditPrivilege(set, EntryTypeAndID.getInstance(0, baseEntry.getParentId())))) {
            throw new NoPrivilegeException();
        }
    }
}

